/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolListener;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthFailure;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.Service;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class AuthenticationProtocolClient
extends Service {
    private static Logger d = Logger.getLogger("AuthenticationProtocolClient");
    private int[] e = new int[2];
    private int[] f = new int[3];
    private Vector g = new Vector();
    static Class a;
    static Class b;
    static Class c;

    public AuthenticationProtocolClient() {
        super("ssh-userauth");
        this.e[0] = 52;
        this.e[1] = 51;
        this.f[0] = 52;
        this.f[1] = 51;
    }

    protected void onServiceAccept() throws IOException {
    }

    protected void onStart() {
    }

    protected void onServiceInit(int startMode) throws IOException {
        if (startMode == 2) {
            throw new IOException("The Authentication Protocol client cannot be accepted");
        }
        this.messageStore.registerMessage(51, a == null ? (a = AuthenticationProtocolClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthFailure")) : a);
        this.messageStore.registerMessage(52, b == null ? (b = AuthenticationProtocolClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthSuccess")) : b);
        this.messageStore.registerMessage(53, c == null ? (c = AuthenticationProtocolClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner")) : c);
    }

    protected void onServiceRequest() throws IOException {
        throw new IOException("This class implements the client protocol only!");
    }

    public void addEventListener(AuthenticationProtocolListener listener) {
        if (listener != null) {
            this.g.add(listener);
        }
    }

    public List getAvailableAuths(String username, String serviceName) throws IOException {
        d.debug("Requesting authentication methods");
        SshMessage sshMessage = new SshMsgUserAuthRequest(username, serviceName, "none", null);
        this.transport.sendMessage(sshMessage, this);
        try {
            sshMessage = this.messageStore.getMessage(this.e, this.timeout);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new SshException("Timeout whilst waiting for an authentication message", messageNotAvailableException);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            return ((SshMsgUserAuthFailure)sshMessage).getAvailableAuthentications();
        }
        throw new IOException("None request returned success! Insecure feature not supported");
    }

    public int authenticate(SshAuthenticationClient auth, Service serviceToStart) throws IOException {
        try {
            Object object;
            if (!auth.canAuthenticate() && auth.canPrompt() && !(object = auth.getAuthenticationPrompt()).showPrompt(auth)) {
                return 5;
            }
            auth.authenticate(this, serviceToStart.getServiceName());
            object = this.a(this.messageStore.getMessage(this.e, this.timeout));
            throw new AuthenticationProtocolException("Unexpected authentication message " + ((SshMessage)object).getMessageName());
        }
        catch (TerminatedStateException terminatedStateException) {
            if (terminatedStateException.getState() == 4) {
                this.transport.setupCompression(true);
                serviceToStart.init(2, this.transport);
                serviceToStart.start();
                Iterator iterator = this.g.iterator();
                while (iterator.hasNext()) {
                    AuthenticationProtocolListener authenticationProtocolListener = (AuthenticationProtocolListener)iterator.next();
                    if (authenticationProtocolListener == null) continue;
                    authenticationProtocolListener.onAuthenticationComplete();
                }
            }
            return terminatedStateException.getState();
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new SshException("Timeout whilst waiting for an authentication message", messageNotAvailableException);
        }
    }

    public void sendMessage(SshMessage msg) throws IOException {
        this.transport.sendMessage(msg, this);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public void registerMessage(Class cls, int messageId) {
        this.messageStore.registerMessage(messageId, cls);
    }

    public SshMessage readMessage(int messageId) throws TerminatedStateException, IOException {
        this.f[2] = messageId;
        return this.a(this.f);
    }

    private SshMessage a(int[] nArray) throws TerminatedStateException, IOException {
        try {
            SshMessage sshMessage = this.messageStore.getMessage(nArray, this.timeout);
            return this.a(sshMessage);
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            throw new AuthenticationProtocolException("Failed to read messages", messageStoreEOFException);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new AuthenticationProtocolException("Failed to read messages", messageNotAvailableException);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
    }

    public SshMessage readMessage(int[] messageId) throws TerminatedStateException, IOException {
        int[] nArray = new int[messageId.length + this.e.length];
        System.arraycopy(this.e, 0, nArray, 0, this.e.length);
        System.arraycopy(messageId, 0, nArray, this.e.length, messageId.length);
        return this.a(nArray);
    }

    public void readAuthenticationState() throws IOException, TerminatedStateException {
        this.a(this.e);
    }

    private SshMessage a(SshMessage sshMessage) throws TerminatedStateException, IOException {
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            if (((SshMsgUserAuthFailure)sshMessage).getPartialSuccess()) {
                throw new TerminatedStateException(3);
            }
            throw new TerminatedStateException(2);
        }
        if (sshMessage instanceof SshMsgUserAuthSuccess) {
            throw new TerminatedStateException(4);
        }
        return sshMessage;
    }

    public String getBannerMessage(int timeout) throws IOException {
        try {
            d.debug("getBannerMessage is attempting to read the authentication banner");
            SshMessage sshMessage = this.messageStore.peekMessage(53, timeout);
            return ((SshMsgUserAuthBanner)sshMessage).getBanner();
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            return "";
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            d.error("Failed to retreive banner becasue the message store is EOF");
            return "";
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

