/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.j2ssh.ScpClient;
import com.enterprisedt.net.j2ssh.SftpClient;
import com.enterprisedt.net.j2ssh.SshEventAdapter;
import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient;
import com.enterprisedt.net.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.ChannelEventAdapter;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.connection.ChannelFactory;
import com.enterprisedt.net.j2ssh.connection.ConnectionProtocol;
import com.enterprisedt.net.j2ssh.session.SessionChannelClient;
import com.enterprisedt.net.j2ssh.sftp.SftpSubsystemClient;
import com.enterprisedt.net.j2ssh.sftp.SftpTransportProtocolEventHandler;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolClient;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolState;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.ProxySettings;
import com.enterprisedt.util.proxy.StreamSocket;
import com.enterprisedt.util.proxy.StreamSocketFactory;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SshClient {
    private static Logger a = Logger.getLogger("SshClient");
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final int DEFAULT_MAX_PACKET_SIZE = 32648;
    protected AuthenticationProtocolClient authentication;
    protected ConnectionProtocol connection;
    protected TransportProtocolClient transport;
    protected int authenticationState = 1;
    protected int socketTimeout = 60000;
    protected SshEventAdapter eventHandler = null;
    protected Vector activeChannels = new Vector();
    protected a activeChannelListener = new a(this);
    private Vector b = new Vector();
    private int c = 32648;

    public SshClient() {
        LoadProviders.init();
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.c = maxPacketSize;
        a.debug("Setting maxpacketsize=" + maxPacketSize);
    }

    public String getAuthenticationBanner(int timeout) throws IOException {
        if (this.authentication == null) {
            return "";
        }
        return this.authentication.getBannerMessage(timeout);
    }

    public List getAvailableAuthMethods(String username) throws IOException {
        if (this.authentication != null) {
            return this.authentication.getAvailableAuths(username, this.connection.getServiceName());
        }
        return null;
    }

    public boolean isConnected() {
        TransportProtocolState transportProtocolState = this.transport == null ? null : this.transport.getState();
        int n2 = transportProtocolState == null ? 5 : transportProtocolState.getValue();
        return n2 == 4 || n2 == 3;
    }

    public boolean isAuthenticated() {
        return this.authenticationState == 4;
    }

    public String getServerId() {
        return this.transport.getRemoteId();
    }

    public SshPublicKey getServerHostKey() {
        return this.transport.getServerHostKey();
    }

    public TransportProtocolState getConnectionState() {
        return this.transport.getState();
    }

    public int getRemoteEOL() {
        return this.transport.getRemoteEOL();
    }

    public void addEventHandler(SshEventAdapter eventHandler) {
        if (this.transport != null) {
            this.transport.addEventHandler(eventHandler);
            this.authentication.addEventListener(eventHandler);
        } else {
            this.eventHandler = eventHandler;
        }
    }

    public int getTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int milliseconds) {
        this.socketTimeout = milliseconds;
        if (this.connection != null) {
            this.connection.setTimeout(milliseconds);
        }
    }

    public String getRemoteEOLString() {
        return this.transport.getRemoteEOL() == 1 ? "\r\n" : "\n";
    }

    public SshConnectionProperties getConnectionProperties() {
        return this.transport.getProperties();
    }

    public int authenticate(SshAuthenticationClient auth) throws IOException {
        this.authenticationState = this.authentication.authenticate(auth, this.connection);
        return this.authenticationState;
    }

    public boolean acceptsKey(String username, SshPublicKey key) throws IOException {
        if (this.authenticationState != 4) {
            PublicKeyAuthenticationClient publicKeyAuthenticationClient = new PublicKeyAuthenticationClient();
            return publicKeyAuthenticationClient.acceptsKey(this.authentication, username, this.connection.getServiceName(), key);
        }
        throw new SshException("Authentication has been completed!");
    }

    public void connect(SshConnectionProperties properties, ProxySettings proxySettings, HostKeyVerification hostVerification) throws UnknownHostException, IOException {
        StreamSocket streamSocket = StreamSocketFactory.getConnectedSocket(properties.getHost(), properties.getPort(), this.socketTimeout, proxySettings);
        this.transport = new TransportProtocolClient(hostVerification, properties, this.socketTimeout);
        this.transport.addEventHandler(this.eventHandler);
        this.transport.startTransportProtocol(streamSocket);
        this.authentication = new AuthenticationProtocolClient();
        this.authentication.addEventListener(this.eventHandler);
        this.transport.requestService(this.authentication, this.socketTimeout);
        this.connection = new ConnectionProtocol();
        this.connection.setTimeout(this.socketTimeout);
    }

    public void close() throws IOException {
        if (this.transport != null) {
            this.transport.stop();
        }
    }

    public void setKexTimeout(long seconds) throws IOException {
        this.transport.setKexTimeout(seconds);
    }

    public void setKexTransferLimit(long kilobytes) throws IOException {
        this.transport.setKexTransferLimit(kilobytes);
    }

    public void setSendIgnore(boolean sendIgnore) {
        this.transport.setSendIgnore(sendIgnore);
    }

    public void sendIgnore() throws TransportProtocolException {
        this.transport.sendIgnore();
    }

    public void disconnect() {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.stop();
        }
        if (this.transport != null) {
            this.transport.disconnect("Terminating connection");
        }
    }

    public void disconnectImmediately() {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.stop();
        }
        if (this.transport != null) {
            this.transport.disconnectImmediately("Terminating connection");
        }
    }

    public long getOutgoingByteCount() {
        return this.transport.getOutgoingByteCount();
    }

    public long getIncomingByteCount() {
        return this.transport.getIncomingByteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveChannelCount() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            return this.activeChannels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveChannels() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            return (List)this.activeChannels.clone();
        }
    }

    public boolean hasActiveSession(String type) {
        Iterator iterator = this.activeChannels.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SessionChannelClient) || !((SessionChannelClient)e2).getSessionType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public SessionChannelClient getActiveSession(String type) throws IOException {
        Iterator iterator = this.activeChannels.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SessionChannelClient) || !((SessionChannelClient)e2).getSessionType().equals(type)) continue;
            return (SessionChannelClient)e2;
        }
        throw new IOException("There are no active " + type + " sessions");
    }

    public boolean isActiveChannel(Channel channel) {
        return this.activeChannels.contains(channel);
    }

    public SessionChannelClient openSessionChannel() throws IOException {
        return this.openSessionChannel(null);
    }

    public SessionChannelClient openSessionChannel(ChannelEventListener eventListener) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        SessionChannelClient sessionChannelClient = new SessionChannelClient();
        sessionChannelClient.addEventListener(this.activeChannelListener);
        if (!this.connection.openChannel(sessionChannelClient, eventListener)) {
            throw new SshException("The server refused to open a session");
        }
        return sessionChannelClient;
    }

    public SftpClient openSftpClient() throws IOException, FTPException {
        return this.openSftpClient(null, 0, null);
    }

    public SftpClient openSftpClient(String sftpSubsystemPath, int configFlags) throws IOException, FTPException {
        return this.openSftpClient(sftpSubsystemPath, configFlags, null);
    }

    public SftpClient openSftpClient(String sftpSubsystemPath, int configFlags, ChannelEventListener eventListener) throws IOException, FTPException {
        SftpClient sftpClient = new SftpClient(this, sftpSubsystemPath, this.c, configFlags, eventListener);
        this.b.add(sftpClient);
        SftpTransportProtocolEventHandler sftpTransportProtocolEventHandler = new SftpTransportProtocolEventHandler(sftpClient.a());
        this.transport.addEventHandler(sftpTransportProtocolEventHandler);
        return sftpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveSftpClient() {
        Vector vector = this.b;
        synchronized (vector) {
            return this.b.size() > 0;
        }
    }

    public SftpClient getActiveSftpClient() throws IOException {
        Vector vector = this.b;
        synchronized (vector) {
            if (this.b.size() > 0) {
                return (SftpClient)this.b.get(0);
            }
            throw new SshException("There are no active SFTP clients");
        }
    }

    public ScpClient openScpClient() throws IOException {
        return new ScpClient(new File(System.getProperty("user.home")), this, false, this.activeChannelListener);
    }

    public ScpClient openScpClient(File cwd) throws IOException {
        return new ScpClient(cwd, this, false, this.activeChannelListener);
    }

    public SftpSubsystemClient openSftpChannel(String sftpSubsystemPath, long maxLocalPacketSize, ChannelEventListener eventListener) throws IOException {
        SftpSubsystemClient sftpSubsystemClient = new SftpSubsystemClient();
        sftpSubsystemClient.setLocalPacketSize(maxLocalPacketSize);
        if (!this.openChannel(sftpSubsystemClient)) {
            throw new SshException("The SFTP subsystem failed to start");
        }
        if (!sftpSubsystemClient.initialize(sftpSubsystemPath)) {
            throw new SshException("The SFTP Subsystem could not be initialized");
        }
        return sftpSubsystemClient;
    }

    public boolean openChannel(Channel channel) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        return this.connection.openChannel(channel, this.activeChannelListener);
    }

    public void allowChannelOpen(String channelName, ChannelFactory cf) throws IOException {
        this.connection.addChannelFactory(channelName, cf);
    }

    public void denyChannelOpen(String channelName) throws IOException {
        this.connection.removeChannelFactory(channelName);
    }

    public byte[] sendGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        return this.connection.sendGlobalRequest(requestName, wantReply, requestData);
    }

    class a
    extends ChannelEventAdapter {
        private final SshClient a;

        a(SshClient sshClient) {
            this.a = sshClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelOpen(Channel channel) {
            Vector vector = this.a.activeChannels;
            synchronized (vector) {
                this.a.activeChannels.add(channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelClose(Channel channel) {
            Vector vector = this.a.activeChannels;
            synchronized (vector) {
                this.a.activeChannels.remove(channel);
            }
        }
    }
}

