/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class SSLFTPCertificateStore
implements List {
    private static Logger c = Logger.getLogger("SSLFTPCertificateStore");
    private Vector d = new Vector();
    private a e;
    static Class a;
    static Class b;

    public void importCertificates(String fileName) throws FileNotFoundException, IOException {
        try {
            if (this.a(fileName)) {
                this.importPEMFile(fileName);
            } else {
                this.importKeyStore(fileName);
            }
        }
        catch (SSLFTPCertificateException sSLFTPCertificateException) {
            String string = "Failed to read certificates from file '" + fileName + "': " + sSLFTPCertificateException.getMessage();
            c.error(string, sSLFTPCertificateException);
            throw new IOException(string);
        }
        catch (KeyStoreException keyStoreException) {
            String string = "Failed to read certificates from file '" + fileName + "': " + keyStoreException.getMessage();
            c.error(string, keyStoreException);
            throw new IOException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(String var1_1) throws FileNotFoundException {
        block11: {
            var2_2 = new BufferedReader(new FileReader(var1_1));
            try {
                try {
                    if (!WrappedObject.findObject(var2_2, "CERTIFICATE", null)) break block11;
                    var3_3 = true;
                    var5_5 = null;
                    if (var2_2 == null) return var3_3;
                }
                catch (IOException var3_4) {
                    var5_7 = null;
                    if (var2_2 == null) return false;
                    try {
                        var2_2.close();
                        return false;
                    }
                    catch (IOException var6_11) {
                        return false;
                    }
                }
            }
            catch (Throwable var4_13) {
                var5_8 = null;
                if (var2_2 == null) throw var4_13;
                ** try [egrp 2[TRYBLOCK] [5 : 60->67)] { 
lbl24:
                // 1 sources

                var2_2.close();
                throw var4_13;
lbl26:
                // 1 sources

                catch (IOException var6_12) {
                    // empty catch block
                }
                throw var4_13;
            }
            try {}
            catch (IOException var6_9) {
                // empty catch block
                return var3_3;
            }
            var2_2.close();
            return var3_3;
        }
        var5_6 = null;
        if (var2_2 == null) return false;
        try {}
        catch (IOException var6_10) {}
        var2_2.close();
        return false;
        return false;
    }

    public void importPEMFile(String fileName) throws FileNotFoundException, IOException, SSLFTPCertificateException {
        c.debug("importPEMFile(" + fileName + ")");
        FileInputStream fileInputStream = new FileInputStream(fileName);
        this.importPEMFile(fileInputStream);
        fileInputStream.close();
    }

    public void importPEMFile(InputStream inputStream) throws IOException, SSLFTPCertificateException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading root", byArray);
            X509Cert x509Cert = new X509Cert(byArray);
            this.d.add(new SSLFTPCertificate(x509Cert));
        }
        this.a();
    }

    public void exportPEMFile(String fileName) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        this.exportPEMFile(fileOutputStream);
        fileOutputStream.close();
    }

    public void exportPEMFile(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)iterator.next();
            bufferedWriter.write(sSLFTPCertificate.toString(true) + "\n");
            WrappedObject.writeHeader("CERTIFICATE", bufferedWriter);
            WrappedObject.writeObject(sSLFTPCertificate.getCertDER(), "CERTIFICATE", bufferedWriter);
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
    }

    public void importKeyStore(KeyStore keyStore) throws KeyStoreException, SSLFTPCertificateException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
            this.add(new SSLFTPCertificate(certificate));
        }
    }

    public void importKeyStore(String keystoreFile, String password) throws KeyStoreException, IOException, SSLFTPCertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fileInputStream = new FileInputStream(keystoreFile);
        char[] cArray = password != null ? password.toCharArray() : null;
        try {
            try {
                keyStore.load(fileInputStream, cArray);
                this.importKeyStore(keyStore);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLFTPCertificateException(noSuchAlgorithmException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLFTPCertificateException(certificateException.getMessage());
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    public void importKeyStore(String keystoreFile) throws KeyStoreException, IOException, SSLFTPCertificateException {
        this.importKeyStore(keystoreFile, null);
    }

    public void exportKeyStore(KeyStore keyStore) throws CertificateException, KeyStoreException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)iterator.next();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sSLFTPCertificate.writePEM(byteArrayOutputStream);
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
                String string = sSLFTPCertificate.getSubjectName().getCommonName();
                if (string == null) {
                    string = sSLFTPCertificate.getSubjectName().getOrganisationName();
                }
                keyStore.setCertificateEntry(string, certificate);
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                c.error("Error while exporting to KeyStore", iOException);
            }
        }
    }

    public void importDefaultKeyStore() throws KeyStoreException, IOException, SSLFTPException {
        String string = System.getProperty("javax.net.ssl.trustStore");
        if (string != null) {
            String string2 = System.getProperty("javax.net.ssl.trustStorePassword");
            this.importKeyStore(string, string2);
        } else {
            File file = new File(System.getProperty("java.home") + "/lib/security/jssecacerts");
            if (file.exists()) {
                this.importKeyStore(file.getPath());
            } else {
                this.importKeyStore(System.getProperty("java.home") + "/lib/security/cacerts");
            }
        }
    }

    private void a(Object object) {
        if (!(object instanceof SSLFTPCertificate)) {
            throw new ArrayStoreException("Cannot add an instance of " + object.getClass().toString() + " to a " + (a == null ? (a = SSLFTPCertificateStore.class$("com.enterprisedt.net.ftp.ssl.SSLFTPCertificateStore")) : a).toString() + " - must be " + (b == null ? (b = SSLFTPCertificateStore.class$("com.enterprisedt.net.ftp.ssl.SSLFTPCertificate")) : b).toString());
        }
    }

    public void add(int index, Object certificate) {
        this.a(certificate);
        this.d.add(index, certificate);
        this.a();
    }

    public boolean add(Object certificate) {
        this.a(certificate);
        this.d.add(certificate);
        this.a();
        return true;
    }

    public boolean addAll(Collection certificates) {
        Iterator iterator = certificates.iterator();
        while (iterator.hasNext()) {
            this.a(iterator.next());
        }
        this.d.addAll(certificates);
        this.a();
        return true;
    }

    public boolean addAll(int index, Collection certificates) {
        Iterator iterator = certificates.iterator();
        while (iterator.hasNext()) {
            this.a(iterator.next());
        }
        this.d.addAll(index, certificates);
        this.a();
        return true;
    }

    public void clear() {
        this.d.clear();
        this.a();
    }

    public boolean contains(Object certificate) {
        this.a(certificate);
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)certificate;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SSLFTPCertificate sSLFTPCertificate2 = (SSLFTPCertificate)iterator.next();
            if (!sSLFTPCertificate2.equals(sSLFTPCertificate)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection certificates) {
        Iterator iterator = certificates.iterator();
        while (iterator.hasNext()) {
            if (this.contains((SSLFTPCertificate)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        return this.d.get(index);
    }

    public SSLFTPCertificate getCertificate(int index) {
        return (SSLFTPCertificate)this.d.get(index);
    }

    public int indexOf(Object certificate) {
        return this.d.indexOf(certificate);
    }

    public int lastIndexOf(Object certificate) {
        return this.d.lastIndexOf(certificate);
    }

    public boolean isEmpty() {
        return this.d.isEmpty();
    }

    public Iterator iterator() {
        return this.d.iterator();
    }

    public ListIterator listIterator() {
        return this.d.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.d.listIterator(index);
    }

    public Object remove(int index) {
        Object e2 = this.d.remove(index);
        if (e2 != null) {
            this.a();
        }
        return e2;
    }

    public SSLFTPCertificate removeCertificate(int index) {
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)this.d.remove(index);
        if (sSLFTPCertificate != null) {
            this.a();
        }
        return sSLFTPCertificate;
    }

    public boolean remove(Object certificate) {
        if (this.d.remove(certificate)) {
            this.a();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection certificates) {
        if (this.d.removeAll(certificates)) {
            this.a();
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection certificates) {
        if (this.d.retainAll(certificates)) {
            this.a();
            return true;
        }
        return false;
    }

    public Object set(int index, Object certificate) {
        this.a(certificate);
        Object object = this.d.set(index, certificate);
        if (object != null) {
            this.a();
        }
        return object;
    }

    public int size() {
        return this.d.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.d.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.d.toArray();
    }

    public Object[] toArray(Object[] certificates) {
        return this.d.toArray(certificates);
    }

    public SSLFTPCertificate[] toCertificateArray() {
        SSLFTPCertificate[] sSLFTPCertificateArray = new SSLFTPCertificate[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sSLFTPCertificateArray[i2] = this.getCertificate(i2);
        }
        return sSLFTPCertificateArray;
    }

    void a(a a2) {
        this.e = a2;
    }

    void a() {
        if (this.e != null) {
            this.e.a(this);
        }
    }

    Vector b() {
        Vector<X509Cert> vector = new Vector<X509Cert>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            vector.add(((SSLFTPCertificate)iterator.next()).a());
        }
        return vector;
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static interface a {
        public void a(SSLFTPCertificateStore var1);
    }
}

