/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.j2ssh.util.Base64;
import com.enterprisedt.net.puretls.cert.X509Cert;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class SSLFTPCertificate {
    private X509Cert a;
    private byte[] b;
    private BigInteger c;
    private DistinguishedName d;
    private DistinguishedName e;
    private Date f;
    private Date g;
    private Vector h;

    SSLFTPCertificate(X509Cert certificate) throws SSLFTPCertificateException {
        this.a(certificate);
    }

    public SSLFTPCertificate(Certificate certificate) throws SSLFTPCertificateException {
        try {
            this.a(new X509Cert(certificate.getEncoded()));
        }
        catch (Exception exception) {
            throw new SSLFTPCertificateException(exception.getMessage());
        }
    }

    private void a(X509Cert x509Cert) throws SSLFTPCertificateException {
        this.a = x509Cert;
        this.b = x509Cert.getDER();
        this.c = x509Cert.getSerial();
        if (x509Cert.getSubjectName() != null) {
            try {
                this.d = new DistinguishedName(x509Cert.getSubjectName(), null);
            }
            catch (SSLFTPException sSLFTPException) {
                throw new SSLFTPCertificateException("Certificate has invalid subject name: " + sSLFTPException.getMessage());
            }
        }
        if (x509Cert.getIssuerName() != null) {
            try {
                this.e = new DistinguishedName(x509Cert.getIssuerName(), null);
            }
            catch (SSLFTPException sSLFTPException) {
                throw new SSLFTPCertificateException("Certificate has invalid issuer name: " + sSLFTPException.getMessage());
            }
        }
        this.f = x509Cert.getValidityNotBefore();
        this.g = x509Cert.getValidityNotAfter();
        this.h = new Vector();
        if (x509Cert.getExtensions() != null) {
            for (int i2 = 0; i2 < x509Cert.getExtensions().size(); ++i2) {
                com.enterprisedt.net.puretls.sslg.Extension extension = (com.enterprisedt.net.puretls.sslg.Extension)x509Cert.getExtensions().elementAt(i2);
                this.h.add(new Extension(extension, null));
            }
        }
    }

    X509Cert a() {
        return this.a;
    }

    public byte[] getCertDER() {
        return this.b;
    }

    public Vector getExtensions() {
        return this.h;
    }

    public DistinguishedName getIssuerName() {
        return this.e;
    }

    public BigInteger getSerial() {
        return this.c;
    }

    public DistinguishedName getSubjectName() {
        return this.d;
    }

    public Date getValidityNotAfter() {
        return this.g;
    }

    public Date getValidityNotBefore() {
        return this.f;
    }

    public void writePEM(OutputStream outStr) throws IOException {
        this.writePEM(new BufferedWriter(new OutputStreamWriter(outStr)));
    }

    public void writePEM(Writer writer) throws IOException {
        writer.write("-----BEGIN CERTIFICATE-----\n");
        writer.write(Base64.encodeBytes(this.b, false));
        writer.write("\n-----END CERTIFICATE-----\n");
        writer.flush();
    }

    private String a(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("=");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean showHeader) {
        StringBuffer stringBuffer = new StringBuffer();
        if (showHeader) {
            stringBuffer.append(this.d.getOrganisationName() + "\n");
            stringBuffer.append(this.a(this.d.getOrganisationName().length()) + "\n");
        } else if (this.d.getOrganisationName() != null) {
            stringBuffer.append("  Org Name = " + this.d.getOrganisationName() + "\n");
        }
        if (this.d.getOrganisationalUnit() != null) {
            stringBuffer.append("  Org Unit = " + this.d.getOrganisationalUnit() + "\n");
        }
        if (this.d.getCountry() != null) {
            stringBuffer.append("  Country  = " + this.d.getCountry() + "\n");
        }
        if (this.d.getState() != null) {
            stringBuffer.append("  State    = " + this.d.getState() + "\n");
        }
        if (this.d.getLocality() != null) {
            stringBuffer.append("  Locality = " + this.d.getLocality() + "\n");
        }
        if (this.d.getCommonName() != null) {
            stringBuffer.append("  CN       = " + this.d.getCommonName() + "\n");
        }
        if (this.getValidityNotBefore() != null) {
            stringBuffer.append("  Valid from  " + this.getValidityNotBefore().toString() + "\n");
        }
        if (this.getValidityNotAfter() != null) {
            stringBuffer.append("  Valid until " + this.getValidityNotAfter().toString() + "\n");
        }
        if (this.getSerial() != null) {
            stringBuffer.append("  Serial = " + this.getSerial().toString());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSLFTPCertificate)) {
            return false;
        }
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)obj;
        if (this.b.length != sSLFTPCertificate.b.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] == sSLFTPCertificate.b[i2]) continue;
            return false;
        }
        return true;
    }

    static class 1 {
    }

    public static class Extension {
        private byte[] a;
        private boolean b;
        private byte[] c;

        private Extension(com.enterprisedt.net.puretls.sslg.Extension extension) {
            this.a = extension.getOID();
            this.b = extension.isCritical();
            this.c = extension.getValue();
        }

        public boolean isCritical() {
            return this.b;
        }

        public byte[] getOID() {
            return this.a;
        }

        public byte[] getValue() {
            return this.c;
        }

        Extension(com.enterprisedt.net.puretls.sslg.Extension x0, 1 x1) {
            this(x0);
        }
    }

    public static class DistinguishedName {
        private byte[] a;
        private String b;
        private String c;
        private String d;
        private String e;
        private String f;
        private String g;

        private DistinguishedName(com.enterprisedt.net.puretls.sslg.DistinguishedName name) throws SSLFTPException {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i2 = 0; i2 < name.getName().size(); ++i2) {
                Vector vector = (Vector)name.getName().elementAt(i2);
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    String[] stringArray = (String[])vector.get(i3);
                    if (stringArray.length != 2) {
                        throw new SSLFTPException("AVA array must contain 2 elements.");
                    }
                    hashtable.put(stringArray[0], stringArray[1]);
                }
            }
            this.b = (String)hashtable.get("CN");
            this.c = (String)hashtable.get("O");
            this.d = (String)hashtable.get("OU");
            this.e = (String)hashtable.get("L");
            this.f = (String)hashtable.get("S");
            this.g = (String)hashtable.get("C");
        }

        public byte[] getDER() {
            return this.a;
        }

        public String getCountry() {
            return this.g;
        }

        public String getLocality() {
            return this.e;
        }

        public String getOrganisationalUnit() {
            return this.d;
        }

        public String getOrganisationName() {
            return this.c;
        }

        public String getState() {
            return this.f;
        }

        public String getCommonName() {
            return this.b;
        }

        DistinguishedName(com.enterprisedt.net.puretls.sslg.DistinguishedName x0, 1 x1) throws SSLFTPException {
            this(x0);
        }
    }
}

