/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.ssh.SSHFTPPublicKey;
import com.enterprisedt.net.ftp.ssh.d;
import com.enterprisedt.net.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.InvalidHostFileException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFile;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class SSHFTPValidator {
    private static Logger a = Logger.getLogger("SSHFTPValidator");
    private AbstractKnownHostsKeyVerification b = this.c();
    private boolean c = true;
    private SSHFTPPublicKey d = null;

    public boolean isPortsInKnownHosts() {
        return this.b.isPortsInKnownHosts();
    }

    public void setPortsInKnownHosts(boolean portsInKnownHosts) {
        this.b.setPortsInKnownHosts(portsInKnownHosts);
    }

    public void loadKnownHosts(String hostsFileName) throws FileNotFoundException, IOException {
        a.debug("Loading known hosts file " + hostsFileName);
        this.b.parse(hostsFileName);
    }

    public void loadKnownHosts(InputStream hostsStream) throws IOException {
        a.debug("Loading known hosts from stream");
        this.b.parse(hostsStream);
    }

    public void saveKnownHosts() throws IOException {
        a.debug("Saving to known hosts file " + this.b.getKnownhosts());
        this.b.saveHostFile();
    }

    public void saveKnownHosts(String knownHosts) throws IOException {
        a.debug("Saving to known hosts file " + knownHosts);
        this.b.saveHostFile(knownHosts);
    }

    public void addKnownHost(String hostName, String publicKeyFile) throws IOException, InvalidSshKeyException {
        a.debug("Adding known host '" + hostName + "'");
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(new File(publicKeyFile));
        this.b.allowHost(hostName, sshPublicKeyFile.toPublicKey(), false);
    }

    public void addKnownHost(String hostName, SSHFTPPublicKey publicKey) throws InvalidHostFileException, InvalidSshKeyException {
        a.debug("Adding known host '" + hostName + "'");
        this.b.allowHost(hostName, publicKey.a(), false);
    }

    public void addKnownHost(String hostName, InputStream publicKeyStream) throws IOException, InvalidSshKeyException {
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(publicKeyStream);
        this.b.allowHost(hostName, sshPublicKeyFile.toPublicKey(), true);
    }

    public void removeKnownHost(String hostName) {
        this.b.removeAllowedHost(hostName);
    }

    public void removeAllKnownHosts() {
        this.b.removeAllAllowedHosts();
    }

    protected boolean validate(String hostSpecifier, String fingerPrint, boolean hostKnown) {
        if (hostKnown) {
            a.debug("Denied " + hostSpecifier + ": Known host - Unknown algorithm.");
        } else {
            a.debug("Denied " + hostSpecifier + ": Unknown host.");
        }
        return false;
    }

    protected boolean validate(String hostSpecifier, SSHFTPPublicKey publicKey, boolean hostKnown) {
        if (hostKnown) {
            a.debug("Denied " + hostSpecifier + ": Known host - Unknown algorithm.");
        } else {
            a.debug("Denied " + hostSpecifier + ": Unknown host.");
        }
        return false;
    }

    private AbstractKnownHostsKeyVerification c() {
        return new d(this);
    }

    HostKeyVerification a() {
        return this.b;
    }

    public boolean isHostValidationEnabled() {
        return this.c;
    }

    public void setHostValidationEnabled(boolean hostValidationEnabled) {
        this.c = hostValidationEnabled;
    }

    public Hashtable getKnownHosts() {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.b.getKnownHostEntries().iterator();
        while (iterator.hasNext()) {
            AbstractKnownHostsKeyVerification.KnownHostsEntry knownHostsEntry = (AbstractKnownHostsKeyVerification.KnownHostsEntry)iterator.next();
            if (!(knownHostsEntry instanceof AbstractKnownHostsKeyVerification.HostEntry)) continue;
            AbstractKnownHostsKeyVerification.HostEntry hostEntry = (AbstractKnownHostsKeyVerification.HostEntry)knownHostsEntry;
            String string = hostEntry.getHostName();
            Hashtable<String, String> hashtable2 = (Hashtable<String, String>)hashtable.get(string);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<String, String>();
                hashtable.put(string, hashtable2);
            }
            SshPublicKey sshPublicKey = hostEntry.getPublicKey();
            hashtable2.put(sshPublicKey.getAlgorithmName(), sshPublicKey.getFingerprint());
        }
        return hashtable;
    }

    public String[] getKnownHostnames() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.b.getKnownHostEntries().iterator();
        while (iterator.hasNext()) {
            String string;
            AbstractKnownHostsKeyVerification.KnownHostsEntry knownHostsEntry;
            AbstractKnownHostsKeyVerification.KnownHostsEntry knownHostsEntry2 = (AbstractKnownHostsKeyVerification.KnownHostsEntry)iterator.next();
            if (knownHostsEntry2 instanceof AbstractKnownHostsKeyVerification.HostEntry) {
                knownHostsEntry = (AbstractKnownHostsKeyVerification.HostEntry)knownHostsEntry2;
                string = ((AbstractKnownHostsKeyVerification.HostEntry)knownHostsEntry).getHostName();
                hashSet.add(string);
                continue;
            }
            if (!(knownHostsEntry2 instanceof AbstractKnownHostsKeyVerification.HashedHostEntry)) continue;
            knownHostsEntry = (AbstractKnownHostsKeyVerification.HashedHostEntry)knownHostsEntry2;
            string = ((AbstractKnownHostsKeyVerification.HashedHostEntry)knownHostsEntry).getHashedHostName();
            hashSet.add(string);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public SSHFTPPublicKey[] getKnownHostKeys(String hostname) {
        ArrayList<SSHFTPPublicKey> arrayList = new ArrayList<SSHFTPPublicKey>();
        Iterator iterator = this.b.getKnownHostEntries().iterator();
        while (iterator.hasNext()) {
            AbstractKnownHostsKeyVerification.KnownHostsEntry knownHostsEntry = (AbstractKnownHostsKeyVerification.KnownHostsEntry)iterator.next();
            try {
                if (!knownHostsEntry.matches(hostname)) continue;
                arrayList.add(new SSHFTPPublicKey(knownHostsEntry.getPublicKey()));
            }
            catch (InvalidHostFileException invalidHostFileException) {
                a.warn("matching failed: " + invalidHostFileException.getMessage());
            }
        }
        return arrayList.toArray(new SSHFTPPublicKey[arrayList.size()]);
    }

    public SSHFTPPublicKey getHostPublicKey() {
        return this.d;
    }

    static SSHFTPPublicKey a(SSHFTPValidator sSHFTPValidator, SSHFTPPublicKey sSHFTPPublicKey) {
        sSHFTPValidator.d = sSHFTPPublicKey;
        return sSHFTPValidator.d;
    }

    static boolean a(SSHFTPValidator sSHFTPValidator) {
        return sSHFTPValidator.c;
    }

    static Logger b() {
        return a;
    }

    static SSHFTPPublicKey b(SSHFTPValidator sSHFTPValidator) {
        return sSHFTPValidator.d;
    }
}

