/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.ProxyParameters;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.ssh.PasswordChanger;
import com.enterprisedt.net.ftp.ssh.SSHAuthPrompt;
import com.enterprisedt.net.ftp.ssh.SSHFTPAlgorithm;
import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import com.enterprisedt.net.ftp.ssh.SSHFTPPublicKey;
import com.enterprisedt.net.ftp.ssh.SSHFTPValidator;
import com.enterprisedt.net.ftp.ssh.SSHPasswordPrompt;
import com.enterprisedt.net.ftp.ssh.b;
import com.enterprisedt.net.j2ssh.ScpClient;
import com.enterprisedt.net.j2ssh.SshClient;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolState;
import com.enterprisedt.net.j2ssh.authentication.KBIAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.PasswordAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.io.IOStreamConnector;
import com.enterprisedt.net.j2ssh.session.SessionChannelClient;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.license.EDTProduct;
import com.enterprisedt.util.license.LicensePropertiesBase;
import com.enterprisedt.util.license.LicensePropertiesFactory;
import com.enterprisedt.util.proxy.ProxySettings;
import com.enterprisedt.util.proxy.ProxyType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SCPClient {
    private static Logger b = Logger.getLogger("SCPClient");
    public static final int DEFAULT_PORT = 22;
    protected SshClient ssh = new SshClient();
    private ScpClient c;
    protected SshConnectionProperties connProps = new SshConnectionProperties();
    protected SSHFTPValidator validator = new SSHFTPValidator();
    protected SshAuthenticationClient authenticator = null;
    protected SshAuthenticationClient retryAuthenticator = null;
    protected String id;
    protected int downloadCount = 0;
    protected int uploadCount = 0;
    protected int deleteCount = 0;
    private final EDTProduct[] d = new EDTProduct[]{EDTProduct.EDTFTPJ_PRO, EDTProduct.INTEGRAL_FTP};
    protected LicensePropertiesBase license;
    protected ProxySettings proxySettings = new ProxySettings();
    static Class a;

    public SCPClient() {
        this.license = LicensePropertiesFactory.createLicenseProperties();
        this.license.checkLicence(this.d);
        b.debug(VersionDetails.report(this));
        this.connProps.setPort(22);
    }

    public void setConnectionProperties(SshConnectionProperties props) {
        this.connProps = props;
    }

    public SshConnectionProperties getConnectionProperties() {
        return this.connProps;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String system() throws FTPException, IOException {
        this.checkConnection(true);
        return this.ssh.getServerId();
    }

    public int getDownloadCount() {
        return this.downloadCount;
    }

    public void resetDownloadCount() {
        this.downloadCount = 0;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void resetUploadCount() {
        this.uploadCount = 0;
    }

    public int getDeleteCount() {
        return this.deleteCount;
    }

    public void resetDeleteCount() {
        this.deleteCount = 0;
    }

    public SSHFTPValidator getValidator() {
        return this.validator;
    }

    public void setValidator(SSHFTPValidator validator) throws FTPException {
        this.checkConnection(false);
        if (validator == null) {
            throw new NullPointerException("Cannot set SSHFTPValidator to null");
        }
        this.validator = validator;
    }

    public static SSHFTPPublicKey getHostPublicKey(String remoteHost) throws FTPException {
        return SCPClient.getHostPublicKey(remoteHost, 22);
    }

    public static SSHFTPPublicKey getHostPublicKey(String remoteHost, int remotePort) throws FTPException {
        SCPClient sCPClient = new SCPClient();
        sCPClient.setRemoteHost(remoteHost);
        sCPClient.setRemotePort(remotePort);
        sCPClient.setAuthentication("", "");
        try {
            sCPClient.connect();
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(a == null ? (a = SCPClient.class$("com.enterprisedt.net.ftp.ssh.SCPClient")) : a);
            logger.debug("Expected exception", exception);
        }
        return sCPClient.getValidator().getHostPublicKey();
    }

    public SSHFTPPublicKey getHostPublicKey() {
        return this.validator.getHostPublicKey();
    }

    public void setAuthentication(String userName, String password) throws FTPException {
        this.setAuthentication(userName, password, (PasswordChanger)null);
    }

    public void setAuthentication(String userName, String password, PasswordChanger pwdChanger) throws FTPException {
        this.checkConnection(false);
        PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
        passwordAuthenticationClient.setUsername(userName);
        passwordAuthenticationClient.setPassword(password);
        passwordAuthenticationClient.setPasswordChangePrompt(pwdChanger);
        this.authenticator = passwordAuthenticationClient;
        KBIAuthenticationClient kBIAuthenticationClient = new KBIAuthenticationClient();
        kBIAuthenticationClient.setUsername(userName);
        SSHAuthPrompt[] sSHAuthPromptArray = new SSHAuthPrompt[]{new SSHPasswordPrompt(password)};
        kBIAuthenticationClient.setKBIRequestHandler(new b(sSHAuthPromptArray));
        this.retryAuthenticator = kBIAuthenticationClient;
    }

    public void setAuthenticationChangePassword(String userName, String oldPassword, String newPassword) throws FTPException {
        this.checkConnection(false);
        PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
        passwordAuthenticationClient.setUsername(userName);
        passwordAuthenticationClient.setPassword(oldPassword);
        passwordAuthenticationClient.setNewPassword(newPassword);
        this.authenticator = passwordAuthenticationClient;
    }

    public void setAuthentication(String user, SSHAuthPrompt[] prompts) throws FTPException {
        this.checkConnection(false);
        this.retryAuthenticator = null;
        KBIAuthenticationClient kBIAuthenticationClient = new KBIAuthenticationClient();
        kBIAuthenticationClient.setUsername(user);
        kBIAuthenticationClient.setKBIRequestHandler(new b(prompts));
        this.authenticator = kBIAuthenticationClient;
        this.retryAuthenticator = kBIAuthenticationClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAuthentication(String keyFileName, String userName, String keyFilePassphrase) throws IOException, FTPException {
        FileInputStream fileInputStream = new FileInputStream(keyFileName);
        try {
            this.setAuthentication(fileInputStream, userName, keyFilePassphrase);
            Object var6_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    public void setAuthentication(InputStream inStr, String userName, String keyFilePassphrase) throws IOException, FTPException {
        this.checkConnection(false);
        this.retryAuthenticator = null;
        PublicKeyAuthenticationClient publicKeyAuthenticationClient = new PublicKeyAuthenticationClient();
        publicKeyAuthenticationClient.setUsername(userName);
        try {
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(inStr);
            if (sshPrivateKeyFile.isPassphraseProtected()) {
                if (keyFilePassphrase == null) {
                    throw new SSHFTPException("The key-file, " + sshPrivateKeyFile + ", is passphrase protected.  Please supply a passphrase.");
                }
                publicKeyAuthenticationClient.setKey(sshPrivateKeyFile.toPrivateKey(keyFilePassphrase));
            } else {
                publicKeyAuthenticationClient.setKey(sshPrivateKeyFile.toPrivateKey(null));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (FTPException fTPException) {
            throw fTPException;
        }
        catch (Exception exception) {
            b.error("Failed to read key-file", exception);
            throw new IOException("Failed to read key-file: " + exception.getMessage());
        }
        this.authenticator = publicKeyAuthenticationClient;
    }

    public void setAuthentication(String keyFileName, String userName, String keyFilePassphrase, String userPassword) throws IOException, FTPException {
        this.setAuthentication(keyFileName, userName, keyFilePassphrase);
        PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
        passwordAuthenticationClient.setUsername(userName);
        passwordAuthenticationClient.setPassword(userPassword);
        this.retryAuthenticator = passwordAuthenticationClient;
    }

    public void setAuthentication(String keyFileName, String userName, String keyFilePassphrase, String userPassword, boolean publicKeyFirst) throws IOException, FTPException {
        if (publicKeyFirst) {
            this.setAuthentication(keyFileName, userName, keyFilePassphrase, userPassword);
        } else {
            this.setAuthentication(keyFileName, userName, keyFilePassphrase);
            this.retryAuthenticator = this.authenticator;
            PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
            passwordAuthenticationClient.setUsername(userName);
            passwordAuthenticationClient.setPassword(userPassword);
            this.authenticator = passwordAuthenticationClient;
        }
    }

    protected void validateAlgorithms() throws SSHFTPException {
        if (this.getEnabledAlgorithms(0).length == 0) {
            throw new SSHFTPException("No cipher algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(1).length == 0) {
            throw new SSHFTPException("No compression algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(2).length == 0) {
            throw new SSHFTPException("No key-exchange algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(3).length == 0) {
            throw new SSHFTPException("No key-pair algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(4).length == 0) {
            throw new SSHFTPException("No MAC algorithms enabled.");
        }
        b.info("SCPClient settings validated.");
    }

    public SSHFTPAlgorithm[] getEnabledAlgorithms() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.connProps.getCipherFactory().getEnabledCiphers());
        arrayList.addAll(this.connProps.getCompressionFactory().getEnabledCompressions());
        arrayList.addAll(this.connProps.getKeyExchangeFactory().getEnabledKeyExchanges());
        arrayList.addAll(this.connProps.getKeyPairFactory().getEnabledKeyPairs());
        arrayList.addAll(this.connProps.getHmacFactory().getEnabledMacs());
        return this.a(arrayList);
    }

    public SSHFTPAlgorithm[] getEnabledAlgorithms(int algorithmType) throws SSHFTPException {
        List list = null;
        switch (algorithmType) {
            case 0: {
                list = this.connProps.getCipherFactory().getEnabledCiphers();
                break;
            }
            case 1: {
                list = this.connProps.getCompressionFactory().getEnabledCompressions();
                break;
            }
            case 2: {
                list = this.connProps.getKeyExchangeFactory().getEnabledKeyExchanges();
                break;
            }
            case 3: {
                list = this.connProps.getKeyPairFactory().getEnabledKeyPairs();
                break;
            }
            case 4: {
                list = this.connProps.getHmacFactory().getEnabledMacs();
                break;
            }
            default: {
                throw new SSHFTPException("No such algorithm type " + algorithmType);
            }
        }
        return this.a(list);
    }

    private SSHFTPAlgorithm[] a(List list) {
        SSHFTPAlgorithm[] sSHFTPAlgorithmArray = new SSHFTPAlgorithm[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            if (string == null) {
                throw new InternalError("Internal inconsistency getting algorithm " + string);
            }
            sSHFTPAlgorithmArray[i2] = SSHFTPAlgorithm.getAlgorithm(string);
        }
        return sSHFTPAlgorithmArray;
    }

    public void disableAllAlgorithms(int algorithmType) throws SSHFTPException {
        b.debug("Disabling all algorithms of type " + algorithmType);
        switch (algorithmType) {
            case 0: {
                this.connProps.getCipherFactory().disableAllCiphers();
                break;
            }
            case 1: {
                this.connProps.getCompressionFactory().disableAllCompressions();
                break;
            }
            case 2: {
                this.connProps.getKeyExchangeFactory().disableAllKeyExchanges();
                break;
            }
            case 3: {
                this.connProps.getKeyPairFactory().disableAllKeys();
                break;
            }
            case 4: {
                this.connProps.getHmacFactory().disableAllMacs();
            }
            default: {
                throw new InternalError("Internal inconsistency enabling algorithm type " + algorithmType);
            }
        }
    }

    public void disableAllAlgorithms() {
        b.debug("Disabling all algorithms.");
        this.connProps.getCipherFactory().disableAllCiphers();
        this.connProps.getCompressionFactory().disableAllCompressions();
        this.connProps.getKeyExchangeFactory().disableAllKeyExchanges();
        this.connProps.getKeyPairFactory().disableAllKeys();
        this.connProps.getHmacFactory().disableAllMacs();
    }

    public void setAlgorithmEnabled(SSHFTPAlgorithm algorithm, boolean enable) {
        b.debug((enable ? "Enabling " : "Disabling ") + algorithm);
        try {
            switch (algorithm.getType()) {
                case 0: {
                    this.connProps.getCipherFactory().setCipherEnabled(algorithm.getCode(), enable);
                    break;
                }
                case 1: {
                    this.connProps.getCompressionFactory().setCompressionEnabled(algorithm.getCode(), enable);
                    break;
                }
                case 2: {
                    this.connProps.getKeyExchangeFactory().setKeyExchangeEnabled(algorithm.getCode(), enable);
                    break;
                }
                case 3: {
                    this.connProps.getKeyPairFactory().setKeyEnabled(algorithm.getCode(), enable);
                    break;
                }
                case 4: {
                    this.connProps.getHmacFactory().setMacEnabled(algorithm.getCode(), enable);
                    break;
                }
                default: {
                    throw new InternalError("Internal inconsistency enabling algorithm (1) " + algorithm.getCode());
                }
            }
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            throw new InternalError("Internal inconsistency enabling algorithm (2) " + algorithm.getCode());
        }
    }

    public boolean isAlgorithmEnabled(SSHFTPAlgorithm algorithm) {
        switch (algorithm.getType()) {
            case 0: {
                return this.connProps.getCipherFactory().isCipherEnabled(algorithm.getCode());
            }
            case 1: {
                return this.connProps.getCompressionFactory().isCompressionEnabled(algorithm.getCode());
            }
            case 2: {
                return this.connProps.getKeyExchangeFactory().isKeyExchangeEnabled(algorithm.getCode());
            }
            case 3: {
                return this.connProps.getKeyPairFactory().isKeyEnabled(algorithm.getCode());
            }
            case 4: {
                return this.connProps.getHmacFactory().isMacEnabled(algorithm.getCode());
            }
        }
        throw new InternalError("Internal inconsistency enabling algorithm (1) " + algorithm.getCode());
    }

    public String getRemoteHost() {
        return this.connProps.getHost();
    }

    public void setRemoteHost(String remoteHost) throws FTPException {
        this.checkConnection(false);
        this.connProps.setHost(remoteHost);
    }

    public int getRemotePort() {
        return this.connProps.getPort();
    }

    public void setRemotePort(int port) throws FTPException {
        this.checkConnection(false);
        this.connProps.setPort(port);
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxyParams(ProxyParameters params) {
        this.proxySettings.setProxyAddress(params.getProxyHost());
        this.proxySettings.setProxyPort(params.getProxyPort());
        this.proxySettings.setProxyPassword(params.getProxyPassword());
        this.proxySettings.setProxyUserName(params.getProxyUsername());
    }

    public void setTransportProvider(int provider) {
        b.debug("setTransportProvider(" + provider + ")");
        if (provider == 1) {
            this.proxySettings.setProxyType(ProxyType.NO_PROXY);
        } else if (provider == 2) {
            this.proxySettings.setProxyType(ProxyType.HTTP);
        } else if (provider == 3) {
            this.proxySettings.setProxyType(ProxyType.SOCKS4);
        } else if (provider == 4) {
            this.proxySettings.setProxyType(ProxyType.SOCKS5);
        } else {
            b.error("Unknown provider type '" + provider + "' - defaulting to no proxy");
        }
    }

    public int getTransportProvider() {
        ProxyType proxyType = this.proxySettings.getProxyType();
        if (proxyType.equals(ProxyType.NO_PROXY)) {
            return 1;
        }
        if (proxyType.equals(ProxyType.HTTP)) {
            return 2;
        }
        if (proxyType.equals(ProxyType.SOCKS4)) {
            return 3;
        }
        if (proxyType.equals(ProxyType.SOCKS5)) {
            return 4;
        }
        return 0;
    }

    public int getTimeout() {
        return this.ssh.getTimeout();
    }

    public void setTimeout(int millis) throws FTPException {
        this.checkConnection(false);
        this.ssh.setSocketTimeout(millis);
    }

    public boolean isRekeyEnabled() {
        return this.connProps.isRekeyEnabled();
    }

    public void setRekeyEnabled(boolean enableRekey) {
        this.connProps.setRekeyEnabled(enableRekey);
    }

    public void setRekeyTransferLimit(long kilobytes) throws IOException {
        this.ssh.setKexTransferLimit(kilobytes);
        b.info("Set rekex limit to " + kilobytes + " kB");
    }

    public void connect() throws IOException, FTPException {
        this.connectSSH();
        this.c = new ScpClient(this.ssh, true, null);
    }

    protected void connectSSH() throws IOException, FTPException {
        this.checkConnection(false);
        if (this.getRemoteHost() == null) {
            throw new SSHFTPException("Remote host not set.");
        }
        if (this.authenticator == null) {
            throw new SSHFTPException("No user authenticator set.  Invoke one of the setAuthentication() methods before calling connect().");
        }
        this.validateAlgorithms();
        b.debug("Connecting to " + this.connProps.getHost() + ":" + this.connProps.getPort());
        this.ssh.connect(this.connProps, this.proxySettings, this.validator.a());
        b.debug("Connected ok - authenticating via " + this.authenticator.toString());
        int n2 = this.ssh.authenticate(this.authenticator);
        if (this.retryAuthenticator != null && (n2 == 2 || n2 == 3)) {
            b.info("Authentication " + AuthenticationProtocolState.toString(n2) + " - trying alternative method via " + this.retryAuthenticator.toString());
            n2 = this.ssh.authenticate(this.retryAuthenticator);
        }
        if (n2 != 4) {
            throw new SSHFTPException("Could not authenticate SSH client: " + AuthenticationProtocolState.toString(n2));
        }
    }

    public String executeCommand(String command) throws FTPException, IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        block7: {
            String string;
            this.checkConnection(true);
            SessionChannelClient sessionChannelClient = this.ssh.openSessionChannel();
            try {
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                IOStreamConnector iOStreamConnector = new IOStreamConnector(sessionChannelClient.getInputStream(), byteArrayOutputStream2);
                byteArrayOutputStream = new ByteArrayOutputStream();
                IOStreamConnector iOStreamConnector2 = new IOStreamConnector(sessionChannelClient.getStderrInputStream(), byteArrayOutputStream);
                if (!sessionChannelClient.executeCommand(command)) break block7;
                try {
                    iOStreamConnector.getState().waitForState(4, this.ssh.getTimeout());
                }
                catch (InterruptedException interruptedException) {
                    String string2 = "Failed to read output of command '" + command + "' (" + byteArrayOutputStream.toString().trim() + ")";
                    b.error(string2, interruptedException);
                    throw new IOException(string2);
                }
                if (byteArrayOutputStream.toString().length() > 0) {
                    String string3 = "Failed to execute command '" + command + "' (" + byteArrayOutputStream.toString().trim() + ")";
                    b.error(string3);
                    throw new FTPException(string3);
                }
                string = byteArrayOutputStream2.toString();
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                sessionChannelClient.close();
                throw throwable;
            }
            sessionChannelClient.close();
            return string;
        }
        String string = "Failed to execute command '" + command + "'";
        if (byteArrayOutputStream.toString().length() > 0) {
            string = string + "(" + byteArrayOutputStream.toString() + ")";
        }
        b.error(string);
        throw new FTPException(string);
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.connected()) {
            throw new SSHFTPException("The SSH client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.connected()) {
            throw new SSHFTPException("The SSH client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    public boolean connected() {
        return this.c != null;
    }

    private void a(String string) throws FTPException {
        if (string == null) {
            throw new FTPException("A remote filename must be supplied for this protocol (SFTP)");
        }
    }

    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.a(remoteFile);
        this.c.put(localPath, remoteFile, false);
        ++this.uploadCount;
        return remoteFile;
    }

    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        File file = new File(localPath);
        if (file.isDirectory()) {
            localPath = localPath + File.separator + remoteFile;
            b.debug("Setting local path to " + localPath);
        }
        this.c.get(localPath, remoteFile, false);
        ++this.downloadCount;
    }

    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        this.c = null;
        this.ssh.disconnect();
        this.ssh = new SshClient();
    }

    public void quitImmediately() throws IOException, FTPException {
        this.c = null;
        this.ssh.close();
        this.ssh = new SshClient();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("SCP").append(",").append(this.getRemoteHost()).append(",").append(this.getRemotePort()).append(",").append(this.getId()).append("]");
        return stringBuffer.toString();
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

