/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.script;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.script.CommandResult;
import com.enterprisedt.net.ftp.script.ScriptCommandImpl;
import com.enterprisedt.net.ftp.script.ScriptEngine;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import java.io.IOException;

public class AuthCommand
extends ScriptCommandImpl {
    public CommandResult execute(ScriptEngine engine, ProFTPClientInterface ftp, String command, String args) throws IOException, FTPException {
        if (!engine.getProtocol().equals(Protocol.FTP)) {
            String string = "auth can only be called for the ftp protocol";
            return new CommandResult(true, string, string);
        }
        String string = null;
        if (args.equalsIgnoreCase("tls")) {
            string = "TLS";
        } else if (args.equalsIgnoreCase("tls-c")) {
            string = "TLS-C";
        } else if (args.equalsIgnoreCase("ssl")) {
            string = "SSL";
        } else {
            String string2 = "'" + args + "' is not one of tls,tls-c or ssl";
            return new CommandResult(true, string2, string2);
        }
        ((SSLFTPClient)ftp).auth(string);
        engine.setProtocol(Protocol.FTPS_EXPLICIT);
        return new CommandResult("auth successful", "Connection now secure");
    }

    public String helpMessage() {
        return "auth - Change from unencrypted 'plain' FTP into secure FTP. Supported options are ssl, tls, or tls-c. e.g. auth tls";
    }
}

