/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.pro;

import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.ProxyServerSocket;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;

public class ProFTPActiveDataSocket
implements FTPDataSocket {
    public static String cvsId = "@(#)$Id: ProFTPActiveDataSocket.java,v 1.1 2009-07-17 02:57:39 bruceb Exp $";
    private static Logger a = Logger.getLogger("ProFTPActiveDataSocket");
    protected ProxyServerSocket sock = null;
    protected StreamSocket acceptedSock = null;
    protected int sendBufferSize = 0;

    public ProFTPActiveDataSocket(ProxyServerSocket sock) {
        this.sock = sock;
    }

    public void setTimeout(int millis) throws IOException {
        this.sock.setSoTimeout(millis);
        if (this.acceptedSock != null) {
            this.acceptedSock.setSoTimeout(millis);
        }
    }

    public void setReceiveBufferSize(int size) throws IOException {
        this.sock.setReceiveBufferSize(size);
        if (this.acceptedSock != null) {
            this.acceptedSock.setReceiveBufferSize(size);
        }
    }

    public void setSendBufferSize(int size) throws IOException {
        this.sendBufferSize = size;
        if (this.acceptedSock != null) {
            this.acceptedSock.setSendBufferSize(size);
        }
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        try {
            return this.sock.getLocalAddress();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void acceptConnection() throws IOException {
        a.debug("Calling accept()");
        this.acceptedSock = this.sock.acceptConnection();
        this.acceptedSock.setSoTimeout(this.sock.getSoTimeout());
        this.acceptedSock.setReceiveBufferSize(this.sock.getReceiveBufferSize());
        if (this.sendBufferSize > 0) {
            this.acceptedSock.setSendBufferSize(this.sendBufferSize);
        }
        a.debug("accept() succeeded");
    }

    public OutputStream getOutputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getInputStream();
    }

    public void close() throws IOException {
        this.closeChild();
        this.sock.close();
        a.debug("close() succeeded");
    }

    public void closeChild() throws IOException {
        if (this.acceptedSock != null) {
            this.acceptedSock.close();
            this.acceptedSock = null;
            a.debug("closeChild() succeeded");
        }
    }
}

