/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.internal;

import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPActiveDataSocket
implements FTPDataSocket {
    public static String cvsId = "@(#)$Id: FTPActiveDataSocket.java,v 1.4 2009-09-02 22:02:24 bruceb Exp $";
    private static Logger a = Logger.getLogger("FTPActiveDataSocket");
    protected ServerSocket sock = null;
    protected Socket acceptedSock = null;
    protected int sendBufferSize = 0;
    private InetAddress b = null;

    public FTPActiveDataSocket(ServerSocket sock) {
        this.sock = sock;
    }

    public void setTimeout(int millis) throws IOException {
        this.sock.setSoTimeout(millis);
        if (this.acceptedSock != null) {
            this.acceptedSock.setSoTimeout(millis);
        }
    }

    public void setReceiveBufferSize(int size) throws IOException {
        this.sock.setReceiveBufferSize(size);
        if (this.acceptedSock != null) {
            this.acceptedSock.setReceiveBufferSize(size);
        }
    }

    public void setSendBufferSize(int size) throws IOException {
        this.sendBufferSize = size;
        if (this.acceptedSock != null) {
            this.acceptedSock.setSendBufferSize(size);
        }
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        if (this.b != null) {
            return this.b;
        }
        return this.sock.getInetAddress();
    }

    public void setLocalAddress(InetAddress addr) {
        this.b = addr;
    }

    protected void acceptConnection() throws IOException {
        a.debug("Calling accept()");
        this.acceptedSock = this.sock.accept();
        this.acceptedSock.setSoTimeout(this.sock.getSoTimeout());
        this.acceptedSock.setReceiveBufferSize(this.sock.getReceiveBufferSize());
        if (this.sendBufferSize > 0) {
            this.acceptedSock.setSendBufferSize(this.sendBufferSize);
        }
        a.debug("accept() succeeded");
    }

    public OutputStream getOutputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getInputStream();
    }

    public void close() throws IOException {
        this.closeChild();
        this.sock.close();
        a.debug("close() succeeded");
    }

    public void closeChild() throws IOException {
        if (this.acceptedSock != null) {
            this.acceptedSock.close();
            this.acceptedSock = null;
            a.debug("closeChild() succeeded");
        }
    }
}

