/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.async.AsyncEventListener;
import com.enterprisedt.net.ftp.async.RemoteFileResult;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;
import java.util.Vector;

public abstract class SingleTransferTask
extends Task
implements FTPProgressMonitorEx {
    private static Logger a = Logger.getLogger("SingleTransferTask");
    protected Vector monitors = new Vector();
    protected long lastNotifyTime = 0L;
    protected RemoteFileResult result;

    SingleTransferTask(FTPTaskProcessor taskProcessor, RemoteFileResult result, TaskType taskType) {
        super(taskProcessor, taskType, result);
        this.result = result;
    }

    public void addProgressMonitor(AsyncEventListener monitor) {
        this.monitors.addElement(monitor);
    }

    public void clearProgressMonitors() {
        this.monitors.removeAllElements();
    }

    protected Vector getMonitors() {
        return this.monitors;
    }

    protected void setupProgressMonitoring(long interval) {
        this.connection.getClient().setProgressMonitorEx(this);
        this.connection.getClient().setMonitorInterval(interval);
    }

    public void transferStarted(TransferDirection direction, String remoteFile) {
        this.lastNotifyTime = System.currentTimeMillis();
        for (int i2 = 0; i2 < this.monitors.size(); ++i2) {
            AsyncEventListener asyncEventListener = (AsyncEventListener)this.monitors.elementAt(i2);
            asyncEventListener.onTransferStarted(this.result);
        }
        if (this.connection.getListener() != null) {
            if (direction.equals(TransferDirection.DOWNLOAD)) {
                this.connection.getListener().downloadStarted(this.connection.getClient().getId(), remoteFile);
            } else {
                this.connection.getListener().uploadStarted(this.connection.getClient().getId(), remoteFile);
            }
        }
    }

    public void transferComplete(TransferDirection direction, String remoteFile) {
        for (int i2 = 0; i2 < this.monitors.size(); ++i2) {
            AsyncEventListener asyncEventListener = (AsyncEventListener)this.monitors.elementAt(i2);
            asyncEventListener.onTransferCompleted(this.result);
        }
        if (this.connection.getListener() != null) {
            if (direction.equals(TransferDirection.DOWNLOAD)) {
                this.connection.getListener().downloadCompleted(this.connection.getClient().getId(), remoteFile);
            } else {
                this.connection.getListener().uploadCompleted(this.connection.getClient().getId(), remoteFile);
            }
        }
    }

    public void bytesTransferred(long count) {
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastNotifyTime >= (long)this.result.getMinTransferNotifyPeriod()) {
            this.lastNotifyTime = l2;
            for (int i2 = 0; i2 < this.monitors.size(); ++i2) {
                AsyncEventListener asyncEventListener = (AsyncEventListener)this.monitors.elementAt(i2);
                asyncEventListener.onTransferredBytes(this.result, count);
            }
            if (this.connection.getListener() != null) {
                this.connection.getListener().bytesTransferred(this.connection.getClient().getId(), this.result.getRemoteFileName(), count);
            }
        }
    }

    public synchronized boolean cancel() {
        TaskState taskState = this.getState();
        a.debug("cancel called for task id=" + this.getId() + ",state=" + taskState.getState());
        if (taskState.equals(TaskState.PENDING_STATE)) {
            a.debug("Discarding task");
            this.setState(TaskState.DISCARDED_STATE);
            return true;
        }
        if (taskState.equals(TaskState.RUNNING_STATE)) {
            this.setState(TaskState.INTERRUPTED_STATE);
            if (this.connection.getClient() != null) {
                a.debug("Interrupting transfer");
                this.connection.getClient().cancelTransfer();
            }
            return false;
        }
        return false;
    }
}

