/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.util.PathUtils;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public final class FTPConnection {
    private static Logger a = Logger.getLogger("FTPConnection");
    private int b = ++c;
    private static int c = 0;
    private String d = "FTPConnection #" + this.b;
    private ProFTPClientInterface e;
    private EventListener f;
    private SecureConnectionContext g;
    private long h = 0L;
    private long i = 0L;

    public FTPConnection(ProFTPClientInterface ftp, SecureConnectionContext context) {
        this.e = ftp;
        this.g = context;
    }

    public SecureConnectionContext getContext() {
        return this.g;
    }

    public ProFTPClientInterface getClient() {
        return this.e;
    }

    public EventListener getListener() {
        return this.f;
    }

    public void setListener(EventListener listener) {
        this.f = listener;
    }

    public boolean isConnected() {
        try {
            this.getClient().keepAlive();
            this.setLastWokenTime(System.currentTimeMillis());
            return this.getClient().connected();
        }
        catch (Throwable throwable) {
            a.warn("keepAlive() failed - trashing connection: " + throwable.getMessage());
            try {
                this.getClient().quitImmediately();
            }
            catch (Exception exception) {
                a.warn("Failed to shutdown connection: " + exception.getMessage());
            }
            return false;
        }
    }

    public long getLastUsedTime() {
        return this.h;
    }

    public void setLastUsedTime(long lastUsedTime) {
        this.h = lastUsedTime;
    }

    public long getLastWokenTime() {
        return this.i;
    }

    public void setLastWokenTime(long lastWokenTime) {
        this.i = lastWokenTime;
    }

    public void setDirectory(String remoteDir) throws IOException, FTPException {
        if (this.g.getRemoteDirectory() == null || !this.g.getRemoteDirectory().equals(remoteDir)) {
            a.debug("Changing context dir to " + remoteDir);
            this.e.chdir(remoteDir);
            this.g.setRemoteDirectory(remoteDir);
        }
    }

    public String convertPath(String path) throws IOException, FTPException {
        if (!this.g.changeIntoPathDirectory()) {
            return path;
        }
        if (path == null) {
            return null;
        }
        String string = PathUtils.getDirectoryName(path);
        if (string != null) {
            if (!string.startsWith("/")) {
                string = PathUtils.combine(this.g.getRemoteDirectory(), string);
            }
            this.setDirectory(string);
        }
        String string2 = PathUtils.getFileName(path);
        a.debug("Converted " + path + " to " + string2);
        return string2;
    }

    public String toString() {
        return this.d;
    }
}

