/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async;

import com.enterprisedt.net.ftp.AsyncFileTransferClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.FTPOperationDiscardedException;
import com.enterprisedt.net.ftp.async.FTPOperationInterruptedException;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public abstract class AsyncResult {
    private static Logger a = Logger.getLogger("AsyncResult");
    private Throwable b;
    private Object c = new Object();
    private boolean d = false;
    private boolean e = false;
    private boolean f = false;
    private Object g;
    private Task h;
    private AsyncFileTransferClient i;
    private SecureConnectionContext j;

    public SecureConnectionContext getLocalContext() {
        return this.j;
    }

    public void setLocalContext(SecureConnectionContext localContext) {
        this.j = localContext;
    }

    public AsyncFileTransferClient getClient() {
        return this.i;
    }

    public void setClient(AsyncFileTransferClient asyncClient) {
        this.i = asyncClient;
    }

    public void setTag(Object tag) {
        this.g = tag;
    }

    public Object getTag() {
        return this.g;
    }

    public String getTaskDescription() {
        return this.h == null ? null : this.h.toString();
    }

    public boolean isSuccessful() {
        return this.e;
    }

    public void setSuccessful(boolean success) {
        this.e = success;
    }

    public void setTask(Task task) {
        this.h = task;
    }

    public Task getTask() {
        return this.h;
    }

    public boolean cancelTask() throws FTPException {
        if (this.h == null) {
            throw new FTPException("Unable to cancel task");
        }
        return this.h.cancel();
    }

    public int getTaskId() {
        return this.h != null ? this.h.getId() : -1;
    }

    public Throwable getThrowable() {
        return this.b;
    }

    public boolean endAsyncCalled() {
        return this.f;
    }

    protected void setEndAsyncCalled() {
        this.f = true;
    }

    public boolean isCompleted() {
        return this.d;
    }

    public void setThrowable(Throwable throwable) {
        this.b = throwable;
    }

    public void setAsIfCompleted() {
        this.setEndAsyncCalled();
        this.notifyComplete();
        this.setSuccessful(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitTillComplete() {
        a.debug("waitTillComplete() called: " + this.toString());
        Object object = this.c;
        synchronized (object) {
            try {
                if (!this.d) {
                    a.debug("Waiting until operation complete - " + this.getClass().getName());
                    this.c.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                a.error("Wait for task completion", interruptedException);
            }
        }
        a.debug("waitTillComplete() exit: " + this.toString());
    }

    protected void endAsyncInternal() throws FTPException, IOException {
        this.waitTillComplete();
        this.setEndAsyncCalled();
        if (this.h != null && this.h.getState().equals(TaskState.INTERRUPTED_STATE)) {
            throw new FTPOperationInterruptedException(this.h.toString() + " interrupted while running");
        }
        if (this.h != null && this.h.getState().equals(TaskState.DISCARDED_STATE)) {
            throw new FTPOperationDiscardedException(this.h.toString() + " discarded before being scheduled to run");
        }
        Throwable throwable = this.getThrowable();
        if (throwable == null) {
            return;
        }
        if (throwable instanceof FTPException) {
            throw (FTPException)throwable;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new FTPException(throwable.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyComplete() {
        Object object = this.c;
        synchronized (object) {
            a.debug("notifyComplete() called: " + this.toString());
            this.d = true;
            this.c.notifyAll();
        }
    }
}

