/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.ParseException;

public class RecursiveOperations {
    public static String cvsId = "@(#)$Id: RecursiveOperations.java,v 1.26 2010-03-31 00:51:04 bruceb Exp $";
    private static Logger a = Logger.getLogger("RecursiveOperations");
    private boolean b = false;
    private int c = 100;
    private int d = 60;
    private int e = 0;

    public int getCountBeforeSleep() {
        return this.c;
    }

    public void setCountBeforeSleep(int countBeforeSleep) {
        this.c = countBeforeSleep;
    }

    public boolean isSleepEnabled() {
        return this.b;
    }

    public void setSleepEnabled(boolean sleepEnabled) {
        this.b = sleepEnabled;
    }

    public int getSleepTime() {
        return this.d;
    }

    public void setSleepTime(int sleepTime) {
        this.d = sleepTime;
    }

    public FTPFile[] dirDetails(FTPClientInterface ftp, String remoteDir) throws IOException, FTPException, ParseException {
        boolean bl;
        boolean bl2 = bl = remoteDir != null && remoteDir != "" && remoteDir != ".";
        if (bl) {
            ftp.chdir(remoteDir);
        }
        FTPFile[] fTPFileArray = ftp.dirDetails("");
        for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
            if (!fTPFileArray[i2].isDir()) continue;
            fTPFileArray[i2].a(this.dirDetails(ftp, fTPFileArray[i2].getName()));
        }
        if (bl) {
            ftp.cdup();
        }
        return fTPFileArray;
    }

    public void delete(FTPClientInterface ftp, String remoteDir) throws IOException, FTPException, ParseException {
        boolean bl = remoteDir != null && remoteDir != "" && remoteDir != ".";
        FTPFile[] fTPFileArray = ftp.dirDetails(remoteDir);
        if (bl) {
            ftp.chdir(remoteDir);
        }
        for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
            if (!this.a(fTPFileArray[i2].getName())) continue;
            if (fTPFileArray[i2].isDir()) {
                this.delete(ftp, fTPFileArray[i2].getName());
                continue;
            }
            ftp.delete(fTPFileArray[i2].getName());
        }
        if (bl) {
            ftp.cdup();
            ftp.rmdir(remoteDir);
        }
    }

    public void deleteFilesCurrentDir(FTPClientInterface ftp, FileFilter filter) throws IOException, FTPException, ParseException {
        FTPFile[] fTPFileArray = ftp.dirDetails("");
        for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
            File file;
            if (fTPFileArray[i2].isDir() || !filter.accept(file = new File(fTPFileArray[i2].getName()))) continue;
            ftp.delete(fTPFileArray[i2].getName());
        }
    }

    public void deleteFiles(FTPClientInterface ftp, String remoteDir, FileFilter filter, boolean recurse) throws IOException, FTPException, ParseException {
        boolean bl;
        boolean bl2 = bl = remoteDir != null && remoteDir != "" && remoteDir != ".";
        if (!recurse) {
            if (bl) {
                ftp.chdir(remoteDir);
            }
            this.deleteFilesCurrentDir(ftp, filter);
            if (bl) {
                ftp.cdup();
            }
        } else {
            this.deleteFiles(ftp, remoteDir, filter);
        }
    }

    public void deleteFiles(FTPClientInterface ftp, FileFilter filter, boolean recurse) throws IOException, FTPException, ParseException {
        if (!recurse) {
            this.deleteFilesCurrentDir(ftp, filter);
        } else {
            FTPFile[] fTPFileArray = ftp.dirDetails("");
            for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
                if (!this.a(fTPFileArray[i2].getName())) continue;
                if (fTPFileArray[i2].isDir()) {
                    this.deleteFiles(ftp, fTPFileArray[i2].getName(), filter);
                    continue;
                }
                File file = new File(fTPFileArray[i2].getName());
                if (!filter.accept(file)) continue;
                ftp.delete(fTPFileArray[i2].getName());
            }
        }
    }

    public void deleteFiles(FTPClientInterface ftp, String remoteDir, FileFilter filter) throws IOException, FTPException, ParseException {
        boolean bl = remoteDir != null && remoteDir != "" && remoteDir != ".";
        FTPFile[] fTPFileArray = ftp.dirDetails(remoteDir);
        if (bl) {
            ftp.chdir(remoteDir);
        }
        for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
            if (!this.a(fTPFileArray[i2].getName())) continue;
            if (fTPFileArray[i2].isDir()) {
                this.deleteFiles(ftp, fTPFileArray[i2].getName(), filter);
                continue;
            }
            File file = new File(fTPFileArray[i2].getName());
            if (!filter.accept(file)) continue;
            ftp.delete(fTPFileArray[i2].getName());
        }
        if (bl) {
            ftp.cdup();
        }
    }

    public void deleteFiles(FTPClientInterface ftp, String remoteDir, String wildcard) throws IOException, FTPException, ParseException {
        WildcardFilter wildcardFilter = new WildcardFilter(wildcard);
        wildcardFilter.setDirectoriesAlwaysMatch(true);
        this.deleteFiles(ftp, remoteDir, wildcardFilter);
    }

    public void getFilesFromCurrentDir(FTPClientInterface ftp, String localDir, FileFilter filter) throws IOException, FTPException, ParseException {
        File file = new File(localDir);
        file.mkdir();
        FTPFile[] fTPFileArray = ftp.dirDetails("");
        for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
            this.a();
            if (fTPFileArray[i2].isDir()) continue;
            File file2 = new File(fTPFileArray[i2].getName());
            if (filter != null && (filter == null || !filter.accept(file2))) continue;
            this.a(ftp, file.getAbsolutePath(), fTPFileArray[i2].getName());
        }
    }

    public void get(FTPClientInterface ftp, String localDir, String remoteDir) throws IOException, FTPException, ParseException {
        File file = new File(localDir);
        this.a(ftp, file.getParent(), file.getName(), remoteDir, null);
    }

    public void get(FTPClientInterface ftp, String localDir, String remoteDir, FileFilter filter) throws IOException, FTPException, ParseException {
        File file = new File(localDir);
        this.a(ftp, file.getParent(), file.getName(), remoteDir, filter);
    }

    public void get(FTPClientInterface ftp, String localDir, String remoteDir, String wildcard) throws IOException, FTPException, ParseException {
        File file = new File(localDir);
        WildcardFilter wildcardFilter = new WildcardFilter(wildcard);
        wildcardFilter.setDirectoriesAlwaysMatch(true);
        this.a(ftp, file.getParent(), file.getName(), remoteDir, wildcardFilter);
    }

    public void get(FTPClientInterface ftp, String localDir, String remoteDir, FileFilter filter, boolean recurse) throws IOException, FTPException, ParseException {
        boolean bl;
        boolean bl2 = bl = remoteDir != null && remoteDir != "" && remoteDir != ".";
        if (!recurse) {
            if (bl) {
                ftp.chdir(remoteDir);
            }
            this.getFilesFromCurrentDir(ftp, localDir, filter);
            if (bl) {
                ftp.cdup();
            }
        } else {
            this.get(ftp, localDir, remoteDir, filter);
        }
    }

    public void putFilesIntoCurrentDir(FTPClientInterface ftp, String localDir, FileFilter filter) throws FTPException, IOException {
        File file = new File(localDir);
        File[] fileArray = filter != null ? file.listFiles(filter) : file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            this.a();
            if (fileArray[i2].isDirectory()) continue;
            this.a(ftp, fileArray[i2]);
        }
    }

    public void put(FTPClientInterface ftp, String localDir, String remoteDir) throws FTPException, IOException {
        File file = new File(localDir);
        this.a(ftp, file, remoteDir, null);
    }

    public void put(FTPClientInterface ftp, String localDir, String remoteDir, FileFilter filter) throws FTPException, IOException {
        File file = new File(localDir);
        this.a(ftp, file, remoteDir, filter);
    }

    public void put(FTPClientInterface ftp, String localDir, String remoteDir, String wildcard) throws FTPException, IOException {
        File file = new File(localDir);
        WildcardFilter wildcardFilter = new WildcardFilter(wildcard);
        wildcardFilter.setDirectoriesAlwaysMatch(true);
        this.a(ftp, file, remoteDir, wildcardFilter);
    }

    public void put(FTPClientInterface ftp, String localDir, String remoteDir, FileFilter filter, boolean recurse) throws FTPException, IOException {
        boolean bl;
        boolean bl2 = bl = remoteDir != null && remoteDir != "" && remoteDir != ".";
        if (!recurse) {
            if (bl) {
                ftp.chdir(remoteDir);
            }
            this.putFilesIntoCurrentDir(ftp, localDir, filter);
            if (bl) {
                ftp.cdup();
            }
        } else {
            this.put(ftp, localDir, remoteDir, filter);
        }
    }

    private void a(FTPClientInterface fTPClientInterface, File file, String string, FileFilter fileFilter) throws IOException, FTPException {
        boolean bl;
        a.debug("putDir(currentDir = " + fTPClientInterface.pwd() + ",localDir=" + file.getPath() + ", remoteDir=" + string + ")");
        boolean bl2 = bl = string != null && string != "" && string != ".";
        if (bl) {
            try {
                fTPClientInterface.chdir(string);
                a.debug("'" + string + "' already exists - not creating");
            }
            catch (FTPException fTPException) {
                a.debug("Failed to chdir into '" + string + "' - creating");
                fTPClientInterface.mkdir(string);
                fTPClientInterface.chdir(string);
            }
        }
        File[] fileArray = fileFilter != null ? file.listFiles(fileFilter) : file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            a.debug("Processing listing entry '" + fileArray[i2].getName() + "'");
            this.a();
            if (!this.a(fileArray[i2].getName())) continue;
            if (fileArray[i2].isDirectory()) {
                this.a(fTPClientInterface, fileArray[i2], fileArray[i2].getName(), fileFilter);
                continue;
            }
            this.a(fTPClientInterface, fileArray[i2]);
        }
        if (bl) {
            fTPClientInterface.cdup();
        }
    }

    private void a(FTPClientInterface fTPClientInterface, File file) throws IOException, FTPException {
        fTPClientInterface.put(file.getAbsolutePath(), file.getName());
    }

    private void a(FTPClientInterface fTPClientInterface, String string, String string2, String string3, FileFilter fileFilter) throws IOException, FTPException, ParseException {
        a.debug("getDir(" + string + "," + string2 + "," + string3 + ")");
        boolean bl = string3 != null && string3 != "" && string3 != ".";
        File file = new File(string, string2);
        a.debug("mkdir=" + file.getAbsolutePath());
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Failed to create local directory '" + file.getAbsolutePath() + "'");
        }
        if (bl) {
            fTPClientInterface.chdir(string3);
        }
        FTPFile[] fTPFileArray = fTPClientInterface.dirDetails("");
        for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
            this.a();
            if (!this.a(fTPFileArray[i2].getName())) continue;
            if (fTPFileArray[i2].isDir()) {
                this.a(fTPClientInterface, file.getAbsolutePath(), fTPFileArray[i2].getName(), fTPFileArray[i2].getName(), fileFilter);
                continue;
            }
            File file2 = new File(fTPFileArray[i2].getName());
            if (fileFilter != null && !fileFilter.accept(file2)) continue;
            this.a(fTPClientInterface, file.getAbsolutePath(), fTPFileArray[i2].getName());
        }
        if (bl) {
            fTPClientInterface.cdup();
        }
    }

    private boolean a(String string) {
        String string2 = string.trim();
        if (!string2.equals(".") && !string2.equals("..")) {
            return true;
        }
        a.debug("Invalid dir '" + string + "'");
        return false;
    }

    private void a(FTPClientInterface fTPClientInterface, String string, String string2) throws IOException, FTPException {
        a.debug("getFile(" + string + "," + string2 + ")");
        File file = new File(string, string2);
        fTPClientInterface.get(file.getAbsolutePath(), string2);
    }

    private void a() throws FTPException {
        ++this.e;
        if (this.b && this.e >= this.c) {
            try {
                a.debug("Sleeping for " + this.d + " seconds during recursive transfer");
                Thread.sleep(this.d * 1000);
                a.debug("Resuming recursive transfer");
                this.e = 0;
            }
            catch (InterruptedException interruptedException) {
                throw new FTPException("Sleep interrupted: " + interruptedException.getMessage());
            }
        }
    }
}

