/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.MVSFileParser;
import com.enterprisedt.net.ftp.NetwareFileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.VMSFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FTPFileFactory {
    public static final String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.26 2012-02-07 03:20:26 bruceb Exp $";
    private static Logger a = Logger.getLogger("FTPFileFactory");
    private String b;
    private WindowsFileParser c = new WindowsFileParser();
    private FTPFileParser d = new UnixFileParser();
    private VMSFileParser e = new VMSFileParser();
    private NetwareFileParser f = new NetwareFileParser();
    private MVSFileParser g = new MVSFileParser();
    private FTPFileParser h = null;
    private boolean i = false;
    private boolean j = false;
    private Locale[] k;
    private int l = 0;
    private List m = new ArrayList();

    public FTPFileFactory(String system) throws FTPException {
        this.m.add(this.d);
        this.m.add(this.c);
        this.m.add(this.e);
        this.m.add(this.f);
        this.m.add(this.g);
        this.a(system);
    }

    public FTPFileFactory(FTPFileParser parser) {
        this.m.add(this.d);
        this.m.add(this.c);
        this.m.add(this.e);
        this.m.add(this.f);
        this.m.add(this.g);
        this.h = parser;
        this.i = true;
    }

    public String toString() {
        return this.h.getClass().getName();
    }

    public VMSFileParser getVMSParser() {
        return this.e;
    }

    public void addParser(FTPFileParser parser) {
        this.m.add(parser);
    }

    public void setLocale(Locale locale) {
        this.h.setLocale(locale);
        Iterator iterator = this.m.iterator();
        while (iterator.hasNext()) {
            FTPFileParser fTPFileParser = (FTPFileParser)iterator.next();
            fTPFileParser.setLocale(locale);
        }
    }

    public void setLocales(Locale[] locales) {
        this.k = locales;
        this.setLocale(locales[0]);
        this.l = 1;
    }

    private void a(String string) {
        this.j = false;
        String string2 = this.b = string != null ? string.trim() : null;
        if (string.toUpperCase().startsWith("WINDOWS")) {
            this.h = this.c;
        } else if (string.toUpperCase().indexOf("UNIX") >= 0 || string.toUpperCase().indexOf("AIX") >= 0) {
            this.h = this.d;
        } else if (string.toUpperCase().indexOf("VMS") >= 0) {
            this.h = this.e;
        } else if (string.toUpperCase().indexOf("NETWARE") >= 0) {
            this.h = this.f;
        } else if (string.toUpperCase().indexOf("MVS") >= 0) {
            this.h = this.g;
        } else {
            this.h = this.d;
            a.warn("Unknown SYST '" + string + "' - defaulting to Unix parsing");
        }
    }

    private void a() {
        this.h.setIgnoreDateParseErrors(false);
        Iterator iterator = this.m.iterator();
        while (iterator.hasNext()) {
            FTPFileParser fTPFileParser = (FTPFileParser)iterator.next();
            fTPFileParser.setIgnoreDateParseErrors(false);
        }
    }

    private void a(String[] stringArray) {
        if (this.h.isValidFormat(stringArray)) {
            a.debug("Confirmed format " + this.h.toString());
            this.j = true;
            return;
        }
        Iterator iterator = this.m.iterator();
        while (iterator.hasNext()) {
            FTPFileParser fTPFileParser = (FTPFileParser)iterator.next();
            if (!fTPFileParser.isValidFormat(stringArray)) continue;
            this.h = fTPFileParser;
            a.debug("Detected format " + this.h.toString());
            this.j = true;
            return;
        }
        this.h = this.d;
        a.warn("Could not detect format. Using default " + this.h.toString());
    }

    public FTPFile parse(String line) throws ParseException {
        if (this.h.isMultiLine()) {
            throw new ParseException("Cannot use this method with multi-line parsers", 0);
        }
        FTPFile fTPFile = null;
        try {
            fTPFile = this.h.parse(line);
        }
        catch (DateParseException dateParseException) {
            this.h.setIgnoreDateParseErrors(true);
            fTPFile = this.h.parse(line);
        }
        return fTPFile;
    }

    public FTPFile[] parse(String[] files) throws ParseException {
        this.a();
        FTPFile[] fTPFileArray = new FTPFile[files.length];
        if (files.length == 0) {
            return fTPFileArray;
        }
        if (!this.i && !this.j) {
            this.a(files);
        }
        int n2 = 0;
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2] == null || files[i2].trim().length() == 0) continue;
            try {
                FTPFile fTPFile = null;
                if (this.h.isMultiLine()) {
                    StringBuffer stringBuffer = new StringBuffer(files[i2]);
                    while (i2 + 1 < files.length && files[i2 + 1].indexOf(59) < 0) {
                        stringBuffer.append(" ").append(files[i2 + 1]);
                        ++i2;
                    }
                    fTPFile = this.h.parse(stringBuffer.toString());
                } else {
                    fTPFile = this.h.parse(files[i2]);
                }
                if (fTPFile == null) continue;
                fTPFileArray[n2++] = fTPFile;
                continue;
            }
            catch (DateParseException dateParseException) {
                if (this.k != null && this.k.length > this.l) {
                    a.info("Trying " + this.k[this.l].toString() + " locale");
                    this.setLocale(this.k[this.l]);
                    ++this.l;
                    n2 = 0;
                    i2 = -1;
                    continue;
                }
                n2 = 0;
                i2 = -1;
                this.h.setIgnoreDateParseErrors(true);
                a.debug("Ignoring date parsing errors");
            }
        }
        FTPFile[] fTPFileArray2 = new FTPFile[n2];
        System.arraycopy(fTPFileArray, 0, fTPFileArray2, 0, n2);
        return fTPFileArray2;
    }

    public String getSystem() {
        return this.b;
    }
}

