/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.BandwidthThrottler;
import com.enterprisedt.net.ftp.ControlChannelIOException;
import com.enterprisedt.net.ftp.DataChannelCallback;
import com.enterprisedt.net.ftp.DirectoryEmptyStrings;
import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileNotFoundStrings;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.MLSXEntryParser;
import com.enterprisedt.net.ftp.MalformedReplyException;
import com.enterprisedt.net.ftp.TransferCompleteStrings;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class FTPClient
implements FTPClientInterface {
    public static String cvsId = "@(#)$Id: FTPClient.java,v 1.128 2012-02-08 06:20:10 bruceb Exp $";
    public static final int DEFAULT_MONITOR_INTERVAL = 65535;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_RETRY_DELAY = 5000;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final byte[] a = System.getProperty("line.separator").getBytes();
    public static final byte CARRIAGE_RETURN = 13;
    public static final byte LINE_FEED = 10;
    public static final byte[] FTP_LINE_SEPARATOR = new byte[]{13, 10};
    public static Locale[] DEFAULT_LISTING_LOCALES;
    private static Logger b;
    private SimpleDateFormat c = new SimpleDateFormat("yyyyMMddHHmmss");
    protected FTPControlSocket control = null;
    protected FTPDataSocket data = null;
    protected int timeout = 60000;
    protected int serverWakeupInterval = 0;
    protected InetAddress remoteAddr;
    protected String remoteHost;
    protected String id;
    private static int d;
    protected int controlPort = 21;
    private boolean e = true;
    private String f = null;
    protected String controlEncoding = "US-ASCII";
    private boolean g = false;
    protected DirectoryEmptyStrings dirEmptyStrings = new DirectoryEmptyStrings();
    protected TransferCompleteStrings transferCompleteStrings = new TransferCompleteStrings();
    protected FileNotFoundStrings fileNotFoundStrings = new FileNotFoundStrings();
    private boolean h = false;
    private boolean i = false;
    private boolean j = true;
    private boolean k = true;
    private long l = 0L;
    private boolean m = true;
    protected boolean detectTransferMode = false;
    private int n = -1;
    private int o = -1;
    private String p = "STOR ";
    protected long monitorInterval = 65535L;
    protected int transferBufferSize = 16384;
    protected int dataReceiveBufferSize = 0;
    protected int dataSendBufferSize = 0;
    private int q = 0;
    private int r = 0;
    private int s = 0;
    private int t = 3;
    private int u = 5000;
    private boolean v = true;
    private FTPFileFactory w = null;
    private Locale[] x;
    private MLSXEntryParser y = new MLSXEntryParser();
    protected FTPProgressMonitor monitor = null;
    protected FTPMessageListener messageListener = null;
    protected FTPProgressMonitorEx monitorEx = null;
    protected FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode z = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;
    protected FTPReply lastReply;
    protected String user;
    protected String password;
    protected BandwidthThrottler throttler = null;
    protected DataChannelCallback dataChannelCallback = null;

    public static int[] getVersion() {
        return VersionDetails.getVersion();
    }

    public static String getBuildTimestamp() {
        return VersionDetails.getBuildTimestamp();
    }

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this(remoteHost, 21, 0);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this(remoteHost, controlPort, 0);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout, encoding);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this(remoteAddr, 21, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this(remoteAddr, controlPort, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout) throws IOException, FTPException {
        this.c.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.x = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++d);
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, DEFAULT_ENCODING, null));
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this.c.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.x = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++d);
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, encoding, null));
    }

    public FTPClient() {
        this.c.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.x = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++d);
        b.debug(VersionDetails.report(this));
    }

    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        if (this.remoteAddr == null) {
            this.remoteAddr = InetAddress.getByName(this.remoteHost);
        }
        b.debug("Connecting to " + this.remoteAddr + ":" + this.controlPort);
        this.initialize(new FTPControlSocket(this.remoteAddr, this.controlPort, this.timeout, this.controlEncoding, this.messageListener));
    }

    public boolean connected() {
        if (this.control == null) {
            return false;
        }
        return this.control.controlSock == null ? false : this.control.controlSock.isConnected();
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.connected()) {
            throw new FTPException("The FTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.connected()) {
            throw new FTPException("The FTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    protected void initialize(FTPControlSocket control) throws IOException {
        this.control = control;
        control.a(this.messageListener);
        control.a(this.g);
        control.b(this.v);
        control.a(this.timeout);
        control.setAutoPassiveIPSubstitution(this.e);
        control.a(this.dataChannelCallback);
        if (this.f != null) {
            control.a(this.f);
        }
        if (this.n > 0 && this.o > 0) {
            control.setActivePortRange(this.n, this.o);
        }
    }

    public void debugResponses(boolean on) {
        if (on) {
            Logger.setLevel(Level.DEBUG);
        } else {
            Logger.setLevel(Level.OFF);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getDownloadCount() {
        return this.q;
    }

    public void resetDownloadCount() {
        this.q = 0;
    }

    public int getUploadCount() {
        return this.r;
    }

    public void resetUploadCount() {
        this.r = 0;
    }

    public int getDeleteCount() {
        return this.s;
    }

    public void resetDeleteCount() {
        this.s = 0;
    }

    public void setDataChannelCallback(DataChannelCallback callback) {
        this.dataChannelCallback = callback;
        if (this.control != null) {
            this.control.a(callback);
        }
    }

    public void setStrictReturnCodes(boolean strict) {
        this.g = strict;
        if (this.control != null) {
            this.control.a(strict);
        }
    }

    public boolean isStrictReturnCodes() {
        return this.g;
    }

    public void setListenOnAllInterfaces(boolean listenOnAll) {
        this.v = listenOnAll;
        if (this.control != null) {
            this.control.b(listenOnAll);
        }
    }

    public boolean getListenOnAllInterfaces() {
        return this.v;
    }

    public FileNotFoundStrings getFileNotFoundMessages() {
        return this.fileNotFoundStrings;
    }

    public void setFileNotFoundMessages(FileNotFoundStrings fileNotFoundStrings) {
        this.fileNotFoundStrings = fileNotFoundStrings;
    }

    public TransferCompleteStrings getTransferCompleteMessages() {
        return this.transferCompleteStrings;
    }

    public void setTransferCompleteMessages(TransferCompleteStrings transferCompleteStrings) {
        this.transferCompleteStrings = transferCompleteStrings;
    }

    public DirectoryEmptyStrings getDirectoryEmptyMessages() {
        return this.dirEmptyStrings;
    }

    public void setDirectoryEmptyMessages(DirectoryEmptyStrings dirEmptyStrings) {
        this.dirEmptyStrings = dirEmptyStrings;
    }

    public void setDetectTransferMode(boolean detectTransferMode) {
        this.detectTransferMode = detectTransferMode;
    }

    public boolean getDetectTransferMode() {
        return this.detectTransferMode;
    }

    public void setForceUniqueNames(boolean forceUnique) {
        this.p = forceUnique ? "STOU " : "STOR ";
    }

    protected FTPTransferType chooseTransferMode(String filename) throws IOException, FTPException {
        if (this.detectTransferMode) {
            if (filename == null) {
                b.warn("Cannot choose transfer mode as filename not supplied");
                return this.getType();
            }
            if (FileTypes.ASCII.matches(filename) && this.transferType.equals(FTPTransferType.BINARY)) {
                this.setType(FTPTransferType.ASCII);
                b.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(filename) && this.transferType.equals(FTPTransferType.ASCII)) {
                this.setType(FTPTransferType.BINARY);
                b.debug("Autodetect on - changed transfer type to binary");
            }
        }
        return this.getType();
    }

    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        if (this.control != null) {
            this.control.a(millis);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRemotePort() {
        return this.controlPort;
    }

    public void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = remotePort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(int controlPort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = controlPort;
    }

    public InetAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(InetAddress remoteAddr) throws FTPException {
        this.checkConnection(false);
        this.remoteAddr = remoteAddr;
        this.remoteHost = remoteAddr.getHostAddress();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) throws IOException, FTPException {
        this.checkConnection(false);
        this.remoteHost = remoteHost;
    }

    public boolean isAutoPassiveIPSubstitution() {
        return this.e;
    }

    public void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.e = autoPassiveIPSubstitution;
        if (this.control != null) {
            this.control.setAutoPassiveIPSubstitution(autoPassiveIPSubstitution);
        }
    }

    public int getServerWakeupInterval() {
        return this.serverWakeupInterval;
    }

    public void setServerWakeupInterval(int interval) {
        this.serverWakeupInterval = interval;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setDataReceiveBufferSize(int size) {
        this.dataReceiveBufferSize = size;
    }

    public int getDataReceiveBufferSize() {
        return this.dataReceiveBufferSize;
    }

    public void setDataSendBufferSize(int size) {
        this.dataSendBufferSize = size;
    }

    public int getDataSendBufferSize() {
        return this.dataSendBufferSize;
    }

    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.checkConnection(false);
        this.controlEncoding = controlEncoding;
    }

    public FTPMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
        if (this.control != null) {
            this.control.a(listener);
        }
    }

    public FTPProgressMonitorEx getProgressMonitorEx() {
        return this.monitorEx;
    }

    public void setProgressMonitorEx(FTPProgressMonitorEx monitorEx) {
        this.monitorEx = monitorEx;
        this.monitor = monitorEx;
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.z = mode;
    }

    public FTPConnectMode getConnectMode() {
        return this.z;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.monitorInterval = interval;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public FTPProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(long interval) {
        this.monitorInterval = interval;
    }

    public void setTransferBufferSize(int size) {
        this.transferBufferSize = size;
    }

    public int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public void cancelTransfer() {
        this.h = true;
        b.warn("cancelTransfer() called");
    }

    public boolean isTransferCancelled() {
        return this.h;
    }

    public boolean isDeleteOnFailure() {
        return this.m;
    }

    public void setDeleteOnFailure(boolean deleteOnFailure) {
        this.m = deleteOnFailure;
    }

    public void setPORTIP(String IPAddress) throws FTPException {
        this.setActiveIPAddress(IPAddress);
    }

    public void setActiveIPAddress(String activeIP) throws FTPException {
        this.f = activeIP;
        if (this.control != null) {
            this.control.a(activeIP);
        }
    }

    public String getActiveIPAddress() {
        return this.f;
    }

    public void setActivePortRange(int lowest, int highest) throws FTPException {
        this.n = lowest;
        this.o = highest;
        if (lowest < 0 || lowest > highest || highest > 65535) {
            throw new FTPException("Invalid port range specified");
        }
        if (this.control != null) {
            this.control.setActivePortRange(lowest, highest);
        }
        b.debug("setActivePortRange(" + lowest + "," + highest + ")");
    }

    public int getActiveLowPort() {
        return this.n;
    }

    public int getActiveHighPort() {
        return this.o;
    }

    public void login(String user, String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.user = user;
        this.password = password;
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230") || this.lastValidReply.getReplyCode().equals("232")) {
            return;
        }
        this.password(password);
    }

    public void login(String user, String password, String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.user = user;
        this.password = password;
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230") || this.lastValidReply.getReplyCode().equals("232")) {
            return;
        }
        this.password(password);
        if (this.lastValidReply.getReplyCode().equals("332")) {
            this.account(accountInfo);
        }
    }

    public void user(String user) throws IOException, FTPException {
        this.checkConnection(true);
        this.user = user;
        this.lastReply = this.control.sendCommand("USER " + user);
        String[] stringArray = new String[]{"230", "232", "331"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public void password(String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.password = password;
        this.lastReply = this.control.sendCommand("PASS " + password);
        String[] stringArray = new String[]{"230", "202", "332"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public void account(String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ACCT " + accountInfo);
        String[] stringArray = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public static void initSOCKS(String port, String host) {
        Properties properties = System.getProperties();
        properties.put("socksProxyPort", port);
        properties.put("socksProxyHost", host);
        System.setProperties(properties);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties properties = System.getProperties();
        properties.put("java.net.socks.username", username);
        properties.put("java.net.socks.password", password);
        System.setProperties(properties);
    }

    public static void clearSOCKS() {
        Properties properties = System.getProperties();
        properties.remove("socksProxyHost");
        properties.remove("socksProxyPort");
        System.setProperties(properties);
    }

    public String quote(String command, String[] validCodes) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand(command);
        this.lastValidReply = validCodes != null ? this.control.validateReply(this.lastReply, validCodes) : this.lastReply;
        return this.lastValidReply.getReplyText();
    }

    public String quote(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastValidReply = this.control.sendCommand(command);
        return this.lastValidReply.getRawReply();
    }

    public String executeCommand(String command) throws FTPException, IOException {
        return this.quote(command);
    }

    public boolean existsFile(String remoteFile) throws IOException, FTPException {
        char c2;
        this.checkConnection(true);
        if (this.k) {
            this.lastReply = this.control.sendCommand("SIZE " + remoteFile);
            c2 = this.lastReply.getReplyCode().charAt(0);
            if (c2 == '2') {
                return true;
            }
            if (c2 == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.k = false;
            b.debug("SIZE not supported - trying MDTM");
        }
        if (this.j) {
            this.lastReply = this.control.sendCommand("MDTM " + remoteFile);
            c2 = this.lastReply.getReplyCode().charAt(0);
            if (c2 == '2') {
                return true;
            }
            if (c2 == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.j = false;
            b.debug("MDTM not supported - trying LIST");
        }
        try {
            FTPFile[] fTPFileArray = this.dirDetails(".");
            for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
                if (!fTPFileArray[i2].getName().equals(remoteFile)) continue;
                return fTPFileArray[i2].isFile();
            }
            return false;
        }
        catch (ParseException parseException) {
            b.warn(parseException.getMessage());
            return false;
        }
    }

    public boolean existsDirectory(String remoteDirectory) throws IOException, FTPException {
        String string = this.pwd();
        try {
            this.chdir(remoteDirectory);
        }
        catch (Exception exception) {
            return false;
        }
        this.chdir(string);
        return true;
    }

    public boolean exists(String remoteFile) throws IOException, FTPException {
        return this.existsFile(remoteFile);
    }

    String a(String string) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (!Character.isDigit(string.charAt(n2))) continue;
            n3 = n2;
            break;
        }
        int n4 = -1;
        for (n2 = string.length() - 1; n2 >= 0; --n2) {
            if (!Character.isDigit(string.charAt(n2))) continue;
            n4 = n2;
            break;
        }
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        return string.substring(n3, n4 + 1);
    }

    public FTPReply sendCommand(String command) throws IOException, FTPException {
        return this.control.sendCommand(command);
    }

    public void validateReply(FTPReply reply, String expectedReplyCode) throws FTPException {
        this.control.validateReply(reply, expectedReplyCode);
    }

    public void validateReply(FTPReply reply, String[] expectedReplyCodes) throws FTPException {
        this.control.validateReply(reply, expectedReplyCodes);
    }

    public long size(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SIZE " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        String string = this.lastValidReply.getReplyText();
        int n2 = string.indexOf(32);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FTPException("Failed to parse reply: " + string);
        }
    }

    public void resume() throws FTPException {
        if (this.transferType.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.i = true;
        b.info("Resume=true");
    }

    public void resumeNextDownload(long offset) throws FTPException {
        this.resume();
        if (offset < 0L) {
            throw new FTPException("Offset must be >= 0");
        }
        this.l = offset;
    }

    public void cancelResume() throws IOException, FTPException {
        try {
            this.restart(0L);
        }
        catch (FTPException fTPException) {
            b.debug("REST failed which is ok (" + fTPException.getMessage() + ")");
        }
        this.l = 0L;
        this.i = false;
    }

    protected void forceResumeOff() {
        this.i = false;
        this.l = 0L;
    }

    public void restart(long size) throws IOException, FTPException {
        this.lastReply = this.control.sendCommand("REST " + size);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
    }

    public int getRetryCount() {
        return this.t;
    }

    public void setRetryCount(int retryCount) {
        this.t = retryCount;
    }

    public int getRetryDelay() {
        return this.u;
    }

    public void setRetryDelay(int retryDelay) {
        this.u = retryDelay;
    }

    private boolean a(Exception exception, int n2) {
        if (n2 <= this.t + 1) {
            if (this.u > 0) {
                try {
                    b.debug("Sleeping for " + this.u + " ms prior to retry");
                    Thread.sleep(this.u);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            b.error("Transfer error on attempt #" + n2 + " retrying: ", exception);
            return true;
        }
        if (n2 > 0) {
            b.info("Failed " + n2 + " attempts - giving up");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        String string = this.b();
        FTPTransferType fTPTransferType = this.transferType;
        FTPTransferType fTPTransferType2 = this.chooseTransferMode(remoteFile);
        File file = new File(localPath);
        if (file.isDirectory()) {
            localPath = localPath + File.separator + remoteFile;
            b.debug("Setting local path to " + localPath);
        }
        try {
            if (this.t == 0) {
                this.a(localPath, remoteFile);
            } else {
                int n2 = 1;
                while (true) {
                    block12: {
                        try {
                            if (n2 > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            b.debug("Attempt #" + n2);
                            this.a(localPath, remoteFile);
                            break;
                        }
                        catch (ControlChannelIOException controlChannelIOException) {
                            if (!this.a(string, controlChannelIOException, n2)) {
                                throw controlChannelIOException;
                            }
                        }
                        catch (MalformedReplyException malformedReplyException) {
                            throw malformedReplyException;
                        }
                        catch (IOException iOException) {
                            if (this.a(iOException, n2)) break block12;
                            throw iOException;
                        }
                    }
                    ++n2;
                }
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
        this.resetTransferMode(fTPTransferType);
        this.postTransferChecks(localPath, remoteFile, fTPTransferType2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        String string;
        FTPTransferType fTPTransferType = this.transferType;
        FTPTransferType fTPTransferType2 = this.chooseTransferMode(remoteFile);
        try {
            string = this.a(srcStream, remoteFile, append);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
        this.resetTransferMode(fTPTransferType);
        return string;
    }

    private boolean a(String string, Exception exception, int n2) throws IOException, FTPException {
        if (n2 <= this.t + 1) {
            if (this.u > 0) {
                try {
                    b.debug("Sleeping for " + this.u + " ms prior to retry");
                    Thread.sleep(this.u);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            b.error("Transfer error on attempt #" + n2 + ": reconnecting & retrying: ", exception);
            this.reconnect(string);
            return true;
        }
        b.info("Failed " + n2 + " attempts - giving up");
        return false;
    }

    protected void reconnect(String cwd) throws IOException, FTPException {
        try {
            this.quitImmediately();
        }
        catch (Exception exception) {
            // empty catch block
        }
        b.info("Reconnecting");
        this.connect();
        this.login(this.user, this.password);
        this.setType(this.transferType);
        if (cwd != null) {
            this.chdir(cwd);
        }
    }

    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        return this.put(localPath, remoteFile, false);
    }

    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        return this.put(srcStream, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        String string = this.b();
        FTPTransferType fTPTransferType = this.transferType;
        FTPTransferType fTPTransferType2 = this.chooseTransferMode(remoteFile);
        try {
            FileInputStream fileInputStream = null;
            if (this.t == 0 || append) {
                fileInputStream = new FileInputStream(localPath);
                remoteFile = this.a(fileInputStream, remoteFile, append);
            } else {
                int n2 = 1;
                while (true) {
                    block11: {
                        try {
                            if (n2 > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            b.debug("Attempt #" + n2);
                            fileInputStream = new FileInputStream(localPath);
                            remoteFile = this.a(fileInputStream, remoteFile, append);
                            break;
                        }
                        catch (ControlChannelIOException controlChannelIOException) {
                            if (!this.a(string, controlChannelIOException, n2)) {
                                throw controlChannelIOException;
                            }
                        }
                        catch (MalformedReplyException malformedReplyException) {
                            throw malformedReplyException;
                        }
                        catch (IOException iOException) {
                            if (this.a(iOException, n2)) break block11;
                            throw iOException;
                        }
                    }
                    ++n2;
                }
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
        this.resetTransferMode(fTPTransferType);
        this.postTransferChecks(localPath, remoteFile, fTPTransferType2, append);
        return remoteFile;
    }

    private String a(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        try {
            try {
                if (this.monitorEx != null) {
                    this.monitorEx.transferStarted(TransferDirection.UPLOAD, string);
                }
                string = this.b(inputStream, string, bl);
                this.validateTransfer();
                ++this.r;
            }
            catch (FTPException fTPException) {
                throw fTPException;
            }
            catch (ControlChannelIOException controlChannelIOException) {
                throw controlChannelIOException;
            }
            catch (IOException iOException) {
                this.validateTransferOnError(iOException);
                throw iOException;
            }
            Object var6_4 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, string);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, string);
            }
            throw throwable;
        }
        return string;
    }

    public void validateTransfer() throws IOException, FTPException {
        this.checkConnection(true);
        String[] stringArray = new String[]{"225", "226", "250"};
        this.lastReply = this.control.b();
        if (this.h) {
            this.lastValidReply = this.lastReply;
            b.warn("Transfer has been cancelled!");
            throw new FTPTransferCancelledException();
        }
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validateTransferOnError(IOException ex) throws IOException, FTPException {
        b.debug("Validate transfer on error after exception", ex);
        this.checkConnection(true);
        this.control.a(500);
        try {
            try {
                this.validateTransfer();
            }
            catch (Exception exception) {
                b.warn("Validate transfer on error failed", exception);
                Object var4_3 = null;
                this.control.a(this.timeout);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.control.a(this.timeout);
            throw throwable;
        }
        this.control.a(this.timeout);
    }

    private void a() {
        if (this.data != null) {
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException iOException) {
                b.warn("Caught exception closing data socket", iOException);
            }
        }
    }

    protected void closeDataSocket(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                b.warn("Caught exception closing data socket", iOException);
            }
        }
        this.a();
    }

    protected void closeDataSocket(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                b.warn("Caught exception closing data socket", iOException);
            }
        }
        this.a();
    }

    protected void setupDataSocket() throws IOException, FTPException {
        this.data = this.control.a(this.z);
        this.data.setTimeout(this.timeout);
        if (this.dataReceiveBufferSize > 0) {
            this.data.setReceiveBufferSize(this.dataReceiveBufferSize);
        }
        if (this.dataSendBufferSize > 0) {
            this.data.setSendBufferSize(this.dataSendBufferSize);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String initPut(String remoteFile, boolean append) throws IOException, FTPException {
        boolean bl;
        this.checkConnection(true);
        boolean bl2 = bl = remoteFile == null || remoteFile.length() == 0;
        if (bl) {
            remoteFile = "";
            if (append) {
                String string = "A remote filename must be supplied when appending";
                b.error(string);
                throw new FTPException(string);
            }
        }
        this.h = false;
        boolean bl3 = false;
        try {
            try {
                this.l = 0L;
                if (this.i) {
                    if (this.transferType.equals(FTPTransferType.ASCII)) {
                        throw new FTPException("Resume only supported for BINARY transfers");
                    }
                    try {
                        this.l = this.size(remoteFile);
                    }
                    catch (FTPException fTPException) {
                        this.l = 0L;
                        this.i = false;
                        b.warn("SIZE failed '" + remoteFile + "' - resume will not be used (" + fTPException.getMessage() + ")");
                    }
                }
                this.setupDataSocket();
                if (this.i) {
                    try {
                        this.restart(this.l);
                    }
                    catch (FTPException fTPException) {
                        this.l = 0L;
                        this.i = false;
                        b.warn("REST failed - resume will not be used (" + fTPException.getMessage() + ")");
                    }
                }
                String string = append ? "APPE " : (bl ? "STOU" : this.p);
                this.lastReply = this.control.sendCommand(string + remoteFile);
                String[] stringArray = new String[]{"125", "150", "151", "350"};
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
                String string2 = this.lastValidReply.getReplyText();
                if (bl) {
                    int n2 = string2.indexOf("FILE:");
                    if (n2 >= 0) {
                        remoteFile = string2.substring(n2 += "FILE:".length()).trim();
                    } else {
                        b.debug("Could not find FILE: in reply - using last word instead.");
                        n2 = string2.lastIndexOf(32);
                        remoteFile = string2.substring(++n2);
                        int n3 = remoteFile.length();
                        if (n3 > 0 && remoteFile.charAt(n3 - 1) == '.') {
                            remoteFile = remoteFile.substring(0, n3 - 1);
                        }
                    }
                }
                String string3 = remoteFile;
                Object var11_16 = null;
                if (!bl3) return string3;
                this.i = false;
                this.l = 0L;
                this.a();
                return string3;
            }
            catch (IOException iOException) {
                bl3 = true;
                b.error("Caught and rethrowing exception in initPut()", iOException);
                throw iOException;
            }
            catch (FTPException fTPException) {
                bl3 = true;
                b.error("Caught and rethrowing exception in initPut()", fTPException);
                throw fTPException;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (!bl3) throw throwable;
            this.i = false;
            this.l = 0L;
            this.a();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String b(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        block31: {
            long l2;
            BufferedOutputStream bufferedOutputStream;
            BufferedInputStream bufferedInputStream;
            IOException iOException;
            block29: {
                iOException = null;
                bufferedInputStream = null;
                bufferedOutputStream = null;
                l2 = 0L;
                bufferedInputStream = new BufferedInputStream(inputStream);
                string = this.initPut(string, bl);
                bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(this.getOutputStream()), this.transferBufferSize * 2);
                if (this.i && this.l > 0L) {
                    bufferedInputStream.skip(this.l);
                } else {
                    this.l = 0L;
                }
                byte[] byArray = new byte[this.transferBufferSize];
                byte[] byArray2 = new byte[FTP_LINE_SEPARATOR.length];
                int n2 = 0;
                long l3 = 0L;
                int n3 = 0;
                boolean bl2 = this.getType() == FTPTransferType.ASCII;
                long l4 = System.currentTimeMillis();
                if (this.throttler != null) {
                    this.throttler.reset();
                }
                while ((n3 = bufferedInputStream.read(byArray)) > 0 && !this.h) {
                    if (bl2) {
                        for (int i2 = 0; i2 < n3; ++i2) {
                            if (byArray[i2] == 10 && n2 == 0) {
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                l2 += 2L;
                                l3 += 2L;
                                continue;
                            }
                            if (byArray[i2] == FTP_LINE_SEPARATOR[n2]) {
                                byArray2[n2] = byArray[i2];
                                if (++n2 != FTP_LINE_SEPARATOR.length) continue;
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                l2 += 2L;
                                l3 += 2L;
                                n2 = 0;
                                continue;
                            }
                            if (n2 > 0) {
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                l2 += 2L;
                                l3 += 2L;
                            }
                            bufferedOutputStream.write(byArray[i2]);
                            ++l2;
                            ++l3;
                            n2 = 0;
                        }
                    } else {
                        bufferedOutputStream.write(byArray, 0, n3);
                        l2 += (long)n3;
                        l3 += (long)n3;
                    }
                    if (this.throttler != null) {
                        this.throttler.throttleTransfer(l2);
                    }
                    if (this.monitor != null && l3 > this.monitorInterval) {
                        this.monitor.bytesTransferred(l2);
                        l3 = 0L;
                    }
                    if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - l4 <= (long)(this.serverWakeupInterval * 1000)) continue;
                    l4 = System.currentTimeMillis();
                    this.sendServerWakeup();
                }
                if (!bl2 || n2 <= 0) break block29;
                bufferedOutputStream.write(13);
                bufferedOutputStream.write(10);
                l2 += 2L;
                l3 += 2L;
            }
            Object var20_17 = null;
            this.i = false;
            this.l = 0L;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException2) {
                b.warn("Caught exception closing input stream", iOException2);
            }
            this.closeDataSocket(bufferedOutputStream);
            if (iOException != null) {
                throw iOException;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(l2);
            }
            b.debug("Transferred " + l2 + " bytes to remote host");
            {
                break block31;
                catch (IOException iOException3) {
                    iOException = iOException3;
                    b.error("Caught and rethrowing exception in getDataAfterInitGet()", iOException3);
                    Object var20_18 = null;
                    this.i = false;
                    this.l = 0L;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (IOException iOException4) {
                        b.warn("Caught exception closing input stream", iOException4);
                    }
                    this.closeDataSocket(bufferedOutputStream);
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (this.monitor != null) {
                        this.monitor.bytesTransferred(l2);
                    }
                    b.debug("Transferred " + l2 + " bytes to remote host");
                }
            }
            catch (Throwable throwable) {
                Object var20_19 = null;
                this.i = false;
                this.l = 0L;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException iOException5) {
                    b.warn("Caught exception closing input stream", iOException5);
                }
                this.closeDataSocket(bufferedOutputStream);
                if (iOException != null) {
                    throw iOException;
                }
                if (this.monitor != null) {
                    this.monitor.bytesTransferred(l2);
                }
                b.debug("Transferred " + l2 + " bytes to remote host");
                throw throwable;
            }
        }
        return string;
    }

    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        return this.put(bytes, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        String string = this.b();
        FTPTransferType fTPTransferType = this.transferType;
        FTPTransferType fTPTransferType2 = this.chooseTransferMode(remoteFile);
        String string2 = null;
        try {
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.t == 0 || append) {
                byteArrayInputStream = new ByteArrayInputStream(bytes);
                string2 = this.a(byteArrayInputStream, remoteFile, append);
            } else {
                int n2 = 1;
                while (true) {
                    block11: {
                        try {
                            if (n2 > 1 && this.getType().equals(FTPTransferType.BINARY)) {
                                this.resume();
                            }
                            b.debug("Attempt #" + n2);
                            byteArrayInputStream = new ByteArrayInputStream(bytes);
                            string2 = this.a(byteArrayInputStream, remoteFile, append);
                            break;
                        }
                        catch (ControlChannelIOException controlChannelIOException) {
                            if (!this.a(string, controlChannelIOException, n2)) {
                                throw controlChannelIOException;
                            }
                        }
                        catch (MalformedReplyException malformedReplyException) {
                            throw malformedReplyException;
                        }
                        catch (IOException iOException) {
                            if (this.a(iOException, n2)) break block11;
                            throw iOException;
                        }
                    }
                    ++n2;
                }
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
        this.resetTransferMode(fTPTransferType);
        this.postTransferChecks(bytes, remoteFile, fTPTransferType2, append);
        return string2;
    }

    private void a(String string, String string2) throws IOException, FTPException {
        try {
            try {
                if (this.monitorEx != null) {
                    this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, string2);
                }
                this.b(string, string2);
                this.validateTransfer();
                ++this.q;
            }
            catch (FTPException fTPException) {
                throw fTPException;
            }
            catch (ControlChannelIOException controlChannelIOException) {
                throw controlChannelIOException;
            }
            catch (IOException iOException) {
                this.validateTransferOnError(iOException);
                throw iOException;
            }
            Object var5_3 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string2);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, string2);
            }
            throw throwable;
        }
    }

    protected void postTransferChecks(String localPath, String remotePath, FTPTransferType transferType, boolean append) throws FTPException, IOException {
    }

    protected void postTransferChecks(byte[] localBytes, String remotePath, FTPTransferType transferType, boolean append) throws FTPException, IOException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        FTPTransferType fTPTransferType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean bl = true;
        try {
            try {
                if (this.monitorEx != null) {
                    this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
                }
                this.a(destStream, remoteFile);
                this.validateTransfer();
                ++this.q;
            }
            catch (FTPException fTPException) {
                throw fTPException;
            }
            catch (ControlChannelIOException controlChannelIOException) {
                throw controlChannelIOException;
            }
            catch (IOException iOException) {
                bl = false;
                this.validateTransferOnError(iOException);
                throw iOException;
            }
            Object var7_5 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (!bl) throw throwable;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
        this.resetTransferMode(fTPTransferType);
    }

    public void resetTransferMode(FTPTransferType previousType) throws IOException, FTPException {
        if (!this.transferType.equals(previousType)) {
            this.setType(previousType);
        }
    }

    protected void initGet(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.h = false;
        boolean bl = false;
        try {
            try {
                this.setupDataSocket();
                if (this.i) {
                    if (this.transferType.equals(FTPTransferType.ASCII)) {
                        throw new FTPException("Resume only supported for BINARY transfers");
                    }
                    try {
                        this.restart(this.l);
                    }
                    catch (FTPException fTPException) {
                        this.l = 0L;
                        this.i = false;
                        b.warn("REST failed - resume will not be used (" + fTPException.getMessage() + ")");
                    }
                } else {
                    this.l = 0L;
                }
                this.lastReply = this.control.sendCommand("RETR " + remoteFile);
                String[] stringArray = new String[]{"125", "150"};
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            }
            catch (IOException iOException) {
                bl = true;
                b.error("Caught and rethrowing exception in initGet()", iOException);
                throw iOException;
            }
            catch (FTPException fTPException) {
                bl = true;
                b.error("Caught and rethrowing exception in initGet()", fTPException);
                throw fTPException;
            }
            Object var5_7 = null;
            if (bl) {
                this.i = false;
                this.l = 0L;
                this.a();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (bl) {
                this.i = false;
                this.l = 0L;
                this.a();
            }
            throw throwable;
        }
    }

    private void b(String string, String string2) throws IOException, FTPException {
        File file = new File(string);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new FTPException(string + " is readonly - cannot write");
            }
            if (this.i) {
                if (this.l == 0L) {
                    this.l = file.length();
                } else {
                    b.debug("Resume marker already set explicitly: " + this.l);
                }
            } else {
                this.l = 0L;
            }
        }
        this.initGet(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(string, this.i);
        try {
            this.a(fileOutputStream);
        }
        catch (IOException iOException) {
            if (this.m) {
                file.delete();
                b.debug("Deleting local file '" + file.getAbsolutePath() + "'");
            } else {
                b.debug("Possibly partial local file not deleted");
            }
            throw iOException;
        }
    }

    private void a(OutputStream outputStream, String string) throws IOException, FTPException {
        this.initGet(string);
        this.a(outputStream);
    }

    protected InputStream getInputStream() throws IOException {
        return this.data.getInputStream();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.data.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void a(OutputStream outputStream) throws IOException, FTPException {
        block28: {
            IOException iOException;
            long l2;
            BufferedInputStream bufferedInputStream;
            BufferedOutputStream bufferedOutputStream;
            block26: {
                int n2;
                bufferedOutputStream = new BufferedOutputStream(outputStream);
                bufferedInputStream = null;
                l2 = 0L;
                iOException = null;
                bufferedInputStream = new BufferedInputStream(new DataInputStream(this.getInputStream()));
                long l3 = 0L;
                byte[] byArray = new byte[this.transferBufferSize];
                boolean bl = this.getType() == FTPTransferType.ASCII;
                long l4 = System.currentTimeMillis();
                if (this.throttler != null) {
                    this.throttler.reset();
                }
                byte[] byArray2 = new byte[FTP_LINE_SEPARATOR.length];
                int n3 = 0;
                while ((n2 = this.readChunk(bufferedInputStream, byArray, this.transferBufferSize)) >= 0 && !this.h) {
                    if (bl) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            if (byArray[i2] == FTP_LINE_SEPARATOR[n3]) {
                                byArray2[n3] = byArray[i2];
                                if (++n3 != FTP_LINE_SEPARATOR.length) continue;
                                bufferedOutputStream.write(a);
                                l2 += (long)a.length;
                                l3 += (long)a.length;
                                n3 = 0;
                                continue;
                            }
                            if (n3 > 0) {
                                bufferedOutputStream.write(byArray2, 0, n3);
                                l2 += (long)n3;
                                l3 += (long)n3;
                            }
                            bufferedOutputStream.write(byArray[i2]);
                            ++l2;
                            ++l3;
                            n3 = 0;
                        }
                    } else {
                        bufferedOutputStream.write(byArray, 0, n2);
                        l2 += (long)n2;
                        l3 += (long)n2;
                    }
                    if (this.throttler != null) {
                        this.throttler.throttleTransfer(l2);
                    }
                    if (this.monitor != null && l3 > this.monitorInterval) {
                        this.monitor.bytesTransferred(l2);
                        l3 = 0L;
                    }
                    if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - l4 <= (long)(this.serverWakeupInterval * 1000)) continue;
                    l4 = System.currentTimeMillis();
                    this.sendServerWakeup();
                }
                if (!bl || n3 <= 0) break block26;
                bufferedOutputStream.write(byArray2, 0, n3);
                l2 += (long)n3;
                l3 += (long)n3;
            }
            Object var18_15 = null;
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                b.warn("Caught exception closing output stream", iOException2);
            }
            this.i = false;
            this.l = 0L;
            this.closeDataSocket(bufferedInputStream);
            if (iOException != null) {
                throw iOException;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(l2);
            }
            b.debug("Transferred " + l2 + " bytes from remote host");
            {
                break block28;
                catch (IOException iOException3) {
                    iOException = iOException3;
                    b.error("Caught and rethrowing exception in getDataAfterInitGet()", iOException3);
                    Object var18_16 = null;
                    try {
                        if (bufferedOutputStream != null) {
                            bufferedOutputStream.close();
                        }
                    }
                    catch (IOException iOException4) {
                        b.warn("Caught exception closing output stream", iOException4);
                    }
                    this.i = false;
                    this.l = 0L;
                    this.closeDataSocket(bufferedInputStream);
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (this.monitor != null) {
                        this.monitor.bytesTransferred(l2);
                    }
                    b.debug("Transferred " + l2 + " bytes from remote host");
                }
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                try {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                }
                catch (IOException iOException5) {
                    b.warn("Caught exception closing output stream", iOException5);
                }
                this.i = false;
                this.l = 0L;
                this.closeDataSocket(bufferedInputStream);
                if (iOException != null) {
                    throw iOException;
                }
                if (this.monitor != null) {
                    this.monitor.bytesTransferred(l2);
                }
                b.debug("Transferred " + l2 + " bytes from remote host");
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] get(String remoteFile) throws IOException, FTPException {
        byte[] byArray;
        FTPTransferType fTPTransferType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean bl = true;
        try {
            try {
                if (this.monitorEx != null) {
                    this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.transferBufferSize);
                this.a(byteArrayOutputStream, remoteFile);
                this.validateTransfer();
                ++this.q;
                byArray = byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
                Object var7_9 = null;
                if (this.monitorEx != null) {
                    this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
                }
                if (!bl) return byArray;
            }
            catch (FTPException fTPException) {
                throw fTPException;
            }
            catch (ControlChannelIOException controlChannelIOException) {
                throw controlChannelIOException;
            }
            catch (IOException iOException) {
                bl = false;
                this.validateTransferOnError(iOException);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (!bl) throw throwable;
            this.resetTransferMode(fTPTransferType);
            throw throwable;
        }
        this.resetTransferMode(fTPTransferType);
        return byArray;
    }

    public boolean site(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SITE " + command);
        String[] stringArray = new String[]{"200", "202", "250", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastReply.getReplyCode().equals("200");
    }

    public String list(String dirname) throws IOException, FTPException {
        return this.list(dirname, false);
    }

    public String list(String dirname, boolean full) throws IOException, FTPException {
        String[] stringArray = this.dir(dirname, full);
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setFTPFileFactory(FTPFileFactory fileFactory) {
        this.w = fileFactory;
        b.debug("Set new FTPFileFactory: " + fileFactory.toString());
    }

    public void setParserLocale(Locale locale) {
        this.x = new Locale[1];
        this.x[0] = locale;
    }

    public void setParserLocales(Locale[] locales) {
        this.x = locales;
    }

    public FTPFile fileDetails(String name) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        try {
            this.lastReply = this.control.sendCommand("MLST " + name);
            this.lastValidReply = this.control.validateReply(this.lastReply, "250");
            String[] stringArray = this.lastReply.getReplyData();
            if (stringArray != null && stringArray.length >= 2) {
                return this.y.parse(this.lastReply.getReplyData()[1]);
            }
            throw new FTPException("Failed to retrieve data");
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            b.debug("MLST failed: " + exception.getMessage() + " Trying SIZE");
            try {
                String string = this.b();
                long l2 = this.size(name);
                Date date = this.modtime(name);
                FTPFile fTPFile = new FTPFile("");
                fTPFile.setName(name);
                fTPFile.setLastModified(date);
                fTPFile.setSize(l2);
                fTPFile.setPath(string);
                return fTPFile;
            }
            catch (FTPException fTPException) {
                String string = "Failed to retrieve file details for " + name + ": " + fTPException.getMessage();
                b.debug(string);
                throw new FTPException(string);
            }
        }
    }

    public void dirDetails(String dirname, DirectoryListCallback lister) throws IOException, FTPException, ParseException {
        String string = this.b(dirname);
        b b2 = new b(this, this.w, lister, string);
        this.a(dirname, true, null, b2);
    }

    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        String string = this.b(dirname);
        FTPFile[] fTPFileArray = this.w.parse(this.dir(dirname, true));
        if (string != null) {
            for (int i2 = 0; i2 < fTPFileArray.length; ++i2) {
                fTPFileArray[i2].setPath(string);
            }
        }
        return fTPFileArray;
    }

    private String b(String string) throws FTPException, IOException {
        if (this.w == null) {
            try {
                this.w = new FTPFileFactory(this.system());
            }
            catch (FTPException fTPException) {
                b.warn("SYST command failed - setting Unix as default parser", fTPException);
                this.w = new FTPFileFactory("UNIX");
            }
        }
        this.w.setLocales(this.x);
        String string2 = this.b();
        if (string2 != null && string != null && string.length() > 0 && string.indexOf(42) < 0 && string.indexOf(63) < 0 && !string.equals(".")) {
            string2 = string2 + "/" + string;
        }
        b.debug("setupDirDetails(" + string + ") returning: " + string2);
        return string2;
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void a(String string, boolean bl, Vector vector, a a2) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        this.h = false;
        try {
            String string2;
            this.setupDataSocket();
            String string3 = string2 = bl ? "LIST " : "NLST ";
            if (string != null) {
                string2 = string2 + string;
            }
            string2 = string2.trim();
            this.lastReply = this.control.sendCommand(string2);
            String[] stringArray = new String[]{"125", "150", "226", "450", "550"};
            this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            Object[] objectArray = new String[]{};
            String string4 = this.lastValidReply.getReplyCode();
            if (!(string4.equals("450") || string4.equals("550") || string4.equals("226"))) {
                String[] stringArray2;
                block19: {
                    BufferedReader bufferedReader = null;
                    bufferedReader = new LineNumberReader(new InputStreamReader(this.getInputStream(), this.controlEncoding));
                    stringArray2 = null;
                    while ((stringArray2 = this.readLine((LineNumberReader)bufferedReader)) != null && !this.h) {
                        DirectoryListArgument directoryListArgument;
                        if (vector != null) {
                            vector.addElement(stringArray2);
                        }
                        if (a2 != null && (directoryListArgument = a2.a((String)stringArray2)) != null && directoryListArgument.isListingAborted()) {
                            b.warn("Aborting listing");
                            this.h = true;
                        }
                        b.log(Level.ALL, (String)stringArray2, null);
                    }
                    Object var13_14 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {
                        b.error("Failed to close socket in dir()", iOException);
                    }
                    {
                        break block19;
                        catch (IOException iOException) {
                            this.validateTransferOnError(iOException);
                            throw iOException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            b.error("Failed to close socket in dir()", iOException);
                        }
                        this.a();
                        throw throwable;
                    }
                }
                this.a();
                stringArray2 = new String[]{"226", "250"};
                this.lastReply = this.control.b();
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray2);
                if (vector != null && !vector.isEmpty()) {
                    objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                }
            } else {
                String string5 = this.lastValidReply.getReplyText().toUpperCase();
                if (!this.dirEmptyStrings.matches(string5) && !this.transferCompleteStrings.matches(string5)) {
                    throw new FTPException(this.lastReply);
                }
            }
            Object var16_19 = null;
            this.a();
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.a();
            throw throwable;
        }
    }

    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        Vector vector = new Vector();
        try {
            this.a(dirname, full, vector, null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Object[] objectArray = new String[]{};
        if (!vector.isEmpty()) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public int readChunk(BufferedInputStream in, byte[] chunk, int chunksize) throws IOException {
        return in.read(chunk, 0, chunksize);
    }

    protected int readChar(LineNumberReader in) throws IOException {
        return in.read();
    }

    protected String readLine(LineNumberReader in) throws IOException {
        return in.readLine();
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public FTPReply getLastReply() {
        return this.lastReply;
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        this.checkConnection(true);
        String string = FTPTransferType.a;
        if (type.equals(FTPTransferType.BINARY)) {
            string = FTPTransferType.b;
        }
        String[] stringArray = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("TYPE " + string);
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        String[] stringArray = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        ++this.s;
    }

    public void rename(String from, String to) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
        this.lastReply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    public void rmdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RMD " + dir);
        String[] stringArray = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public void mkdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MKD " + dir);
        String[] stringArray = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public void chdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("CWD " + dir);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("CDUP");
        String[] stringArray = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MDTM " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        Date date = this.c.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return date;
    }

    public void setModTime(String remoteFile, Date modTime) throws IOException, FTPException {
        this.checkConnection(true);
        String string = this.c.format(modTime);
        this.lastReply = this.control.sendCommand("MFMT " + string + " " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
    }

    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(this.lastReply, "257");
        String string = this.lastValidReply.getReplyText();
        int n2 = string.indexOf(34);
        int n3 = string.lastIndexOf(34);
        if (n2 >= 0 && n3 > n2) {
            return string.substring(n2 + 1, n3);
        }
        return string;
    }

    private String b() throws IOException {
        String string = null;
        try {
            string = this.pwd();
        }
        catch (FTPException fTPException) {
            b.debug("Ignoring exception: " + fTPException.getMessage());
        }
        return string;
    }

    public String[] features() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("FEAT");
        String[] stringArray = new String[]{"211", "500", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        if (this.lastValidReply.getReplyCode().equals("211")) {
            String[] stringArray2 = null;
            String[] stringArray3 = this.lastValidReply.getReplyData();
            if (stringArray3 != null && stringArray3.length > 2) {
                stringArray2 = new String[stringArray3.length - 2];
                for (int i2 = 0; i2 < stringArray3.length - 2; ++i2) {
                    stringArray2[i2] = stringArray3[i2 + 1].trim();
                }
            } else {
                stringArray2 = new String[]{};
            }
            return stringArray2;
        }
        throw new FTPException(this.lastReply);
    }

    public String system() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SYST");
        String[] stringArray = new String[]{"200", "213", "215", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    public void noOperation() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("NOOP");
        String[] stringArray = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public String stat() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("STAT");
        String[] stringArray = new String[]{"211", "212", "213"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    public void sendServerWakeup() throws IOException, FTPException {
        this.noOperation();
    }

    public void keepAlive() throws IOException, FTPException {
        b.debug("keepAlive() called");
        int n2 = (int)Math.ceil(Math.random() * 2.0);
        switch (n2) {
            case 1: {
                this.noOperation();
                break;
            }
            case 2: {
                this.pwd();
                break;
            }
            default: {
                this.pwd();
            }
        }
    }

    public String help(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("HELP " + command);
        String[] stringArray = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    protected void abort() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ABOR");
        String[] stringArray = new String[]{"426", "226"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException, FTPException {
        Object v1;
        block5: {
            this.checkConnection(true);
            try {
                this.lastReply = this.control.sendCommand("QUIT");
                String[] stringArray = new String[]{"221", "226"};
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var3_3 = null;
                try {
                    this.control.logout();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var5_7 = v0;
                this.control = null;
                throw throwable;
            }
            try {
                this.control.logout();
                v1 = null;
                break block5;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var5_6 = v1;
        this.control = null;
        this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quitImmediately() throws IOException, FTPException {
        this.cancelTransfer();
        try {
            if (this.control != null && this.control.controlSock != null) {
                this.control.controlSock.close();
            }
            Object var2_1 = null;
            this.control = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.control = null;
            throw throwable;
        }
        this.a();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("FTP").append(",").append(this.remoteHost).append(",").append(this.controlPort).append(",").append(this.getId()).append("]");
        return stringBuffer.toString();
    }

    static {
        b = Logger.getLogger("FTPClient");
        d = 0;
        DEFAULT_LISTING_LOCALES = new Locale[2];
        FTPClient.DEFAULT_LISTING_LOCALES[0] = Locale.ENGLISH;
        FTPClient.DEFAULT_LISTING_LOCALES[1] = Locale.getDefault();
    }

    class b
    implements a {
        private FTPFileFactory a;
        private DirectoryListCallback b;
        private String c;
        private final FTPClient d;

        b(FTPClient fTPClient, FTPFileFactory fTPFileFactory, DirectoryListCallback directoryListCallback, String string) {
            this.d = fTPClient;
            this.a = fTPFileFactory;
            this.b = directoryListCallback;
            this.c = string;
        }

        public DirectoryListArgument a(String string) throws ParseException {
            FTPFile fTPFile = this.a.parse(string);
            if (this.b != null && fTPFile != null) {
                fTPFile.setPath(this.c);
                DirectoryListArgument directoryListArgument = new DirectoryListArgument(fTPFile);
                this.b.listDirectoryEntry(directoryListArgument);
                return directoryListArgument;
            }
            return null;
        }
    }

    static interface a {
        public DirectoryListArgument a(String var1) throws ParseException;
    }
}

