/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.core;

public class ArrayUtil {
    private static byte[] a = new byte[500];

    private ArrayUtil() {
    }

    public static void clear(byte[] buf) {
        ArrayUtil.clear(buf, 0, buf.length);
    }

    public static void clear(byte[] buf, int offset, int length) {
        if (length <= 500) {
            System.arraycopy(a, 0, buf, offset, length);
        } else {
            System.arraycopy(a, 0, buf, offset, 500);
            int n2 = length / 2;
            for (int i2 = 500; i2 < length; i2 += i2) {
                System.arraycopy(buf, offset, buf, offset + i2, i2 <= n2 ? i2 : length - i2);
            }
        }
    }

    public static int toInt(short s0, short s1) {
        return s0 & 0xFFFF | s1 << 16;
    }

    public static short toShort(byte b0, byte b1) {
        return (short)(b0 & 0xFF | b1 << 8);
    }

    public static byte[] toBytes(int n2) {
        byte[] byArray = new byte[4];
        for (int i2 = 3; i2 >= 0; --i2) {
            byArray[i2] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
        }
        return byArray;
    }

    public static byte[] toBytes(short[] array, int offset, int length) {
        byte[] byArray = new byte[2 * length];
        int n2 = 0;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            byArray[n2++] = (byte)(array[i2] >>> 8 & 0xFF);
            byArray[n2++] = (byte)(array[i2] & 0xFF);
        }
        return byArray;
    }

    public static byte[] toBytes(short[] array) {
        return ArrayUtil.toBytes(array, 0, array.length);
    }

    public static short[] toShorts(byte[] array, int offset, int length) {
        short[] sArray = new short[length / 2];
        int n2 = 0;
        for (int i2 = offset; i2 < offset + length - 1; i2 += 2) {
            sArray[n2++] = (short)((array[i2] & 0xFF) << 8 | array[i2 + 1] & 0xFF);
        }
        return sArray;
    }

    public static short[] toShorts(byte[] array) {
        return ArrayUtil.toShorts(array, 0, array.length);
    }

    public static boolean areEqual(byte[] a2, byte[] b2) {
        int n2 = a2.length;
        if (n2 != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(int[] a2, int[] b2) {
        int n2 = a2.length;
        if (n2 != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static int compared(byte[] a2, byte[] b2, boolean msbFirst) {
        int n2 = a2.length;
        if (n2 < b2.length) {
            return -1;
        }
        if (n2 > b2.length) {
            return 1;
        }
        if (msbFirst) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                int n3 = a2[i2] & 0xFF;
                int n4 = b2[i2] & 0xFF;
                if (n3 < n4) {
                    return -1;
                }
                if (n3 <= n4) continue;
                return 1;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = a2[i3] & 0xFF;
                int n6 = b2[i3] & 0xFF;
                if (n5 < n6) {
                    return -1;
                }
                if (n5 <= n6) continue;
                return 1;
            }
        }
        return 0;
    }

    public static boolean isText(byte[] buffer) {
        int n2 = buffer.length;
        if (n2 == 0) {
            return false;
        }
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = buffer[i2] & 0xFF;
            if (n3 >= 32 && n3 <= 127) continue;
            switch (n3) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 26: 
                case 27: 
                case 155: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

