/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.checksum;

import java.util.zip.Checksum;

public class PRZ24
implements Checksum {
    private static final int[] a = new int[256];
    private int b;

    public PRZ24() {
        this.reset();
    }

    public void reset() {
        this.b = 11994318;
    }

    public void update(byte[] buffer, int offset, int length) {
        if (length + offset > buffer.length) {
            length = buffer.length - offset;
        }
        while (length-- > 0) {
            this.update(buffer[offset++]);
        }
    }

    public void update(int n2) {
        this.b = (this.b << 8 ^ a[this.b >>> 16 ^ n2 & 0xFF]) & 0xFFFFFF;
    }

    public long getValue() {
        return (long)this.b & 0xFFFFFFFFL;
    }

    static {
        PRZ24.a[0] = 0;
        PRZ24.a[1] = 8801531;
        int n2 = 2;
        for (int i2 = 1; i2 < 128; ++i2) {
            int n3 = a[i2] << 1;
            if ((n3 & 0x1000000) != 0) {
                PRZ24.a[n2++] = n3 ^ 0x864CFB;
                PRZ24.a[n2++] = n3;
                continue;
            }
            PRZ24.a[n2++] = n3;
            PRZ24.a[n2++] = n3 ^ 0x864CFB;
        }
    }
}

