/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.key;

import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.SecureRandom;
import xjava.security.ExtendedKeyGenerator;
import xjava.security.KeyGenerator;
import xjava.security.SecretKey;
import xjava.security.WeakKeyException;

public class RawKeyGenerator
extends KeyGenerator
implements Cloneable,
ExtendedKeyGenerator {
    private SecureRandom a;
    private int b;
    private int c;
    private int d;
    private boolean e;

    protected RawKeyGenerator(String algorithm, int seedlength) throws IllegalArgumentException {
        super(algorithm);
        if (seedlength <= 0) {
            throw new IllegalArgumentException("seedlength <= 0");
        }
        this.b = seedlength;
        this.c = seedlength;
        this.d = seedlength;
    }

    protected RawKeyGenerator(String algorithm, int minlength, int defaultlength, int maxlength) throws IllegalArgumentException {
        super(algorithm);
        if (0 >= minlength || minlength > defaultlength || defaultlength > maxlength) {
            throw new IllegalArgumentException("!(0 < minlength && minlength <= defaultlength && defaultlength <= maxlength)");
        }
        this.b = minlength;
        this.c = defaultlength;
        this.d = maxlength;
    }

    public SecretKey generateKey() {
        if (this.a == null) {
            this.a = new SecureRandom();
        }
        byte[] byArray = new byte[this.c];
        while (true) {
            this.a.nextBytes(byArray);
            try {
                byte[] byArray2 = this.engineGenerateKey(byArray);
                return new RawSecretKey(this.getAlgorithm(), byArray2);
            }
            catch (KeyException keyException) {
                continue;
            }
            break;
        }
    }

    public void initialize(SecureRandom random) {
        this.a = random;
    }

    public void initialize(SecureRandom random, int length) {
        if (!this.isValidKeyLength(length)) {
            throw new IllegalArgumentException("invalid key length for " + this.getAlgorithm() + ": " + length + " bytes");
        }
        this.a = random;
        this.c = length;
    }

    public boolean isWeakAllowed() {
        return this.e;
    }

    public void setWeakAllowed(boolean allowWeak) {
        this.e = allowWeak;
    }

    public int getMinimumKeyLength() {
        return this.b;
    }

    public int getDefaultKeyLength() {
        return this.c;
    }

    public int getMaximumKeyLength() {
        return this.d;
    }

    public boolean isValidKeyLength(int length) {
        return length >= this.b && length <= this.d;
    }

    public SecretKey generateKey(byte[] data) throws WeakKeyException, InvalidKeyException {
        if (!this.isValidKeyLength(data.length)) {
            throw new InvalidKeyException("invalid key length for " + this.getAlgorithm() + ": " + data.length + " bytes");
        }
        byte[] byArray = this.engineGenerateKey((byte[])data.clone());
        return new RawSecretKey(this.getAlgorithm(), byArray);
    }

    protected byte[] engineGenerateKey(byte[] seed) throws WeakKeyException, InvalidKeyException {
        if (!this.isWeakAllowed() && this.isWeak(seed)) {
            throw new WeakKeyException(this.getAlgorithm());
        }
        return seed;
    }

    protected boolean isWeak(byte[] key) {
        return false;
    }
}

