/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.key;

import com.enterprisedt.cryptix.provider.key.RawKeyGenerator;
import java.security.InvalidKeyException;
import xjava.security.WeakKeyException;

public class DESKeyGenerator
extends RawKeyGenerator {
    public DESKeyGenerator() {
        super("DES", 8);
    }

    protected DESKeyGenerator(String algorithm, int seedlength) {
        super(algorithm, seedlength);
    }

    protected byte[] engineGenerateKey(byte[] seed) throws WeakKeyException, InvalidKeyException {
        seed = super.engineGenerateKey(seed);
        this.setParity(seed);
        return seed;
    }

    protected void setParity(byte[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            byte by = array[i2];
            array[i2] = (byte)(by & 0xFE | (by >> 1 ^ by >> 2 ^ by >> 3 ^ by >> 4 ^ by >> 5 ^ by >> 6 ^ by >> 7) & 1);
        }
    }

    protected boolean isWeak(byte[] key) {
        return this.isWeak(key, 0);
    }

    protected boolean isWeak(byte[] key, int offset) {
        int n2 = (key[offset] & 0xFE) << 8 | key[offset + 1] & 0xFE;
        int n3 = (key[offset + 2] & 0xFE) << 8 | key[offset + 3] & 0xFE;
        int n4 = (key[offset + 4] & 0xFE) << 8 | key[offset + 5] & 0xFE;
        int n5 = (key[offset + 6] & 0xFE) << 8 | key[offset + 7] & 0xFE;
        return !(n2 != 0 && n2 != 65278 || n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278 || n5 != 0 && n5 != 65278);
    }
}

