/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalKeyPairGenerator;
import com.enterprisedt.cryptix.provider.elgamal.ElGamalAlgorithm;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.Random;
import xjava.security.AsymmetricCipher;
import xjava.security.Cipher;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public class RawElGamalCipher
extends Cipher
implements Cloneable,
AsymmetricCipher {
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private int f;
    private Random g;

    public RawElGamalCipher() {
        super(false, true, "CryptixEDT");
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        if (!(key instanceof ElGamalPublicKey)) {
            throw new InvalidKeyException("ElGamal: encryption key does not implement java.security.interfaces.ElGamalPublicKey");
        }
        ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)key;
        this.a(elGamalPublicKey.getP(), elGamalPublicKey.getG(), null, elGamalPublicKey.getY());
        if (this.g == null) {
            this.g = new SecureRandom();
        }
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        if (!(key instanceof ElGamalPrivateKey)) {
            throw new InvalidKeyException("ElGamal: decryption key does not implement java.security.interfaces.ElGamalPrivateKey");
        }
        ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)key;
        BigInteger bigInteger = elGamalPrivateKey.getX();
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getX() == null");
        }
        this.a(elGamalPrivateKey.getP(), elGamalPrivateKey.getG(), bigInteger, elGamalPrivateKey.getY());
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getP() == null");
        }
        if (bigInteger2 == null) {
            throw new InvalidKeyException("ElGamal: getG() == null");
        }
        if (bigInteger4 == null) {
            throw new InvalidKeyException("ElGamal: getY() == null");
        }
        this.b = bigInteger;
        this.c = bigInteger2;
        this.d = bigInteger3;
        this.e = bigInteger4;
        this.f = (this.b.bitLength() - 1) / 8;
    }

    protected int enginePlaintextBlockSize() {
        if (this.f == 0) {
            throw new CryptixException("ElGamal: plaintext block size is not valid until key is set");
        }
        return this.f;
    }

    protected int engineCiphertextBlockSize() {
        if (this.f == 0) {
            throw new CryptixException("ElGamal: ciphertext block size is not valid until key is set");
        }
        return this.f * 2;
    }

    protected void engineSetParameter(String param, Object value) {
        if (param.equals("random")) {
            if (!(value instanceof Random)) {
                throw new InvalidParameterException("value must be an instance of java.util.Random");
            }
            this.g = (Random)value;
            return;
        }
        throw new InvalidParameterException(param);
    }

    protected Object engineGetParameter(String param) {
        if (param.equals("random")) {
            return this.g;
        }
        return null;
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (inLen <= 0) {
            return 0;
        }
        if (this.getState() == 1) {
            if (inLen != this.f) {
                throw new IllegalBlockSizeException("inLen = " + inLen + ", plaintext block size = " + this.f);
            }
            byte[] byArray = new byte[this.f];
            System.arraycopy(in, inOffset, byArray, 0, this.f);
            BigInteger[] bigIntegerArray = new BigInteger[2];
            BigInteger bigInteger = new BigInteger(1, byArray);
            ElGamalAlgorithm.encrypt(bigInteger, bigIntegerArray, this.b, this.c, this.e, this.g);
            byte[] byArray2 = bigIntegerArray[0].toByteArray();
            byte[] byArray3 = bigIntegerArray[1].toByteArray();
            ArrayUtil.clear(out, outOffset, this.f * 2);
            System.arraycopy(byArray2, 0, out, outOffset + this.f - byArray2.length, byArray2.length);
            System.arraycopy(byArray3, 0, out, outOffset + this.f * 2 - byArray3.length, byArray3.length);
            ArrayUtil.clear(byArray);
            return this.f * 2;
        }
        if (inLen != this.f * 2) {
            throw new IllegalBlockSizeException("inLen = " + inLen + ", ciphertext block size = " + this.f * 2);
        }
        byte[] byArray = new byte[this.f];
        System.arraycopy(in, inOffset, byArray, 0, this.f);
        BigInteger bigInteger = new BigInteger(1, byArray);
        System.arraycopy(in, inOffset + this.f, byArray, 0, this.f);
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        BigInteger bigInteger3 = ElGamalAlgorithm.decrypt(bigInteger, bigInteger2, this.b, this.c, this.d);
        byte[] byArray4 = bigInteger3.toByteArray();
        ArrayUtil.clear(out, outOffset, this.f - byArray4.length);
        System.arraycopy(byArray4, 0, out, outOffset + this.f - byArray4.length, byArray4.length);
        return this.f;
    }

    public static final void main(String[] args) {
        try {
            RawElGamalCipher.self_test(new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter out) throws KeyException {
        BaseElGamalKeyPairGenerator baseElGamalKeyPairGenerator = new BaseElGamalKeyPairGenerator();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = System.currentTimeMillis();
        ((KeyPairGenerator)baseElGamalKeyPairGenerator).initialize(385, secureRandom);
        KeyPair keyPair = ((KeyPairGenerator)baseElGamalKeyPairGenerator).generateKeyPair();
        long l3 = System.currentTimeMillis() - l2;
        out.println("Keygen: " + (float)l3 / 1000.0f + " seconds");
        RawElGamalCipher rawElGamalCipher = new RawElGamalCipher();
        rawElGamalCipher.a(out, keyPair, secureRandom);
    }

    private void a(PrintWriter printWriter, KeyPair keyPair, SecureRandom secureRandom) throws KeyException {
        ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)keyPair.getPrivate();
        ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)keyPair.getPublic();
        BigInteger bigInteger = new BigInteger(elGamalPrivateKey.getP().bitLength() - 1, secureRandom);
        this.g = secureRandom;
        long l2 = System.currentTimeMillis();
        this.initEncrypt(elGamalPublicKey);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        ElGamalAlgorithm.encrypt(bigInteger, bigIntegerArray, this.b, this.c, this.e, this.g);
        long l3 = System.currentTimeMillis();
        this.initDecrypt(elGamalPrivateKey);
        BigInteger bigInteger2 = ElGamalAlgorithm.decrypt(bigIntegerArray[0], bigIntegerArray[1], this.b, this.c, this.d);
        long l4 = System.currentTimeMillis();
        printWriter.println("p = " + this.b);
        printWriter.println("g = " + this.c);
        printWriter.println("x = " + this.d);
        printWriter.println("y = " + this.e);
        printWriter.println("M = " + bigInteger);
        printWriter.println("a = " + bigIntegerArray[0]);
        printWriter.println("b = " + bigIntegerArray[1]);
        if (!bigInteger.equals(bigInteger2)) {
            printWriter.println("DECRYPTION FAILED!");
            printWriter.println("M' = " + bigInteger2);
        }
        printWriter.println("Encrypt: " + (float)(l3 - l2) / 1000.0f + " seconds");
        printWriter.println("Decrypt: " + (float)(l4 - l3) / 1000.0f + " seconds");
    }
}

