/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalParams;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import xjava.security.interfaces.ElGamalParams;

public class GenericElGamalParameterSet {
    private int[] a;
    private String[][] b;

    protected GenericElGamalParameterSet(int[] primeLengths, String[][] precomputed) {
        if (precomputed.length != primeLengths.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        this.a = primeLengths;
        this.b = precomputed;
    }

    public ElGamalParams getParameters(int primeLength) {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (primeLength != this.a[i2]) continue;
            return new BaseElGamalParams(new BigInteger(this.b[i2][0], 16), this.b[i2][1] != null ? new BigInteger(this.b[i2][1], 16) : null);
        }
        return null;
    }

    public void checkSane() throws InvalidParameterException {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            BigInteger bigInteger = new BigInteger(this.b[i2][0]);
            if (bigInteger.bitLength() < this.a[i2]) {
                throw new InvalidParameterException(bigInteger + " has incorrect bit length");
            }
            BigInteger bigInteger2 = new BigInteger(this.b[i2][1]);
            if (!bigInteger.isProbablePrime(80)) {
                throw new InvalidParameterException(bigInteger + " is not prime");
            }
            if (bigInteger2.compareTo(bigInteger) < 0) continue;
            throw new InvalidParameterException("g >= p");
        }
    }
}

