/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.CryptixProperties;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalParams;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalPrivateKey;
import com.enterprisedt.cryptix.provider.elgamal.BaseElGamalPublicKey;
import com.enterprisedt.cryptix.provider.elgamal.DefaultElGamalParameterSet;
import com.enterprisedt.cryptix.provider.elgamal.GenericElGamalParameterSet;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.math.Prime;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.interfaces.ElGamalKeyPairGenerator;
import xjava.security.interfaces.ElGamalParams;

public class BaseElGamalKeyPairGenerator
extends KeyPairGenerator
implements ElGamalKeyPairGenerator {
    private static final boolean a;
    private static final int b;
    private static final BigInteger c;
    private static GenericElGamalParameterSet d;
    protected BigInteger p;
    protected BigInteger g;
    protected SecureRandom source;

    private static void a(String string) {
        Debug.log("BaseElGamalKeyPairGenerator: " + string);
    }

    private static void b(String string) {
        Debug.log(string);
    }

    public BaseElGamalKeyPairGenerator() {
        super("ElGamal");
    }

    public void initialize(ElGamalParams params, SecureRandom random) throws InvalidParameterException {
        this.initialize(params.getP(), params.getG(), random);
    }

    public void initialize(BigInteger prime, BigInteger base, SecureRandom random) throws InvalidParameterException {
        if (prime == null) {
            throw new NullPointerException("prime == null");
        }
        if (base == null) {
            throw new NullPointerException("base == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        if (base.compareTo(prime) >= 0) {
            throw new InvalidParameterException("base >= prime");
        }
        this.p = prime;
        this.g = base;
        this.source = random;
    }

    public void initialize(int primeLen, SecureRandom random) {
        ElGamalParams elGamalParams = null;
        if (d != null) {
            elGamalParams = d.getParameters(primeLen);
        }
        if (elGamalParams == null) {
            elGamalParams = this.generateParams(primeLen, random);
        }
        this.p = elGamalParams.getP();
        this.g = elGamalParams.getG();
        this.source = random;
    }

    public void initialize(int primeLen, boolean genParams, SecureRandom random) throws InvalidParameterException {
        ElGamalParams elGamalParams;
        if (primeLen < 256) {
            throw new InvalidParameterException("ElGamal: prime length " + primeLen + " is too short (< " + 256 + ")");
        }
        if (genParams || d == null) {
            elGamalParams = this.generateParams(primeLen, random);
        } else {
            elGamalParams = d.getParameters(primeLen);
            if (elGamalParams == null) {
                throw new InvalidParameterException("ElGamal: no pre-computed parameters for prime length " + primeLen);
            }
        }
        this.p = elGamalParams.getP();
        this.g = elGamalParams.getG();
        this.source = random;
    }

    public KeyPair generateKeyPair() {
        if (this.p == null) {
            throw new CryptixException("ElGamal: key pair generator not initialized");
        }
        int n2 = this.p.bitLength() - 1;
        BigInteger bigInteger = new BigInteger(n2, this.source).setBit(n2);
        BaseElGamalPrivateKey baseElGamalPrivateKey = new BaseElGamalPrivateKey(this.p, this.g, bigInteger);
        BaseElGamalPublicKey baseElGamalPublicKey = new BaseElGamalPublicKey(this.p, this.g, baseElGamalPrivateKey.getY());
        return new KeyPair(baseElGamalPublicKey, baseElGamalPrivateKey);
    }

    public ElGamalParams generateParams(int primeLen, SecureRandom random) throws InvalidParameterException {
        if (primeLen < 256) {
            throw new InvalidParameterException("ElGamal: prime length " + primeLen + " is too short (< " + 256 + ")");
        }
        Object[] objectArray = Prime.getElGamal(primeLen, 80, random, 1);
        BigInteger bigInteger = (BigInteger)objectArray[0];
        BigInteger[] bigIntegerArray = (BigInteger[])objectArray[1];
        BigInteger bigInteger2 = BaseElGamalKeyPairGenerator.a(bigInteger, bigIntegerArray, random);
        return new BaseElGamalParams(bigInteger, bigInteger2);
    }

    private static BigInteger a(BigInteger bigInteger, BigInteger[] bigIntegerArray, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        int n2;
        BigInteger bigInteger3 = bigInteger.subtract(c);
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
            bigIntegerArray2[n2] = bigInteger3.divide(bigIntegerArray[n2]);
        }
        if (a && b >= 5) {
            BaseElGamalKeyPairGenerator.b("g =");
        }
        n2 = bigInteger.bitLength() - 1;
        do {
            if (!a || b < 5) continue;
            BaseElGamalKeyPairGenerator.b(" ?");
        } while (!Prime.isGeneratorModP(bigInteger2 = new BigInteger(n2, secureRandom).setBit(n2), bigInteger, bigIntegerArray2));
        if (a && b >= 4) {
            BaseElGamalKeyPairGenerator.a(" OK");
        }
        return bigInteger2;
    }

    static {
        block4: {
            a = Debug.GLOBAL_DEBUG;
            b = a ? Debug.getLevel("ElGamal", "BaseElGamalKeyPairGenerator") : 0;
            c = BigInteger.valueOf(1L);
            try {
                String string = CryptixProperties.getProperty("Alg.DefaultParameterSet.ElGamal");
                if (string != null) {
                    d = (GenericElGamalParameterSet)Class.forName(string).newInstance();
                }
            }
            catch (Exception exception) {
                if (!a || b < 1) break block4;
                BaseElGamalKeyPairGenerator.a("exception while instantiating default parameter set: " + exception);
            }
        }
        if (d == null) {
            d = new DefaultElGamalParameterSet();
        }
    }
}

