/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.dsa;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class RawDSASignature
extends Signature {
    private BigInteger a;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    byte[] b = null;
    SecureRandom c;

    public RawDSASignature(String name) {
        super(name);
    }

    public RawDSASignature() {
        super("RawDSA");
    }

    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof DSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a DSA Public Key");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
        this.a(dSAPublicKey.getParams());
        this.f = dSAPublicKey.getY();
    }

    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof DSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a DSA Private Key");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
        this.a(dSAPrivateKey.getParams());
        this.f = dSAPrivateKey.getX();
    }

    protected void engineUpdate(byte b2) throws SignatureException {
        throw new SignatureException(this.getAlgorithm() + ": Must be called with a SHA-1 digest for input");
    }

    protected void engineUpdate(byte[] b2, int off, int len) throws SignatureException {
        if (this.b != null) {
            throw new SignatureException(this.getAlgorithm() + ": Raw DSA may only be updated once");
        }
        if (len != 20) {
            throw new SignatureException(this.getAlgorithm() + ": Raw DSA must have a 20 byte input");
        }
        this.b = new byte[20];
        System.arraycopy(b2, off, this.b, 0, len);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.b == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply digest");
        }
        if (this.c == null) {
            this.c = new SecureRandom();
        }
        BigInteger bigInteger = new BigInteger(180, this.c);
        BigInteger bigInteger2 = bigInteger.mod(this.d);
        BigInteger bigInteger3 = bigInteger2.modInverse(this.d);
        BigInteger bigInteger4 = this.e.modPow(bigInteger2, this.a).mod(this.d);
        BigInteger bigInteger5 = new BigInteger(1, this.b);
        BigInteger bigInteger6 = bigInteger5.add(this.f.multiply(bigInteger4));
        bigInteger6 = bigInteger6.multiply(bigInteger3);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        byte[] byArray = bigInteger4.toByteArray();
        byte[] byArray2 = bigInteger7.toByteArray();
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 6];
        byArray3[0] = 48;
        byArray3[1] = (byte)(byArray.length + byArray2.length + 4 & 0xFF);
        int n2 = 2;
        byArray3[n2++] = 2;
        byArray3[n2++] = (byte)(byArray.length & 0xFF);
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        n2 += byArray.length;
        byArray3[n2++] = 2;
        byArray3[n2++] = (byte)(byArray2.length & 0xFF);
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        return byArray3;
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        int n2 = 0;
        int n3 = signature.length;
        if (this.b == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply digest");
        }
        BigInteger bigInteger = new BigInteger(1, this.b);
        this.a(signature, n2++, 48, "Tag: expecting sequence");
        this.a(signature, n2++, signature.length - 2, "length");
        this.a(signature, n2++, 2, "Tag: expecting integer");
        byte by = signature[n2++];
        if (by > (n3 -= 4)) {
            throw new SignatureException("r longer than total encoding");
        }
        byte[] byArray = new byte[by];
        System.arraycopy(signature, n2, byArray, 0, by);
        n3 -= by;
        n2 += by;
        this.a(signature, n2++, 2, "Tag: expecting integer");
        byte by2 = signature[n2++];
        if (by2 != (n3 -= 2)) {
            throw new SignatureException("incorrect length for than total encoding");
        }
        byte[] byArray2 = new byte[by2];
        System.arraycopy(signature, n2, byArray2, 0, by2);
        BigInteger bigInteger2 = new BigInteger(byArray);
        BigInteger bigInteger3 = new BigInteger(byArray2);
        BigInteger bigInteger4 = new BigInteger("0");
        if (bigInteger2.compareTo(bigInteger4) <= 0) {
            return false;
        }
        if (bigInteger2.compareTo(this.d) >= 0) {
            return false;
        }
        if (bigInteger3.compareTo(bigInteger4) <= 0) {
            return false;
        }
        if (bigInteger3.compareTo(this.d) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger3.modInverse(this.d);
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger5);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        BigInteger bigInteger8 = bigInteger2.multiply(bigInteger5);
        BigInteger bigInteger9 = bigInteger8.mod(this.d);
        BigInteger bigInteger10 = this.e.modPow(bigInteger7, this.a);
        BigInteger bigInteger11 = this.f.modPow(bigInteger9, this.a);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.mod(this.a);
        BigInteger bigInteger14 = bigInteger13.mod(this.d);
        return bigInteger14.equals(bigInteger2);
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        if (param.equals("SecureRandom")) {
            this.c = (SecureRandom)value;
            return;
        }
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    private void a(byte[] byArray, int n2, int n3, String string) throws SignatureException {
        if (byArray[n2] != n3) {
            throw new SignatureException(this.getAlgorithm() + ": Encoding error. Bad " + string);
        }
    }

    private void a(DSAParams dSAParams) {
        this.a = dSAParams.getP();
        this.d = dSAParams.getQ();
        this.e = dSAParams.getG();
    }
}

