/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.cipher;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class Square
extends Cipher
implements SymmetricCipher {
    private static final boolean b;
    private static final int c;
    private static final byte[] d;
    private static final byte[] e;
    private static final int[] f;
    private static final int[] g;
    private int[][] h = new int[9][4];
    private static final int[] i;
    private static final String[][] j;

    private static void d(String string) {
        Debug.log("Square: " + string);
    }

    public Square() {
        super(false, false, "CryptixEDT");
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 16;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.a(key, true);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        this.a(key, false);
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        boolean bl;
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n2 = inLen / 16;
        inLen = n2 * 16;
        boolean bl2 = bl = this.getState() == 1;
        if (in == out && (outOffset >= inOffset && (long)outOffset < (long)inOffset + (long)inLen || inOffset >= outOffset && (long)inOffset < (long)outOffset + (long)inLen)) {
            byte[] byArray = new byte[inLen];
            System.arraycopy(in, inOffset, byArray, 0, inLen);
            in = byArray;
            inOffset = 0;
        }
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a(in, inOffset, out, outOffset, f, d);
                inOffset += 16;
                outOffset += 16;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.a(in, inOffset, out, outOffset, g, e);
                inOffset += 16;
                outOffset += 16;
            }
        }
        return inLen;
    }

    private void a(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        int n2 = 0;
        if (bl) {
            int n3;
            for (n3 = 0; n3 < 4; ++n3) {
                this.h[0][n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
            for (n3 = 1; n3 < 9; ++n3) {
                n2 = n3 - 1;
                this.h[n3][0] = this.h[n2][0] ^ Square.a(this.h[n2][3], 8) ^ i[n2];
                this.h[n3][1] = this.h[n2][1] ^ this.h[n3][0];
                this.h[n3][2] = this.h[n2][2] ^ this.h[n3][1];
                this.h[n3][3] = this.h[n2][3] ^ this.h[n3][2];
                Square.a(this.h[n2], this.h[n2]);
            }
        } else {
            int n4;
            int[][] nArray = new int[9][4];
            for (n4 = 0; n4 < 4; ++n4) {
                nArray[0][n4] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
            for (n4 = 1; n4 < 9; ++n4) {
                n2 = n4 - 1;
                nArray[n4][0] = nArray[n2][0] ^ Square.a(nArray[n2][3], 8) ^ i[n2];
                nArray[n4][1] = nArray[n2][1] ^ nArray[n4][0];
                nArray[n4][2] = nArray[n2][2] ^ nArray[n4][1];
                nArray[n4][3] = nArray[n2][3] ^ nArray[n4][2];
            }
            for (n4 = 0; n4 < 8; ++n4) {
                System.arraycopy(nArray[8 - n4], 0, this.h[n4], 0, 4);
            }
            Square.a(nArray[0], this.h[8]);
        }
    }

    private static void a(int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = nArray[i2];
            int n3 = n2 >>> 8;
            int n4 = n2 >>> 16;
            int n5 = n2 >>> 24;
            int n6 = ((Square.c(n5, 2) ^ Square.c(n4, 3) ^ n3 ^ n2) & 0xFF) << 24;
            n6 ^= ((n5 ^ Square.c(n4, 2) ^ Square.c(n3, 3) ^ n2) & 0xFF) << 16;
            n6 ^= ((n5 ^ n4 ^ Square.c(n3, 2) ^ Square.c(n2, 3)) & 0xFF) << 8;
            nArray2[i2] = n6 ^= (Square.c(n5, 3) ^ n4 ^ n3 ^ Square.c(n2, 2)) & 0xFF;
        }
    }

    private static int a(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private static int b(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    private static final int c(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        n2 &= 0xFF;
        n3 &= 0xFF;
        int n4 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                n4 ^= n2;
            }
            if ((n2 <<= 1) > 255) {
                n2 ^= 0x1F5;
            }
            n3 >>>= 1;
        }
        return n4 & 0xFF;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3, int[] nArray, byte[] byArray3) {
        int n4;
        int n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n6 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n7 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n8 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        n5 ^= this.h[0][0];
        n6 ^= this.h[0][1];
        n7 ^= this.h[0][2];
        n8 ^= this.h[0][3];
        for (n4 = 1; n4 < 8; ++n4) {
            int n9 = nArray[n5 >>> 24 & 0xFF] ^ Square.b(nArray[n6 >>> 24 & 0xFF], 8) ^ Square.b(nArray[n7 >>> 24 & 0xFF], 16) ^ Square.b(nArray[n8 >>> 24 & 0xFF], 24) ^ this.h[n4][0];
            int n10 = nArray[n5 >>> 16 & 0xFF] ^ Square.b(nArray[n6 >>> 16 & 0xFF], 8) ^ Square.b(nArray[n7 >>> 16 & 0xFF], 16) ^ Square.b(nArray[n8 >>> 16 & 0xFF], 24) ^ this.h[n4][1];
            int n11 = nArray[n5 >>> 8 & 0xFF] ^ Square.b(nArray[n6 >>> 8 & 0xFF], 8) ^ Square.b(nArray[n7 >>> 8 & 0xFF], 16) ^ Square.b(nArray[n8 >>> 8 & 0xFF], 24) ^ this.h[n4][2];
            int n12 = nArray[n5 & 0xFF] ^ Square.b(nArray[n6 & 0xFF], 8) ^ Square.b(nArray[n7 & 0xFF], 16) ^ Square.b(nArray[n8 & 0xFF], 24) ^ this.h[n4][3];
            n5 = n9;
            n6 = n10;
            n7 = n11;
            n8 = n12;
        }
        n4 = 0;
        int n13 = 24;
        while (n4 < 4) {
            int n14 = (byArray3[n5 >>> n13 & 0xFF] & 0xFF) << 24 | (byArray3[n6 >>> n13 & 0xFF] & 0xFF) << 16 | (byArray3[n7 >>> n13 & 0xFF] & 0xFF) << 8 | byArray3[n8 >>> n13 & 0xFF] & 0xFF;
            byArray2[n3++] = (byte)((n14 ^= this.h[8][n4]) >>> 24 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 16 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 8 & 0xFF);
            byArray2[n3++] = (byte)(n14 & 0xFF);
            ++n4;
            n13 -= 8;
        }
    }

    public static final void main(String[] args) {
        try {
            Square.a();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void a() throws Exception {
        Cipher cipher = Cipher.getInstance("Square", "CryptixEDT");
        for (int i2 = 0; i2 < j.length; ++i2) {
            RawSecretKey rawSecretKey = new RawSecretKey("Square", Hex.fromString(j[i2][0]));
            byte[] byArray = Hex.fromString(j[i2][1]);
            byte[] byArray2 = Hex.fromString(j[i2][2]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray3 = cipher.crypt(byArray);
            if (!ArrayUtil.areEqual(byArray2, byArray3)) {
                System.out.println("     input: " + Hex.toString(byArray));
                System.out.println("  computed: " + Hex.toString(byArray3));
                System.out.println(" certified: " + Hex.toString(byArray2));
                throw new CryptixException("encrypt #" + i2 + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray3 = cipher.crypt(byArray2);
            if (ArrayUtil.areEqual(byArray, byArray3)) continue;
            throw new CryptixException("decrypt #" + i2 + " failed");
        }
        if (b && c > 0) {
            Square.d("Self-test OK");
        }
    }

    static {
        int n2;
        int n3;
        b = Debug.GLOBAL_DEBUG;
        c = b ? Debug.getLevel("Square") : 0;
        d = new byte[256];
        e = new byte[256];
        f = new int[256];
        g = new int[256];
        i = new int[8];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byArray[0] = 1;
        for (n3 = 1; n3 < 256; ++n3) {
            n2 = byArray[n3 - 1] << 1;
            if ((n2 & 0x100) != 0) {
                n2 ^= 0x1F5;
            }
            byArray[n3] = (byte)n2;
            byArray2[n2 & 0xFF] = (byte)n3;
        }
        Square.d[0] = 0;
        Square.d[1] = 1;
        for (n3 = 2; n3 < 256; ++n3) {
            Square.d[n3] = byArray[255 - byArray2[n3] & 0xFF];
        }
        int[] nArray = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        for (n3 = 0; n3 < 256; ++n3) {
            int n4 = 177;
            for (n2 = 0; n2 < 8; ++n2) {
                int n5 = d[n3] & nArray[n2] & 0xFF;
                n5 ^= n5 >>> 4;
                n5 ^= n5 >>> 2;
                n5 ^= n5 >>> 1;
                n4 ^= (n5 &= 1) << n2;
            }
            Square.d[n3] = (byte)n4;
            Square.e[n4] = (byte)n3;
        }
        Square.i[0] = 1;
        for (n3 = 1; n3 < 8; ++n3) {
            Square.i[n3] = Square.c(i[n3 - 1], 2);
            int n6 = n3 - 1;
            i[n6] = i[n6] << 24;
        }
        i[7] = i[7] << 24;
        for (n3 = 0; n3 < 256; ++n3) {
            int n7 = d[n3] & 0xFF;
            int n8 = e[n3] & 0xFF;
            Square.f[n3] = d[n3 & 3] == 0 ? 0 : Square.c(n7, 2) << 24 | n7 << 16 | n7 << 8 | Square.c(n7, 3);
            Square.g[n3] = e[n3 & 3] == 0 ? 0 : Square.c(n8, 14) << 24 | Square.c(n8, 9) << 16 | Square.c(n8, 13) << 8 | Square.c(n8, 11);
        }
        j = new String[][]{{"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F"}, {"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F7C3491D94994E70F0EC2E7A5CCB5A14F"}};
    }
}

