/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.cipher;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.Security;
import xjava.security.Cipher;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.SymmetricCipher;

public final class SPEED
extends Cipher
implements SymmetricCipher {
    private static final boolean b = Debug.GLOBAL_DEBUG;
    private static final boolean c = Debug.GLOBAL_DEBUG_SLOW;
    private static final int d = b ? Debug.getLevel("SPEED") : 0;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;
    private int l;
    private int m;
    private int n;
    private int o;
    private int p;
    private int q;
    private int[] r;
    private int s;
    private int[] t;

    private static void d(String string) {
        Debug.log("SPEED: " + string);
    }

    public SPEED() {
        block7: {
            String string;
            block6: {
                super(false, false, "CryptixEDT");
                this.e = 64;
                this.f = 8;
                try {
                    string = Security.getAlgorithmProperty("SPEED", "rounds");
                    if (string != null) {
                        this.setRounds(Integer.parseInt(string));
                    }
                }
                catch (Exception exception) {
                    if (!b || d <= 0) break block6;
                    SPEED.d("Could not set number of rounds");
                }
            }
            try {
                string = Security.getAlgorithmProperty("SPEED", "blockSize");
                if (string != null) {
                    this.setBlockSize(Integer.parseInt(string));
                }
            }
            catch (Exception exception) {
                if (!b || d <= 0) break block7;
                SPEED.d("Could not set block size");
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return this.f;
    }

    public void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.a(key);
    }

    public void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.a(key);
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        boolean bl;
        int n2 = this.f;
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n3 = inLen / n2;
        inLen = n3 * n2;
        boolean bl2 = bl = this.getState() == 1;
        if (in == out && (outOffset >= inOffset && (long)outOffset < (long)inOffset + (long)inLen || inOffset >= outOffset && (long)inOffset < (long)outOffset + (long)inLen)) {
            byte[] byArray = new byte[inLen];
            System.arraycopy(in, inOffset, byArray, 0, inLen);
            in = byArray;
            inOffset = 0;
        }
        if (bl) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.blockEncrypt(in, inOffset, out, outOffset);
                inOffset += n2;
                outOffset += n2;
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.blockDecrypt(in, inOffset, out, outOffset);
                inOffset += n2;
                outOffset += n2;
            }
        }
        return inLen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String param, Object value) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (param.equalsIgnoreCase("rounds")) {
            if (!(value instanceof Integer)) throw new InvalidParameterTypeException("rounds.SPEED");
            this.setRounds((Integer)value);
            return;
        } else {
            if (!param.equalsIgnoreCase("blockSize")) throw new NoSuchParameterException(param + ".SPEED");
            if (!(value instanceof Integer)) throw new InvalidParameterTypeException("blockSize.SPEED");
            this.setBlockSize((Integer)value);
        }
    }

    protected Object engineGetParameter(String param) throws NoSuchParameterException, InvalidParameterException {
        if (param.equalsIgnoreCase("rounds")) {
            return new Integer(this.e);
        }
        if (param.equalsIgnoreCase("blockSize")) {
            return new Integer(this.f);
        }
        throw new NoSuchParameterException(param + ".SPEED");
    }

    public void setRounds(int rounds) {
        if (this.getState() != 0) {
            throw new IllegalStateException(this.getAlgorithm() + ": Cipher not in UNINITIALIZED state");
        }
        if (rounds < 32 || rounds % 4 != 0) {
            throw new IllegalArgumentException(this.getAlgorithm() + ": Invalid number of rounds");
        }
        this.e = rounds;
    }

    public int getRounds() {
        return this.e;
    }

    public void setBlockSize(int blocksize) {
        if (this.getState() != 0) {
            throw new IllegalStateException(this.getAlgorithm() + ": Cipher not in UNINITIALIZED state");
        }
        if (blocksize != 8 && blocksize != 16 && blocksize != 32) {
            throw new IllegalArgumentException(this.getAlgorithm() + ": Invalid block size");
        }
        this.f = blocksize;
    }

    private void a(Key key) throws InvalidKeyException {
        int n2;
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        int n3 = byArray.length;
        if (n3 < 6 || n3 > 32) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        this.b(byArray.length);
        this.t = new int[this.q];
        this.r = new int[this.e];
        for (n2 = 0; n2 < this.s; ++n2) {
            this.t[n2] = byArray[2 * n2] | byArray[2 * n2 + 1] << 8;
        }
        for (n2 = this.s; n2 < this.q; ++n2) {
            int n4 = this.k & this.j ^ this.j & this.i ^ this.i & this.k;
            n4 = n4 << 5 | n4 >>> 11;
            n4 += this.k + this.t[n2 % this.s];
            this.k = this.j;
            this.j = this.i;
            this.i = this.t[n2] = (n4 &= 0xFFFF);
        }
        if (b && d >= 5) {
            SPEED.d("kb_bits=" + this.q + ", kb.length=" + this.t.length + ", round_key.length=" + this.r.length);
        }
        switch (this.h) {
            case 256: {
                for (n2 = 0; n2 < this.q / 2; ++n2) {
                    this.r[n2] = this.t[2 * n2] | this.t[2 * n2 + 1] << 16;
                }
                break;
            }
            case 128: {
                for (n2 = 0; n2 < this.q; ++n2) {
                    this.r[n2] = this.t[n2];
                }
                break;
            }
            case 64: {
                for (n2 = 0; n2 < this.q; ++n2) {
                    this.r[2 * n2] = this.t[n2] & 0xFF;
                    this.r[2 * n2 + 1] = this.t[n2] >>> 8 & 0xFF;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.h + " illegal in key_schedule?");
            }
        }
    }

    private void b(int n2) {
        this.g = n2 * 8;
        this.s = n2 / 2;
        this.c(this.g);
        this.h = this.f * 8;
        this.l = this.h / 8;
        this.m = this.l / 2;
        switch (this.h) {
            case 256: {
                this.n = -1;
                this.o = 65535;
                this.p = 11;
                this.q = 2 * this.e;
                break;
            }
            case 128: {
                this.n = 65535;
                this.o = 255;
                this.p = 4;
                this.q = this.e;
                break;
            }
            case 64: {
                this.n = 255;
                this.o = 15;
                this.p = 1;
                this.q = this.e / 2;
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.h + " is bad data size (not 64/128/256)");
            }
        }
    }

    private void c(int n2) {
        switch (n2) {
            case 48: {
                this.i = 57211;
                this.j = 54825;
                this.k = 59867;
                return;
            }
            case 64: {
                this.i = 13871;
                this.j = 23808;
                this.k = 61967;
                return;
            }
            case 80: {
                this.i = 50129;
                this.j = 8146;
                this.k = 22683;
                return;
            }
            case 96: {
                this.i = 17170;
                this.j = 37355;
                this.k = 29070;
                return;
            }
            case 112: {
                this.i = 48938;
                this.j = 7805;
                this.k = 45655;
                return;
            }
            case 128: {
                this.i = 30630;
                this.j = 5716;
                this.k = 27434;
                return;
            }
            case 144: {
                this.i = 3483;
                this.j = 43475;
                this.k = 26255;
                return;
            }
            case 160: {
                this.i = 6590;
                this.j = 63573;
                this.k = 28056;
                return;
            }
            case 176: {
                this.i = 557;
                this.j = 58594;
                this.k = 53271;
                return;
            }
            case 192: {
                this.i = 59951;
                this.j = 30066;
                this.k = 50101;
                return;
            }
            case 208: {
                this.i = 4230;
                this.j = 18444;
                this.k = 15014;
                return;
            }
            case 224: {
                this.i = 40096;
                this.j = 39159;
                this.k = 53476;
                return;
            }
            case 240: {
                this.i = 9532;
                this.j = 51457;
                this.k = 22003;
                return;
            }
            case 256: {
                this.i = 39924;
                this.j = 63065;
                this.k = 55148;
                return;
            }
        }
        throw new CryptixException("SPEED: " + n2 + " is bad key length (not 48 .. 256 % 16)");
    }

    void a() {
        int n2;
        if (0 == this.h) {
            SPEED.d("no data set yet");
            return;
        }
        SPEED.d("KEY SCHEDULE");
        SPEED.d(" data_bits " + this.h);
        SPEED.d(" kb_bits " + this.q);
        SPEED.d(" kb.length " + this.t.length);
        SPEED.d(" f_wd_mask " + Hex.intToString(this.n));
        SPEED.d(" h_wd_mask " + Hex.intToString(this.o));
        SPEED.d(" v_shift " + this.p);
        SPEED.d(" double byte buffer");
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.s; ++n2) {
            stringBuffer.append(" ").append(Hex.intToString(this.t[n2]));
        }
        SPEED.d(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        switch (this.h) {
            case 256: {
                for (n2 = 0; n2 < this.q / 2; ++n2) {
                    stringBuffer.append(" ").append(Hex.intToString(this.r[n2]));
                }
                break;
            }
            case 128: {
                for (n2 = 0; n2 < this.q; ++n2) {
                    stringBuffer.append(" ").append(Hex.shortToString(this.r[n2]));
                }
                break;
            }
            case 64: {
                for (n2 = 0; n2 < this.q * 2; ++n2) {
                    stringBuffer.append(" ").append(Hex.byteToString(this.r[n2]));
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: data_bits=" + this.h + " illegal in key_schedule?");
            }
        }
        SPEED.d(stringBuffer.toString());
    }

    private void a(byte[] byArray, int n2, int[] nArray) {
        switch (this.h) {
            case 256: {
                for (int i2 = 0; i2 < 8; ++i2) {
                    nArray[i2] = byArray[n2 + 4 * i2] & 0xFF | byArray[n2 + 4 * i2 + 1] << 8 & 0xFF00 | byArray[n2 + 4 * i2 + 2] << 16 & 0xFF0000 | byArray[n2 + 4 * i2 + 3] << 24 & 0xFF000000;
                }
                break;
            }
            case 128: {
                for (int i3 = 0; i3 < 8; ++i3) {
                    nArray[i3] = byArray[n2 + 2 * i3] & 0xFF | byArray[n2 + 2 * i3 + 1] << 8 & 0xFF00;
                }
                break;
            }
            case 64: {
                for (int i4 = 0; i4 < 8; ++i4) {
                    nArray[i4] = byArray[n2 + i4] & 0xFF;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.h + " illegal in key_schedule?");
            }
        }
    }

    protected void blockEncrypt(byte[] in, int in_offset, byte[] out, int out_offset) {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        this.a(in, in_offset, nArray);
        this.a(nArray, nArray2);
        this.a(nArray2, out, out_offset);
    }

    private void a(int[] nArray, byte[] byArray, int n2) {
        switch (this.h) {
            case 256: {
                for (int i2 = 0; i2 < 8; ++i2) {
                    byArray[4 * i2 + n2] = (byte)(nArray[i2] & 0xFF);
                    byArray[4 * i2 + 1 + n2] = (byte)(nArray[i2] >>> 8 & 0xFF);
                    byArray[4 * i2 + 2 + n2] = (byte)(nArray[i2] >>> 16 & 0xFF);
                    byArray[4 * i2 + 3 + n2] = (byte)(nArray[i2] >>> 24 & 0xFF);
                }
                break;
            }
            case 128: {
                for (int i3 = 0; i3 < 8; ++i3) {
                    byArray[2 * i3 + n2] = (byte)(nArray[i3] & 0xFF);
                    byArray[2 * i3 + 1 + n2] = (byte)(nArray[i3] >>> 8 & 0xFF);
                }
                break;
            }
            case 64: {
                for (int i4 = 0; i4 < 8; ++i4) {
                    byArray[i4 + n2] = (byte)(nArray[i4] & 0xFF);
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: data_bits=" + this.h + " illegal in key_schedule?");
            }
        }
    }

    protected void blockDecrypt(byte[] in, int in_offset, byte[] out, int out_offset) {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        this.a(in, in_offset, nArray);
        this.b(nArray, nArray2);
        this.a(nArray2, out, out_offset);
    }

    private void a(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = nArray[0];
        int n8 = nArray[1];
        int n9 = nArray[2];
        int n10 = nArray[3];
        int n11 = nArray[4];
        int n12 = nArray[5];
        int n13 = nArray[6];
        int n14 = nArray[7];
        int n15 = 0;
        int n16 = this.e / 4;
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n13 & n10 ^ n12 & n8 ^ n11 & n9 ^ n8 & n7 ^ n7;
            n4 = ((n5 >>> this.m) + n5 & this.o) >>> this.p;
            n3 = (n14 &= this.n) >>> this.m - 1 | n14 << this.l - (this.m - 1);
            n2 = (n5 &= this.n) >>> n4 | n5 << this.l - n4;
            n5 = n3 + n2 + this.r[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.n;
        }
        if (c && d >= 5) {
            SPEED.d("PASS 1: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n13 & n11 & n7 ^ n11 & n10 & n7 ^ n12 & n9 ^ n11 & n10 ^ n11 & n8 ^ n10 & n7 ^ n8;
            n4 = ((n5 >>> this.m) + n5 & this.o) >>> this.p;
            n3 = (n14 &= this.n) >>> this.m - 1 | n14 << this.l - (this.m - 1);
            n2 = (n5 &= this.n) >>> n4 | n5 << this.l - n4;
            n5 = n3 + n2 + this.r[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.n;
        }
        if (c && d >= 5) {
            SPEED.d("PASS 2: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n12 & n11 & n7 ^ n13 & n11 ^ n12 & n9 ^ n10 & n7 ^ n8 & n7 ^ n10;
            n4 = ((n5 >>> this.m) + n5 & this.o) >>> this.p;
            n3 = (n14 &= this.n) >>> this.m - 1 | n14 << this.l - (this.m - 1);
            n2 = (n5 &= this.n) >>> n4 | n5 << this.l - n4;
            n5 = n3 + n2 + this.r[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.n;
        }
        if (c && d >= 5) {
            SPEED.d("PASS 3: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n13 & n11 & n9 & n7 ^ n13 & n12 ^ n11 & n10 ^ n10 & n9 ^ n8 & n7 ^ n9;
            n4 = ((n5 >>> this.m) + n5 & this.o) >>> this.p;
            n3 = (n14 &= this.n) >>> this.m - 1 | n14 << this.l - (this.m - 1);
            n2 = (n5 &= this.n) >>> n4 | n5 << this.l - n4;
            n5 = n3 + n2 + this.r[n15++];
            n14 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n5 & this.n;
        }
        if (c && d >= 5) {
            SPEED.d("PASS 4: " + Hex.intToString(n14) + " " + Hex.intToString(n13) + " " + Hex.intToString(n12) + " " + Hex.intToString(n11) + " " + Hex.intToString(n10) + " " + Hex.intToString(n9) + " " + Hex.intToString(n8) + " " + Hex.intToString(n7) + " ");
        }
        nArray2[0] = n7;
        nArray2[1] = n8;
        nArray2[2] = n9;
        nArray2[3] = n10;
        nArray2[4] = n11;
        nArray2[5] = n12;
        nArray2[6] = n13;
        nArray2[7] = n14;
    }

    private void b(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = nArray[0] & 0xFFFFFFFF;
        int n8 = nArray[1] & 0xFFFFFFFF;
        int n9 = nArray[2] & 0xFFFFFFFF;
        int n10 = nArray[3] & 0xFFFFFFFF;
        int n11 = nArray[4] & 0xFFFFFFFF;
        int n12 = nArray[5] & 0xFFFFFFFF;
        int n13 = nArray[6] & 0xFFFFFFFF;
        int n14 = nArray[7] & 0xFFFFFFFF;
        int n15 = this.e - 1;
        int n16 = this.e / 4;
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n13 & n11 & n9 & n7 ^ n13 & n12 ^ n11 & n10 ^ n10 & n9 ^ n8 & n7 ^ n9;
            n3 = ((n4 >>> this.m) + n4 & this.o) >>> this.p;
            n2 = (n4 &= this.n) >>> n3 | n4 << this.l - n3;
            n5 -= n2 + this.r[n15--];
            n14 = (n5 &= this.n) << this.m - 1 | n5 >>> this.l - (this.m - 1);
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n12 & n11 & n7 ^ n13 & n11 ^ n12 & n9 ^ n10 & n7 ^ n8 & n7 ^ n10;
            n3 = ((n4 >>> this.m) + n4 & this.o) >>> this.p;
            n2 = (n4 &= this.n) >>> n3 | n4 << this.l - n3;
            n5 -= n2 + this.r[n15--];
            n14 = (n5 &= this.n) << this.m - 1 | n5 >>> this.l - (this.m - 1);
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n13 & n11 & n7 ^ n11 & n10 & n7 ^ n12 & n9 ^ n11 & n10 ^ n11 & n8 ^ n10 & n7 ^ n8;
            n3 = ((n4 >>> this.m) + n4 & this.o) >>> this.p;
            n2 = (n4 &= this.n) >>> n3 | n4 << this.l - n3;
            n5 -= n2 + this.r[n15--];
            n14 = (n5 &= this.n) << this.m - 1 | n5 >>> this.l - (this.m - 1);
        }
        for (n6 = 0; n6 < n16; ++n6) {
            n5 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n13 = n14;
            n4 = n13 & n10 ^ n12 & n8 ^ n11 & n9 ^ n8 & n7 ^ n7;
            n3 = ((n4 >>> this.m) + n4 & this.o) >>> this.p;
            n2 = (n4 &= this.n) >>> n3 | n4 << this.l - n3;
            n5 -= n2 + this.r[n15--];
            n14 = (n5 &= this.n) << this.m - 1 | n5 >>> this.l - (this.m - 1);
        }
        nArray2[0] = n7;
        nArray2[1] = n8;
        nArray2[2] = n9;
        nArray2[3] = n10;
        nArray2[4] = n11;
        nArray2[5] = n12;
        nArray2[6] = n13;
        nArray2[7] = n14;
    }

    public static final void main(String[] argv) {
        try {
            SPEED.self_test(new PrintWriter(System.err), argv);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter out, String[] argv) throws Exception {
        out.println("Note: hex strings are printed in conventional order, not the order");
        out.println("      in the SPEED paper.");
        out.println();
        SPEED.a(out, 64, "0000000000000000", "0000000000000000", "2E008019BC26856D");
        SPEED.a(out, 128, "00000000000000000000000000000000", "00000000000000000000000000000000", "A44FBF29EDF6CBF8D7A2DFD57163B909");
        SPEED.a(out, 128, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "6C13E4B9C3171571AB54D816915BC4E8");
        SPEED.a(out, 48, "504F4E4D4C4B4A494847464544434241", "1F1E1D1C1B1A191817161514131211100F0E0D0C0B0A09080706050403020100", "90C5981EF6A3D21BC178CACDAD6BF39B2E51CDB70A6EE875A73BF5ED883E3692");
        SPEED.a(out, 256, "0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000", "6CD44D2B49BC6AA7E95FD1C4AF713A2C0AFA1701308D56298CDF27A02EB09BF5");
        SPEED.a(out, 256, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "C8F3E864263FAF24222E38227BEBC022CF4A9A0ECE89FB81CA1B9BA3BA93D0C5");
        SPEED.a(out, 256, "605F5E5D5C5B5A595857565554535251504F4E4D4C4B4A494847464544434241", "1F1E1D1C1B1A191817161514131211100F0E0D0C0B0A09080706050403020100", "3DE16CFA9A626847434E1574693FEC1B3FAA558A296B61D708B131CCBA311068");
    }

    private static void a(PrintWriter printWriter, int n2, String string, String string2, String string3) throws Exception {
        byte[] byArray = Hex.fromReversedString(string);
        byte[] byArray2 = Hex.fromReversedString(string2);
        byte[] byArray3 = Hex.fromReversedString(string3);
        SPEED sPEED = new SPEED();
        sPEED.setBlockSize(byArray2.length);
        sPEED.setRounds(n2);
        RawSecretKey rawSecretKey = new RawSecretKey("SPEED", byArray);
        sPEED.initEncrypt(rawSecretKey);
        byte[] byArray4 = sPEED.crypt(byArray2);
        printWriter.println("    key:" + Hex.toString(byArray));
        printWriter.println("  plain:" + Hex.toString(byArray2));
        String string4 = Hex.toString(byArray4);
        printWriter.println("    enc:" + string4);
        String string5 = Hex.toString(byArray3);
        if (string4.equals(string5)) {
            printWriter.print("encryption good; ");
        } else {
            printWriter.println("   calc:" + string5);
            printWriter.println(" ********* SPEED ENCRYPTION FAILED ********* ");
            sPEED.a();
        }
        sPEED.initDecrypt(rawSecretKey);
        byte[] byArray5 = sPEED.crypt(byArray4);
        string4 = Hex.toString(byArray5);
        string5 = Hex.toString(byArray2);
        if (string4.equals(string5)) {
            printWriter.println("decryption good");
        } else {
            printWriter.println();
            printWriter.println("    enc:" + Hex.toString(byArray4));
            printWriter.println("    dec:" + string4);
            printWriter.println("   calc:" + string5);
            printWriter.println(" ********* SPEED DECRYPTION FAILED ********* ");
            sPEED.a();
        }
    }
}

