/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.asn1.lang;

import com.enterprisedt.cryptix.util.core.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class Tag {
    private static final boolean e = Debug.GLOBAL_DEBUG;
    private static final int f = e ? Debug.getLevel("Tag") : 0;
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int PRIVATE = 192;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int SEQUENCE = 16;
    public static final int SEQUENCE_OF = 48;
    public static final int SET = 17;
    public static final int SET_OF = 49;
    public static final int UTF8_STRING = 12;
    public static final int PRINT_STRING = 19;
    public static final int T61_STRING = 20;
    public static final int IA5_STRING = 22;
    public static final int UTC_TIME = 23;
    public static final int GENERALIZED_TIME = 24;
    public static final int UNICODE_STRING = 30;
    int a;
    int b;
    boolean c;
    boolean d;

    Tag(int clazz, int value, boolean explicit, boolean constructed) {
        this.a = clazz;
        this.b = value;
        this.c = explicit;
        this.d = constructed;
    }

    Tag(int clazz, int value, boolean explicit) {
        this(clazz, value, explicit, false);
    }

    Tag(int value, boolean explicit) {
        this(0, value, explicit);
    }

    public int getClazz() {
        return this.a;
    }

    public int getValue() {
        return this.b;
    }

    public boolean isExplicit() {
        return this.c;
    }

    public boolean isConstructed() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tag getExpectedTag(int expectedClass, int expectedValue, InputStream in) throws IOException {
        int n2;
        int n3;
        ByteArrayOutputStream byteArrayOutputStream;
        Tag tag;
        block31: {
            Tag tag2;
            block30: {
                Tag tag3;
                block29: {
                    tag = null;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    n3 = -1;
                    n2 = -1;
                    try {
                        int n4;
                        if (in.markSupported()) {
                            in.mark(2048);
                        }
                        if ((n4 = in.read()) < 0) {
                            tag3 = null;
                            Object var11_10 = null;
                            break block29;
                        }
                        byteArrayOutputStream.write(n4 &= 0xFF);
                        n3 = n4 & 0xC0;
                        boolean bl = (n4 & 0x20) != 0;
                        n2 = n4 & 0x1F;
                        if (n2 == 31) {
                            n2 = 0;
                            n4 = in.read();
                            if (n4 < 0) {
                                tag2 = null;
                                break block30;
                            }
                            n4 &= 0xFF;
                            do {
                                n2 += n4 & 0x80;
                                n4 = in.read();
                                if (n4 < 0) {
                                    Tag tag4 = null;
                                    Object var11_12 = null;
                                    if (!Tag.a(n3, expectedClass, n2, expectedValue)) {
                                        tag = null;
                                        if (e && f > 6) {
                                            Debug.log("Tag - Recovering...");
                                        }
                                        byte[] byArray = byteArrayOutputStream.toByteArray();
                                        if (in.markSupported()) {
                                            in.reset();
                                        } else {
                                            if (!(in instanceof PushbackInputStream)) throw new IOException("Could not recover.");
                                            PushbackInputStream pushbackInputStream = (PushbackInputStream)in;
                                            pushbackInputStream.unread(byArray);
                                        }
                                    }
                                    byteArrayOutputStream = null;
                                    return tag4;
                                }
                                byteArrayOutputStream.write(n4 &= 0xFF);
                            } while ((n4 & 0x80) != 0);
                        }
                        tag = new Tag(n3, n2, true, bl);
                        if (e && f > 6) {
                            Debug.log("Tag - Checking for Tag's class=\"" + expectedClass + "\", value \"" + expectedValue + "\"; found: " + tag);
                        }
                        break block31;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        if (!Tag.a(n3, expectedClass, n2, expectedValue)) {
                            tag = null;
                            if (e && f > 6) {
                                Debug.log("Tag - Recovering...");
                            }
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            if (in.markSupported()) {
                                in.reset();
                            } else {
                                if (!(in instanceof PushbackInputStream)) throw new IOException("Could not recover.");
                                PushbackInputStream pushbackInputStream = (PushbackInputStream)in;
                                pushbackInputStream.unread(byArray);
                            }
                        }
                        byteArrayOutputStream = null;
                        throw throwable;
                    }
                }
                if (!Tag.a(n3, expectedClass, n2, expectedValue)) {
                    tag = null;
                    if (e && f > 6) {
                        Debug.log("Tag - Recovering...");
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    if (in.markSupported()) {
                        in.reset();
                    } else {
                        if (!(in instanceof PushbackInputStream)) throw new IOException("Could not recover.");
                        PushbackInputStream pushbackInputStream = (PushbackInputStream)in;
                        pushbackInputStream.unread(byArray);
                    }
                }
                byteArrayOutputStream = null;
                return tag3;
            }
            Object var11_11 = null;
            if (!Tag.a(n3, expectedClass, n2, expectedValue)) {
                tag = null;
                if (e && f > 6) {
                    Debug.log("Tag - Recovering...");
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (in.markSupported()) {
                    in.reset();
                } else {
                    if (!(in instanceof PushbackInputStream)) throw new IOException("Could not recover.");
                    PushbackInputStream pushbackInputStream = (PushbackInputStream)in;
                    pushbackInputStream.unread(byArray);
                }
            }
            byteArrayOutputStream = null;
            return tag2;
        }
        Object var11_13 = null;
        if (!Tag.a(n3, expectedClass, n2, expectedValue)) {
            tag = null;
            if (e && f > 6) {
                Debug.log("Tag - Recovering...");
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (in.markSupported()) {
                in.reset();
            } else {
                if (!(in instanceof PushbackInputStream)) throw new IOException("Could not recover.");
                PushbackInputStream pushbackInputStream = (PushbackInputStream)in;
                pushbackInputStream.unread(byArray);
            }
        }
        byteArrayOutputStream = null;
        return tag;
    }

    public static Tag getExpectedTag(int expectedValue, InputStream in) throws IOException {
        return Tag.getExpectedTag(0, expectedValue, in);
    }

    public static Tag getExpectedTag(Tag tag, InputStream in) throws IOException {
        return Tag.getExpectedTag(tag.getClazz(), tag.getValue(), in);
    }

    public static byte[] getTag(InputStream in) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = in.read();
        if (n2 == -1) {
            return null;
        }
        byteArrayOutputStream.write(n2 &= 0xFF);
        if ((n2 & 0x1F) == 31) {
            do {
                n2 = in.read() & 0xFF;
                byteArrayOutputStream.write(n2);
            } while ((n2 & 0x80) != 0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Tag decode(InputStream in) throws IOException {
        int n2 = in.read() & 0xFF;
        int n3 = n2 & 0xC0;
        boolean bl = (n2 & 0x20) != 0;
        int n4 = n2 & 0x1F;
        if (n4 == 31) {
            n4 = 0;
            n2 = in.read() & 0xFF;
            do {
                n4 += n2 & 0x80;
            } while (((n2 = in.read() & 0xFF) & 0x80) != 0);
        }
        Tag tag = new Tag(n3, n4, true, bl);
        if (e && f > 6) {
            Debug.log("Tag - Decoded " + tag);
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag peek(InputStream in) throws IOException {
        in.mark(Integer.MAX_VALUE);
        Tag tag = null;
        try {
            tag = Tag.decode(in);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            in.reset();
            throw throwable;
        }
        in.reset();
        return tag;
    }

    private static boolean a(int n2, int n3, int n4, int n5) {
        if (n2 != n3) {
            return false;
        }
        if (n2 != 0) {
            return n4 == n5;
        }
        if (n5 == 19 || n5 == 22 || n4 == 20) {
            return n4 == 19 || n4 == 22 || n4 == 20;
        }
        return n4 == n5;
    }

    public String toString() {
        String string = "<Tag class=\"";
        switch (this.a) {
            case 0: {
                string = string + "UNIVERSAL (0)";
                break;
            }
            case 64: {
                string = string + "APPLICATION (64)";
                break;
            }
            case 128: {
                string = string + "CONTEXT (128)";
                break;
            }
            case 192: {
                string = string + "PRIVATE (192)";
                break;
            }
            default: {
                string = string + "" + this.a;
            }
        }
        string = string + "\" value=\"";
        if (this.a == 128) {
            string = string + "" + this.b;
        } else {
            switch (this.b) {
                case 1: {
                    string = string + "BOOLEAN (1)";
                    break;
                }
                case 2: {
                    string = string + "INTEGER (2)";
                    break;
                }
                case 3: {
                    string = string + "BIT STRING (3)";
                    break;
                }
                case 4: {
                    string = string + "OCTET STRING (4)";
                    break;
                }
                case 5: {
                    string = string + "NULL (5)";
                    break;
                }
                case 6: {
                    string = string + "OBJECT_IDENTIFIER (6)";
                    break;
                }
                case 16: {
                    string = string + "SEQUENCE (16)";
                    break;
                }
                case 17: {
                    string = string + "SET (17)";
                    break;
                }
                case 19: {
                    string = string + "PrintableString (19)";
                    break;
                }
                case 20: {
                    string = string + "T61String (20)";
                    break;
                }
                case 22: {
                    string = string + "IA5String (22)";
                    break;
                }
                case 23: {
                    string = string + "UTCTime (23)";
                    break;
                }
                default: {
                    string = string + "" + this.b;
                }
            }
        }
        string = string + "\" explicit=\"" + (this.c ? "yes" : "no");
        string = string + "\" constructed=\"" + (this.d ? "yes" : "no") + "\" />";
        return string;
    }
}

