/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.asn1.encoding;

import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNAny;
import com.enterprisedt.cryptix.asn1.lang.ASNBitString;
import com.enterprisedt.cryptix.asn1.lang.ASNBoolean;
import com.enterprisedt.cryptix.asn1.lang.ASNInteger;
import com.enterprisedt.cryptix.asn1.lang.ASNNull;
import com.enterprisedt.cryptix.asn1.lang.ASNObjectIdentifier;
import com.enterprisedt.cryptix.asn1.lang.ASNOctetString;
import com.enterprisedt.cryptix.asn1.lang.ASNPrintableString;
import com.enterprisedt.cryptix.asn1.lang.ASNSequence;
import com.enterprisedt.cryptix.asn1.lang.ASNSequenceOf;
import com.enterprisedt.cryptix.asn1.lang.ASNSet;
import com.enterprisedt.cryptix.asn1.lang.ASNSetOf;
import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.cryptix.asn1.lang.ASNTaggedType;
import com.enterprisedt.cryptix.asn1.lang.ASNTime;
import com.enterprisedt.cryptix.asn1.lang.ASNType;
import com.enterprisedt.cryptix.asn1.lang.ASNTypeAlias;
import com.enterprisedt.cryptix.asn1.lang.Parser;
import com.enterprisedt.cryptix.asn1.lang.SimpleNode;
import com.enterprisedt.cryptix.util.core.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BaseCoder
implements CoderOperations {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("BaseCoder") : 0;
    protected InputStream in;
    protected OutputStream out;
    private int c = 0;

    public static CoderOperations getInstance(String anEncoding) {
        Object object;
        int n2 = anEncoding.lastIndexOf(46);
        if (n2 == -1) {
            object = "com.enterprisedt.cryptix.asn1.encoding";
            anEncoding = (String)object + "." + anEncoding;
        }
        object = null;
        try {
            object = (CoderOperations)Class.forName(anEncoding).newInstance();
        }
        catch (Throwable throwable) {
            Debug.log("DER - Unable to instantiate " + anEncoding + " coder");
            Debug.log("DER - " + throwable.toString());
            Debug.log("DER - " + throwable.getMessage());
        }
        return object;
    }

    public int getState() {
        return this.c;
    }

    public Object visit(SimpleNode x2, Object data) throws IOException {
        String string = "Don't know how to visit " + x2;
        if (a && b > 8) {
            Debug.log("BaseCoder - " + string);
        }
        throw new RuntimeException(string);
    }

    public Object visit(ASNSpecification node, Object data) throws IOException {
        return node.childrenAccept(this, data);
    }

    public Object visit(ASNTypeAlias node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNType node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNBoolean node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNInteger node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNBitString node, Object data) throws IOException {
        return node.childrenAccept(this, data);
    }

    public Object visit(ASNOctetString node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNNull node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNObjectIdentifier node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNSequence node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNSequenceOf node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNSet node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNSetOf node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNTaggedType node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNAny node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNPrintableString node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    public Object visit(ASNTime node, Object data) throws IOException {
        return this.visitInternal(node, data);
    }

    protected Object visitInternal(SimpleNode node, Object data) throws IOException {
        if (this.c == 2) {
            switch (node.getID()) {
                case 2: {
                    this.encode((ASNType)node, this.out);
                    break;
                }
                case 3: {
                    this.encode((ASNTypeAlias)node, this.out);
                    break;
                }
                case 4: {
                    this.encode((ASNBoolean)node, this.out);
                    break;
                }
                case 5: {
                    this.encode((ASNInteger)node, this.out);
                    break;
                }
                case 6: {
                    this.encode((ASNBitString)node, this.out);
                    break;
                }
                case 7: {
                    this.encode((ASNOctetString)node, this.out);
                    break;
                }
                case 8: {
                    this.encode((ASNNull)node, this.out);
                    break;
                }
                case 9: {
                    this.encode((ASNObjectIdentifier)node, this.out);
                    break;
                }
                case 10: {
                    this.encode((ASNSequence)node, this.out);
                    break;
                }
                case 11: {
                    this.encode((ASNSequenceOf)node, this.out);
                    break;
                }
                case 12: {
                    this.encode((ASNSet)node, this.out);
                    break;
                }
                case 13: {
                    this.encode((ASNSetOf)node, this.out);
                    break;
                }
                case 14: {
                    this.encode((ASNTaggedType)node, this.out);
                    break;
                }
                case 15: {
                    this.encode((ASNAny)node, this.out);
                    break;
                }
                case 16: {
                    this.encode((ASNPrintableString)node, this.out);
                    break;
                }
                case 17: {
                    this.encode((ASNTime)node, this.out);
                    break;
                }
                default: {
                    String string = "Don't know how to encode " + node;
                    if (a && b > 8) {
                        Debug.log("BaseCoder - " + string);
                    }
                    throw new RuntimeException(string);
                }
            }
        } else if (this.c == 1) {
            switch (node.getID()) {
                case 2: {
                    this.decode((ASNType)node, this.in);
                    break;
                }
                case 3: {
                    this.decode((ASNTypeAlias)node, this.in);
                    break;
                }
                case 4: {
                    this.decode((ASNBoolean)node, this.in);
                    break;
                }
                case 5: {
                    this.decode((ASNInteger)node, this.in);
                    break;
                }
                case 6: {
                    this.decode((ASNBitString)node, this.in);
                    break;
                }
                case 7: {
                    this.decode((ASNOctetString)node, this.in);
                    break;
                }
                case 8: {
                    this.decode((ASNNull)node, this.in);
                    break;
                }
                case 9: {
                    this.decode((ASNObjectIdentifier)node, this.in);
                    break;
                }
                case 10: {
                    this.decode((ASNSequence)node, this.in);
                    break;
                }
                case 11: {
                    this.decode((ASNSequenceOf)node, this.in);
                    break;
                }
                case 12: {
                    this.decode((ASNSet)node, this.in);
                    break;
                }
                case 13: {
                    this.decode((ASNSetOf)node, this.in);
                    break;
                }
                case 14: {
                    this.decode((ASNTaggedType)node, this.in);
                    break;
                }
                case 15: {
                    this.decode((ASNAny)node, this.in);
                    break;
                }
                case 16: {
                    this.decode((ASNPrintableString)node, this.in);
                    break;
                }
                case 17: {
                    this.decode((ASNTime)node, this.in);
                    break;
                }
                default: {
                    String string = "Don't know how to decode " + node;
                    if (a && b > 8) {
                        Debug.log("BaseCoder - " + string);
                    }
                    throw new RuntimeException(string);
                }
            }
        } else {
            throw new IllegalStateException();
        }
        return node.getValue();
    }

    public void init(OutputStream os) {
        this.out = os;
        this.c = 2;
    }

    public void init(InputStream is) {
        this.in = is;
        this.c = 1;
    }

    public void encode(ASNType obj, OutputStream out) throws IOException {
    }

    public void encode(ASNTypeAlias obj, OutputStream out) throws IOException {
    }

    public void encode(ASNBoolean obj, OutputStream out) throws IOException {
    }

    public void encode(ASNInteger obj, OutputStream out) throws IOException {
    }

    public void encode(ASNBitString obj, OutputStream out) throws IOException {
    }

    public void encode(ASNOctetString obj, OutputStream out) throws IOException {
    }

    public void encode(ASNNull obj, OutputStream out) throws IOException {
    }

    public void encode(ASNObjectIdentifier obj, OutputStream out) throws IOException {
    }

    public void encode(ASNSequence obj, OutputStream out) throws IOException {
    }

    public void encode(ASNSequenceOf obj, OutputStream out) throws IOException {
    }

    public void encode(ASNSet obj, OutputStream out) throws IOException {
    }

    public void encode(ASNSetOf obj, OutputStream out) throws IOException {
    }

    public void encode(ASNTaggedType obj, OutputStream out) throws IOException {
    }

    public void encode(ASNAny obj, OutputStream out) throws IOException {
    }

    public void encode(ASNPrintableString obj, OutputStream out) throws IOException {
    }

    public void encode(ASNTime obj, OutputStream out) throws IOException {
    }

    public void decode(ASNBoolean obj, InputStream in) throws IOException {
    }

    public void decode(ASNInteger obj, InputStream in) throws IOException {
    }

    public void decode(ASNBitString obj, InputStream in) throws IOException {
    }

    public void decode(ASNOctetString obj, InputStream in) throws IOException {
    }

    public void decode(ASNNull obj, InputStream in) throws IOException {
    }

    public void decode(ASNObjectIdentifier obj, InputStream in) throws IOException {
    }

    public void decode(ASNSequence obj, InputStream in) throws IOException {
    }

    public void decode(ASNSequenceOf obj, InputStream in) throws IOException {
    }

    public void decode(ASNSet obj, InputStream in) throws IOException {
    }

    public void decode(ASNSetOf obj, InputStream in) throws IOException {
    }

    public void decode(ASNTaggedType obj, InputStream in) throws IOException {
    }

    public void decode(ASNAny obj, InputStream in) throws IOException {
    }

    public void decode(ASNPrintableString obj, InputStream in) throws IOException {
    }

    public void decode(ASNTime obj, InputStream in) throws IOException {
    }

    public void decode(ASNType obj, InputStream in) throws IOException {
        boolean bl = obj.isOptional();
        String string = obj.getName();
        SimpleNode simpleNode = string != null ? (SimpleNode)Parser.resolve(string) : (SimpleNode)obj.getChild(0);
        simpleNode.setOptional(bl);
        Object object = this.visitInternal(simpleNode, null);
        obj.setValue(object);
    }

    public void decode(ASNTypeAlias obj, InputStream in) throws IOException {
        SimpleNode simpleNode = (SimpleNode)Parser.resolve(obj.getName());
        Object object = this.visitInternal(simpleNode, null);
        obj.setValue(object);
    }
}

