/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;

public class NonExistingFileEditorInput
implements IEditorInput,
ILocationProvider {
    private static int fgNonExisting = 0;
    private IFileStore fFileStore;
    private String fName;
    static /* synthetic */ Class class$0;

    public NonExistingFileEditorInput(IFileStore fileStore, String namePrefix) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        this.fName = String.valueOf(namePrefix) + " " + ++fgNonExisting;
    }

    public NonExistingFileEditorInput(IFileStore fileStore, String namePrefix, List editorNames) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        if (namePrefix != null && namePrefix.indexOf(" ") > 0) {
            this.fName = namePrefix;
        } else {
            int num = 1;
            this.fName = String.valueOf(namePrefix) + " " + num++;
            int i = 0;
            while (i < editorNames.size()) {
                if (!editorNames.contains(this.fName)) break;
                this.fName = String.valueOf(namePrefix) + " " + num++;
                ++i;
            }
        }
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fName;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput input = (NonExistingFileEditorInput)element;
            return new Path(input.fFileStore.toURI().getPath());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput input = (NonExistingFileEditorInput)o;
            return this.fFileStore.equals(input.fFileStore);
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }
}

