/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.downloader;

import com.aptana.core.epl.downloader.FileReader;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.downloader.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.osgi.util.NLS;

public class ContentDownloadRequest {
    private URL url;
    private File saveTo;
    private IStatus result;

    public ContentDownloadRequest(URL url) throws CoreException {
        this(url, ContentDownloadRequest.getTempFile(url));
    }

    public ContentDownloadRequest(URL url, File saveTo) {
        this.url = url;
        this.saveTo = saveTo;
    }

    public IStatus getResult() {
        return this.result;
    }

    public String getDownloadLocation() {
        if (this.saveTo == null) {
            return null;
        }
        return this.saveTo.getAbsolutePath();
    }

    protected void setResult(IStatus result) {
        this.result = result;
    }

    public void execute(IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.ContentDownloadRequest_downloading, (Object)this.url.toString()));
        IStatus status = this.download(monitor);
        this.setResult(status);
    }

    private IStatus download(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            IdeLog.logInfo((Plugin)CoreIOPlugin.getDefault(), (String)MessageFormat.format("Downloading {0} to {1}", this.url.toURI(), this.saveTo.getCanonicalPath()), (String)"com.aptana.core.io/debug/download");
            FileReader reader = new FileReader(null);
            FileOutputStream anOutputStream = new FileOutputStream(this.saveTo);
            reader.readInto(this.url.toURI(), (OutputStream)anOutputStream, 0L, monitor);
            IStatus result = reader.getResult();
            if (result != null) {
                if (result.getSeverity() == 8) {
                    throw new UserCancelledException();
                }
                if (!result.isOK()) {
                    throw new CoreException(result);
                }
            }
            IdeLog.logInfo((Plugin)CoreIOPlugin.getDefault(), (String)MessageFormat.format("File {0} downloaded sucessfully", this.url.toURI()), (String)"com.aptana.core.io/debug/download");
        }
        catch (Throwable t) {
            return new Status(4, "com.aptana.core.io", t.getMessage(), t);
        }
        return status;
    }

    protected static File getTempFile(URL url) throws CoreException {
        String tempPath = FileUtil.getTempDirectory().toOSString();
        try {
            IPath path = Path.fromOSString((String)url.toURI().getPath());
            String name = path.lastSegment();
            if (name != null && name.length() > 0) {
                File f = new File(tempPath, name);
                f.deleteOnExit();
                return f;
            }
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
        try {
            return File.createTempFile(Messages.ContentDownloadRequest_tempFilePrefix, null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", "Could not create a local temporary file for the downloaded content", (Throwable)e));
        }
    }
}

