/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.Messages;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class LockUtils {
    public static IStatus waitForLockRelease(String fileName, long timeToWait) {
        FileLock fileLock;
        RandomAccessFile randomAccessFile;
        block21: {
            Status status;
            block22: {
                randomAccessFile = null;
                int retries = (int)(timeToWait / 500L) + 1;
                Exception lastException = null;
                boolean isLocked = true;
                fileLock = null;
                randomAccessFile = new RandomAccessFile(fileName, "rw");
                FileChannel channel = randomAccessFile.getChannel();
                while (isLocked) {
                    try {
                        fileLock = channel.tryLock(0L, Long.MAX_VALUE, true);
                        lastException = null;
                    }
                    catch (Exception e) {
                        lastException = e;
                    }
                    if (lastException != null || fileLock == null) {
                        if (--retries == 0) break;
                        Thread.sleep(500L);
                        continue;
                    }
                    isLocked = false;
                }
                if (lastException == null && fileLock != null) break block21;
                IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (String)MessageFormat.format("Failed to lock {0}", fileName), (Throwable)lastException);
                status = new Status(4, "com.aptana.core.io", String.valueOf(Messages.LockUtils_failedToLock) + fileName + Messages.LockUtils_seeErrorLog, (Throwable)lastException);
                if (randomAccessFile == null) break block22;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            return status;
        }
        try {
            try {
                if (fileLock != null) {
                    fileLock.release();
                    randomAccessFile.close();
                    fileLock = null;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "com.aptana.core.io", e.getMessage(), (Throwable)e);
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return status;
            }
        }
        catch (Throwable throwable) {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
        return Status.OK_STATUS;
    }

    public static IStatus waitForFolderAccess(String dir, long timeToWait) {
        int retries = (int)(timeToWait / 500L) + 1;
        Exception lastException = null;
        boolean isLocked = true;
        File tempFile = new File(dir, ".tmp");
        while (isLocked) {
            try {
                isLocked = !tempFile.createNewFile();
                lastException = null;
            }
            catch (Exception e) {
                lastException = e;
            }
            if (!isLocked) continue;
            if (--retries == 0) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (isLocked) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (String)MessageFormat.format("Failed to write to {0}", dir), (Throwable)lastException);
            return new Status(4, "com.aptana.core.io", String.valueOf(Messages.LockUtils_failedToWrite) + dir + Messages.LockUtils_seeErrorLog, (Throwable)lastException);
        }
        if (tempFile != null) {
            tempFile.delete();
        }
        return Status.OK_STATUS;
    }
}

