/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.core.epl.IMemento;
import com.aptana.core.epl.XMLMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.ConnectionPointCategory;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointCategory;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.core.io.Messages;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

final class ConnectionPointManager
extends PlatformObject
implements IConnectionPointManager {
    static final String STATE_FILENAME = "connections";
    private static final String EXTENSION_POINT_ID = "connectionPoint";
    private static final String TAG_CONNECTION_POINT_TYPE = "connectionPointType";
    private static final String TAG_CONNECTION_POINT_CATEGORY = "connectionPointCategory";
    private static final String DEFAULT_CATEGORY_ID = "unknown";
    static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ORDER = "order";
    private static final String ATT_REMOTE = "remote";
    private static final String ATT_CLASS = "class";
    private static final String ATT_CATEGORY = "category";
    private static final String ELEMENT_ROOT = "connections";
    private static final String ELEMENT_CONNECTION = "connection";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TYPE = "type";
    private static final String COM_APTANA_IDE_IO_FTPS_FTPS_VIRTUAL_FILE_MANAGER = "com.aptana.ide.io.ftps.FtpsVirtualFileManager";
    private static final String COM_APTANA_IDE_IO_SFTP_SFTP_VIRTUAL_FILE_MANAGER = "com.aptana.ide.io.sftp.SftpVirtualFileManager";
    private static final String COM_APTANA_IDE_IO_FTP_FTP_VIRTUAL_FILE_MANAGER = "com.aptana.ide.io.ftp.FtpVirtualFileManager";
    private static final String COM_APTANA_IDE_CORE_UI_IO_FILE_PROJECT_FILE_MANAGER = "com.aptana.ide.core.ui.io.file.ProjectFileManager";
    private static final String COM_APTANA_IDE_CORE_UI_IO_FILE_LOCAL_FILE_MANAGER = "com.aptana.ide.core.ui.io.file.LocalFileManager";
    private static final String TYPE_FTPS = "ftps";
    private static final String TYPE_SFTP = "sftp";
    private static final String TYPE_FTP = "ftp";
    private static final String TYPE_WORKSPACE = "workspace";
    private static final String TYPE_LOCAL = "local";
    private static ConnectionPointManager instance;
    private List<ConnectionPoint> connections = Collections.synchronizedList(new ArrayList());
    private Map<String, ConnectionPointCategory> categories = new HashMap<String, ConnectionPointCategory>();
    private List<ConnectionPointType> types = new ArrayList<ConnectionPointType>();
    private Map<String, IConfigurationElement> configurationElements = new HashMap<String, IConfigurationElement>();
    private List<IMemento> unresolvedConnections = Collections.synchronizedList(new ArrayList());
    private boolean dirty = false;
    private ListenerList listeners = new ListenerList();

    private ConnectionPointManager() {
        this.readExtensionRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionPointManager getInstance() {
        if (instance != null) return instance;
        Class<ConnectionPointManager> clazz = ConnectionPointManager.class;
        synchronized (ConnectionPointManager.class) {
            if (instance != null) return instance;
            instance = new ConnectionPointManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    void loadState(IPath path) {
        File file = path.toFile();
        if (file.exists()) {
            this.connections.clear();
            this.unresolvedConnections.clear();
            this.addConnectionsFrom(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveState(IPath path) {
        block20: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"connections");
            List<ConnectionPoint> list = this.connections;
            synchronized (list) {
                for (ConnectionPoint connectionPoint : this.connections) {
                    if (!connectionPoint.isPersistent()) continue;
                    IMemento child = memento.createChild(ELEMENT_CONNECTION);
                    child.putMemento(this.storeConnectionPoint(connectionPoint));
                }
            }
            list = this.unresolvedConnections;
            synchronized (list) {
                for (IMemento child : this.unresolvedConnections) {
                    memento.copyChild(child);
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                    this.isChanged();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
                    if (writer == null) break block20;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public List<IConnectionPoint> addConnectionsFrom(IPath path) {
        List<IConnectionPoint> newConnections = this.readConnectionsFrom(path);
        for (IConnectionPoint point : newConnections) {
            this.connections.add((ConnectionPoint)point);
        }
        return newConnections;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<IConnectionPoint> readConnectionsFrom(IPath path) {
        ArrayList<IConnectionPoint> newConnections = new ArrayList<IConnectionPoint>();
        File file = path.toFile();
        if (!file.exists()) return newConnections;
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(file);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] iMementoArray = memento.getChildren(ELEMENT_CONNECTION);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    ConnectionPoint connectionPoint = this.restoreConnectionPoint(child, null);
                    if (connectionPoint != null) {
                        newConnections.add(connectionPoint);
                    } else {
                        this.unresolvedConnections.add(child);
                    }
                    ++n2;
                }
                return newConnections;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
                if (reader == null) return newConnections;
                try {
                    reader.close();
                    return newConnections;
                }
                catch (IOException e2) {
                    IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e2);
                }
                return newConnections;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
                if (reader == null) return newConnections;
                try {
                    reader.close();
                    return newConnections;
                }
                catch (IOException e3) {
                    IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e3);
                }
                return newConnections;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
                }
            }
        }
    }

    public boolean isChanged() {
        for (ConnectionPoint connectionPoint : this.connections) {
            if (!connectionPoint.isChanged()) continue;
            this.dirty = true;
        }
        try {
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
        }
    }

    private void broadcastEvent(ConnectionPointEvent event) {
        Object[] list;
        Object[] objectArray = list = this.listeners.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IConnectionPointListener)listener).connectionPointChanged(event);
            ++n2;
        }
    }

    IConnectionPoint[] getConnectionPointsForType(String type) {
        ArrayList<ConnectionPoint> list = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint connectionPoint : this.connections) {
            if (!type.equals(connectionPoint.getType())) continue;
            list.add(connectionPoint);
        }
        return list.toArray(new IConnectionPoint[list.size()]);
    }

    @Override
    public void addConnectionPoint(IConnectionPoint connectionPoint) {
        Assert.isLegal((boolean)(connectionPoint instanceof ConnectionPoint));
        if (!this.connections.contains(connectionPoint)) {
            this.connections.add((ConnectionPoint)connectionPoint);
            this.dirty = true;
            this.broadcastEvent(new ConnectionPointEvent(this, 1, connectionPoint));
        }
    }

    @Override
    public void removeConnectionPoint(IConnectionPoint connectionPoint) {
        if (this.connections.contains(connectionPoint)) {
            this.connections.remove(connectionPoint);
            this.dirty = true;
            this.broadcastEvent(new ConnectionPointEvent(this, 2, connectionPoint));
        }
    }

    @Override
    public void connectionPointChanged(IConnectionPoint connectionPoint) {
        if (this.connections.contains(connectionPoint)) {
            this.dirty = true;
            this.broadcastEvent(new ConnectionPointEvent(this, 4, connectionPoint));
        }
    }

    @Override
    public IConnectionPoint cloneConnectionPoint(IConnectionPoint connectionPoint) throws CoreException {
        IMemento memento;
        Assert.isLegal((boolean)(connectionPoint instanceof ConnectionPoint));
        try {
            memento = this.storeConnectionPoint((ConnectionPoint)connectionPoint);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.io", Messages.ConnectionPointManager_FailedStoreConnectionProperties, (Throwable)e));
        }
        ConnectionPoint clonedConnectionPoint = this.restoreConnectionPoint(memento, UUID.randomUUID().toString());
        return clonedConnectionPoint;
    }

    @Override
    public ConnectionPointType[] getTypes() {
        return this.types.toArray(new ConnectionPointType[this.types.size()]);
    }

    @Override
    public ConnectionPointType getType(String typeId) {
        for (ConnectionPointType type : this.types) {
            if (!type.getType().equals(typeId)) continue;
            return type;
        }
        return null;
    }

    @Override
    public ConnectionPointType getType(IConnectionPoint connectionPoint) {
        Assert.isLegal((boolean)(connectionPoint instanceof ConnectionPoint));
        return this.getType(((ConnectionPoint)connectionPoint).getType());
    }

    @Override
    public IConnectionPointCategory[] getConnectionPointCategories() {
        return this.categories.values().toArray(new IConnectionPointCategory[this.categories.size()]);
    }

    @Override
    public IConnectionPointCategory getConnectionPointCategory(String categoryId) {
        return this.categories.get(categoryId);
    }

    @Override
    public IConnectionPoint[] getConnectionPoints() {
        return this.connections.toArray(new IConnectionPoint[this.connections.size()]);
    }

    private IMemento storeConnectionPoint(ConnectionPoint connectionPoint) {
        IMemento saveMemento = XMLMemento.createWriteRoot((String)"connections").createChild(ELEMENT_CONNECTION);
        connectionPoint.saveState(saveMemento);
        saveMemento.putString("id", connectionPoint.getId());
        saveMemento.putString(ATTR_TYPE, connectionPoint.getType());
        return saveMemento;
    }

    private ConnectionPoint restoreConnectionPoint(IMemento memento, String id) throws CoreException {
        Object object;
        IConfigurationElement element;
        ConnectionPoint connectionPoint = null;
        String typeId = memento.getString(ATTR_TYPE);
        if (typeId != null && (element = this.configurationElements.get(typeId)) != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof ConnectionPoint) {
            connectionPoint = (ConnectionPoint)object;
            connectionPoint.setId(id != null ? id : memento.getString("id"));
            connectionPoint.loadState(memento);
        }
        return connectionPoint;
    }

    @Override
    public ConnectionPoint restore15ConnectionPoint(String type, String data) throws CoreException {
        Object object;
        IConfigurationElement element;
        ConnectionPoint connectionPoint = null;
        String typeId = null;
        if (type.equals(COM_APTANA_IDE_CORE_UI_IO_FILE_LOCAL_FILE_MANAGER)) {
            typeId = TYPE_LOCAL;
        } else if (type.equals(COM_APTANA_IDE_CORE_UI_IO_FILE_PROJECT_FILE_MANAGER)) {
            typeId = TYPE_WORKSPACE;
        } else if (type.equals(COM_APTANA_IDE_IO_FTP_FTP_VIRTUAL_FILE_MANAGER)) {
            typeId = TYPE_FTP;
        } else if (type.equals(COM_APTANA_IDE_IO_SFTP_SFTP_VIRTUAL_FILE_MANAGER)) {
            typeId = TYPE_SFTP;
        } else if (type.equals(COM_APTANA_IDE_IO_FTPS_FTPS_VIRTUAL_FILE_MANAGER)) {
            typeId = TYPE_FTPS;
        }
        if (typeId != null && (element = this.configurationElements.get(typeId)) != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof ConnectionPoint && !(connectionPoint = (ConnectionPoint)object).load15Data(data)) {
            return null;
        }
        return connectionPoint;
    }

    @Override
    public IConnectionPoint createConnectionPoint(ConnectionPointType type) throws CoreException {
        if (type != null) {
            return this.createConnectionPoint(type.getType());
        }
        return null;
    }

    @Override
    public IConnectionPoint createConnectionPoint(String typeId) throws CoreException {
        Object object;
        ConnectionPoint connectionPoint = null;
        IConfigurationElement element = this.configurationElements.get(typeId);
        if (element != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof ConnectionPoint) {
            connectionPoint = (ConnectionPoint)object;
        }
        return connectionPoint;
    }

    @Override
    public void addConnectionPointListener(IConnectionPointListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeConnectionPointListener(IConnectionPointListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.core.io", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                ConnectionPointManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newInOrderSet((Object[])new String[]{ConnectionPointManager.TAG_CONNECTION_POINT_CATEGORY, ConnectionPointManager.TAG_CONNECTION_POINT_TYPE});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_CONNECTION_POINT_CATEGORY.equals(element.getName())) {
            String id = element.getAttribute("id");
            if (id == null || id.length() == 0) {
                return;
            }
            String name = element.getAttribute(ATT_NAME);
            if (name == null || name.length() == 0) {
                return;
            }
            int order = 127;
            try {
                order = Integer.parseInt(element.getAttribute(ATT_ORDER));
            }
            catch (NumberFormatException e) {
                e.getCause();
            }
            boolean remote = Boolean.parseBoolean(element.getAttribute(ATT_REMOTE));
            this.categories.put(id, new ConnectionPointCategory(id, name, order, remote));
            IdeLog.logInfo((Plugin)CoreIOPlugin.getDefault(), (String)MessageFormat.format("Loaded connection point category {0}. id: {1}, order: {2}, remote: {3}", name, id, order, remote), (String)"com.aptana.core.io/debug/connections");
        } else if (TAG_CONNECTION_POINT_TYPE.equals(element.getName())) {
            String clazz;
            String typeId = element.getAttribute("id");
            if (typeId == null || typeId.length() == 0) {
                return;
            }
            String name = element.getAttribute(ATT_NAME);
            if (name == null || name.length() == 0) {
                return;
            }
            String categoryId = element.getAttribute(ATT_CATEGORY);
            if (categoryId == null || categoryId.length() == 0) {
                categoryId = "";
            }
            if ((clazz = element.getAttribute(ATT_CLASS)) == null || clazz.length() == 0) {
                return;
            }
            this.configurationElements.put(typeId, element);
            ConnectionPointCategory category = this.categories.get(categoryId);
            if (category == null && (category = this.categories.get(DEFAULT_CATEGORY_ID)) == null) {
                category = new ConnectionPointCategory(DEFAULT_CATEGORY_ID, Messages.ConnectionPointManager_CategoryUnknown, Integer.MAX_VALUE, true);
                this.categories.put(DEFAULT_CATEGORY_ID, category);
            }
            ConnectionPointType type = new ConnectionPointType(typeId, name, category);
            this.types.add(type);
            category.addType(type);
            IdeLog.logInfo((Plugin)CoreIOPlugin.getDefault(), (String)MessageFormat.format("Loaded connection point type {0}. id: {1}, category: {2}", name, typeId, category), (String)"com.aptana.core.io/debug/connections");
        }
    }
}

