/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.io.ConnectionPointManager;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ConnectionPointCategory
implements IConnectionPointCategory {
    private final String id;
    private final String name;
    private final int order;
    private final boolean remote;
    private List<ConnectionPointType> types = new ArrayList<ConnectionPointType>();

    protected ConnectionPointCategory(String id, String name, int order) {
        this(id, name, order, false);
    }

    protected ConnectionPointCategory(String id, String name, int order, boolean remote) {
        this.id = id;
        this.name = name;
        this.order = order;
        this.remote = remote;
    }

    @Override
    public int compareTo(Object o) {
        if (this.order != ((ConnectionPointCategory)o).order) {
            return this.order - ((ConnectionPointCategory)o).order;
        }
        return this.name.compareTo(((ConnectionPointCategory)o).name);
    }

    void addType(ConnectionPointType type) {
        this.types.add(type);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IConnectionPoint[] getConnectionPoints() {
        ArrayList<IConnectionPoint> list = new ArrayList<IConnectionPoint>();
        for (ConnectionPointType type : this.types) {
            list.addAll(Arrays.asList(ConnectionPointManager.getInstance().getConnectionPointsForType(type.getType())));
        }
        return list.toArray(new IConnectionPoint[list.size()]);
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPointCategory)) {
            return false;
        }
        ConnectionPointCategory other = (ConnectionPointCategory)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

