/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.io.vfs;

import com.aptana.core.io.vfs.IConnectionFileManager;
import com.aptana.core.io.vfs.Messages;
import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;

public class VirtualConnectionManager {
    private static final String ROOT_STRING = "/";
    private static VirtualConnectionManager instance;
    private Map<ConnectionPoint, URI> connections = new WeakHashMap<ConnectionPoint, URI>();
    private Map<URI, WeakReference<ConnectionPoint>> uris = new HashMap<URI, WeakReference<ConnectionPoint>>();

    private VirtualConnectionManager() {
    }

    public static VirtualConnectionManager getInstance() {
        if (instance == null) {
            instance = new VirtualConnectionManager();
        }
        return instance;
    }

    public void register(ConnectionPoint connectionPoint) {
        Assert.isNotNull((Object)connectionPoint);
        if (this.connections.containsKey(connectionPoint)) {
            URI uri = this.getConnectionVirtualURI(connectionPoint);
            if (uri != null) {
                this.uris.remove(uri);
            }
            this.connections.put(connectionPoint, null);
        }
        this.getConnectionVirtualURI(connectionPoint);
    }

    public URI getConnectionVirtualURI(ConnectionPoint connectionPoint) {
        URI uri = this.connections.get(connectionPoint);
        if (uri == null) {
            try {
                String id = connectionPoint.getId();
                if (id == null || id.length() == 0) {
                    id = UUID.randomUUID().toString();
                }
                uri = new URI("aptanavfs", id, ROOT_STRING, null, null);
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
            }
            this.connections.put(connectionPoint, uri);
            if (uri != null) {
                this.uris.put(uri, new WeakReference<ConnectionPoint>(connectionPoint));
            }
        }
        return uri;
    }

    private IConnectionPoint getConnectionPoint(URI uri) {
        uri = VirtualConnectionManager.getVirtualRootURI(uri);
        IConnectionPoint connectionPoint = null;
        WeakReference<ConnectionPoint> weakReference = this.uris.get(uri);
        if (weakReference != null && (connectionPoint = (IConnectionPoint)weakReference.get()) == null && !this.connections.containsValue(uri)) {
            this.uris.remove(uri);
        }
        if (connectionPoint == null) {
            IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)MessageFormat.format(Messages.VirtualConnectionManager_NoMatchingConnectionForURI, uri.toASCIIString()));
        }
        return connectionPoint;
    }

    public static URI getVirtualRootURI(URI uri) {
        if (!ROOT_STRING.equals(uri.getPath()) || uri.getFragment() != null) {
            try {
                uri = new URI(uri.getScheme(), uri.getAuthority(), ROOT_STRING, null, null);
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
            }
        }
        return uri;
    }

    public IConnectionFileManager getVirtualFileManager(URI uri) {
        IConnectionPoint connectionPoint = this.getConnectionPoint(uri);
        if (connectionPoint != null) {
            return (IConnectionFileManager)connectionPoint.getAdapter(IConnectionFileManager.class);
        }
        return null;
    }
}

