/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.io.efs;

import com.aptana.core.io.efs.Messages;
import com.aptana.core.io.efs.WorkspaceFile;
import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public class WorkspaceFileSystem
extends FileSystem {
    protected static final String SCHEME_WORKSPACE = "workspace";
    private static IFileSystem instance;

    public WorkspaceFileSystem() {
        WorkspaceFileSystem.setInstance(this);
    }

    private static void setInstance(WorkspaceFileSystem object) {
        instance = object;
    }

    public static IFileSystem getInstance() {
        if (instance == null) {
            try {
                instance = EFS.getFileSystem((String)SCHEME_WORKSPACE);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public int attributes() {
        return EFS.getLocalFileSystem().attributes();
    }

    public boolean canDelete() {
        return EFS.getLocalFileSystem().canDelete();
    }

    public boolean canWrite() {
        return EFS.getLocalFileSystem().canWrite();
    }

    public IFileStore fromLocalFile(File file) {
        return WorkspaceFile.fromLocalFile(file);
    }

    public IFileStore getStore(IPath path) {
        return new WorkspaceFile(path);
    }

    public IFileStore getStore(URI uri) {
        return new WorkspaceFile((IPath)new Path(uri.getPath()));
    }

    public IFileTree fetchFileTree(IFileStore root, IProgressMonitor monitor) {
        if (root instanceof WorkspaceFile) {
            try {
                return ((WorkspaceFile)root).fetchFileTree(null, monitor);
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)Messages.WorkspaceFileSystem_FetchingTreeError, (Throwable)e);
            }
        }
        return null;
    }

    public boolean isCaseSensitive() {
        return EFS.getLocalFileSystem().isCaseSensitive();
    }
}

