/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui.breakpoints;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.core.RubyDebugModel;
import com.aptana.ruby.debug.core.model.IRubyExceptionBreakpoint;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.breakpoints.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class AddExceptionAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String DIALOG_SETTINGS = "AddExceptionDialog";
    private IWorkbenchWindow fWorkbenchWindow = null;

    public void run(IAction action) {
        InputDialog dialog = new InputDialog(this.fWorkbenchWindow.getShell(), Messages.AddExceptionAction_InputTitle, Messages.AddExceptionAction_InputMessage, Messages.AddExceptionAction_DefaultInput, new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.trim().length() == 0) {
                    return Messages.AddExceptionAction_ERR_EmptyInput;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            try {
                this.createBreakpoint(dialog.getValue());
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    private void createBreakpoint(String type) throws CoreException {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(RubyDebugModel.getModelIdentifier());
        boolean exists = false;
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IRubyExceptionBreakpoint exceptionBreakpoint;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IRubyExceptionBreakpoint && (exceptionBreakpoint = (IRubyExceptionBreakpoint)breakpoint).getTypeName().equals(type)) {
                exists = true;
                break;
            }
            ++n2;
        }
        if (exists) {
            return;
        }
        new Job("AddExceptionAction", (IResource)resource, type){
            private final /* synthetic */ IResource val$resource;
            private final /* synthetic */ String val$type;
            {
                this.val$resource = iResource;
                this.val$type = string;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RubyDebugModel.createExceptionBreakpoint((IResource)this.val$resource, (String)this.val$type, (boolean)true, null);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                    return e.getStatus();
                }
            }
        }.schedule();
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.fWorkbenchWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }
}

