/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.ui.launcher;

import com.aptana.ruby.debug.ui.launcher.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RubyConnectTab
extends AbstractLaunchConfigurationTab {
    private Text fHostText;
    private Text fPortText;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 3);
        Label hostlabel = new Label(comp, 0);
        hostlabel.setText(Messages.RubyConnectTab_HostLabel);
        GridData gd = new GridData(1);
        hostlabel.setLayoutData((Object)gd);
        hostlabel.setFont(font);
        this.fHostText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fHostText.setLayoutData((Object)gd);
        this.fHostText.setFont(font);
        this.fHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.RubyConnectTab_PortLabel);
        gd = new GridData(1);
        portLabel.setLayoutData((Object)gd);
        portLabel.setFont(font);
        this.fPortText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fPortText.setLayoutData((Object)gd);
        this.fPortText.setFont(font);
        this.fPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_REMOTE_HOST", "localhost");
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_REMOTE_PORT", "1234");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String host;
            String port = configuration.getAttribute("com.aptana.ruby.debug.ATTR_REMOTE_PORT", "1234");
            if (port != null) {
                this.fPortText.setText(port);
            }
            if ((host = configuration.getAttribute("com.aptana.ruby.debug.ATTR_REMOTE_HOST", "localhost")) != null) {
                this.fHostText.setText(host);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String host = this.fHostText.getText().trim();
        if (host.length() == 0) {
            host = null;
        }
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_REMOTE_HOST", host);
        String port = this.fPortText.getText().trim();
        if (port.length() == 0) {
            port = null;
        }
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_REMOTE_PORT", port);
    }

    public String getName() {
        return Messages.RubyConnectTab_Name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String port;
        String host = this.fHostText.getText();
        if (host.length() == 0) {
            this.setMessage(Messages.RubyConnectTab_EmptyHostError);
        }
        if ((port = this.fPortText.getText()).length() == 0) {
            this.setMessage(Messages.RubyConnectTab_EmptyPortError);
        }
        try {
            int portValue = Integer.parseInt(port);
            if (portValue < 1) {
                this.setMessage(Messages.RubyConnectTab_NegativePortError);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(Messages.RubyConnectTab_NonIntegerPortError);
        }
        return super.isValid(launchConfig);
    }
}

