/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.ui.launcher;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.debug.ui.launcher.DirectorySelector;
import com.aptana.ruby.debug.ui.launcher.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RubyArgumentsTab
extends AbstractLaunchConfigurationTab {
    protected Text interpreterArgsText;
    protected Text programArgsText;
    protected DirectorySelector workingDirectorySelector;

    public void createControl(Composite parent) {
        Composite composite = this.createPageRoot(parent);
        new Label(composite, 0).setText(Messages.RubyArgumentsTab_interpreter_args_box_title);
        this.interpreterArgsText = new Text(composite, 2562);
        this.interpreterArgsText.setLayoutData((Object)new GridData(1808));
        this.interpreterArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite, 0).setText(Messages.RubyArgumentsTab_program_args_box_title);
        this.programArgsText = new Text(composite, 2562);
        this.programArgsText.setLayoutData((Object)new GridData(1808));
        this.programArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite, 0);
        new Label(composite, 0).setText(Messages.RubyArgumentsTab_working_dir);
        this.workingDirectorySelector = new DirectorySelector(composite);
        this.workingDirectorySelector.setBrowseDialogMessage(Messages.RubyArgumentsTab_working_dir_browser_message);
        this.workingDirectorySelector.setLayoutData(new GridData(768));
        this.workingDirectorySelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_VM_ARGUMENTS", null);
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_PROGRAM_ARGUMENTS", null);
        configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "com.aptana.ruby.debug.core.sourceLocator");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String workingDirectory = "";
        String interpreterArgs = "";
        String programArgs = "";
        try {
            workingDirectory = configuration.getAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", "");
            interpreterArgs = configuration.getAttribute("com.aptana.ruby.debug.ATTR_VM_ARGUMENTS", "");
            programArgs = configuration.getAttribute("com.aptana.ruby.debug.ATTR_PROGRAM_ARGUMENTS", "");
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.workingDirectorySelector.setSelectionText(workingDirectory);
        this.interpreterArgsText.setText(interpreterArgs);
        this.programArgsText.setText(programArgs);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", this.workingDirectorySelector.getValidatedSelectionText());
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_VM_ARGUMENTS", this.interpreterArgsText.getText());
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_PROGRAM_ARGUMENTS", this.programArgsText.getText());
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.numColumns = 1;
        composite.setLayout((Layout)compositeLayout);
        this.setControl((Control)composite);
        return composite;
    }

    public String getName() {
        return Messages.RubyArgumentsTab_name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String workingDirectory = launchConfig.getAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", "");
            if (workingDirectory.length() == 0) {
                this.setErrorMessage(Messages.RubyArgumentsTab_working_dir_error_message);
                return false;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable t) {
        IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)t);
    }

    public Image getImage() {
        return RubyDebugUIPlugin.getDefault().getImageRegistry().get("icons/full/eview16/arguments_tab.gif");
    }
}

