/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.ui.breakpoints;

import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.breakpoints.AbstractRubyBreakpointEditor;
import com.aptana.ruby.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;

public final class RubyBreakpointConditionEditor
extends AbstractRubyBreakpointEditor {
    private Button fConditional;
    private SourceViewer fViewer;
    private IRubyLineBreakpoint fBreakpoint;
    private IDocumentListener fDocumentListener;
    public static final int PROP_CONDITION = 4097;
    public static final int PROP_CONDITION_ENABLED = 4098;

    @Override
    public void addPropertyListener(IPropertyListener listener) {
        super.addPropertyListener(listener);
    }

    @Override
    public void removePropertyListener(IPropertyListener listener) {
        super.removePropertyListener(listener);
    }

    @Override
    public void setInput(Object input) throws CoreException {
        if (input instanceof IRubyLineBreakpoint) {
            this.setBreakpoint((IRubyLineBreakpoint)input);
        } else {
            this.setBreakpoint(null);
        }
    }

    private void setBreakpoint(IRubyLineBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
        this.fViewer.unconfigure();
        Document document = new Document();
        this.fViewer.setInput((Object)document);
        String condition = null;
        boolean controlsEnabled = false;
        boolean conditionEnabled = false;
        if (breakpoint != null) {
            controlsEnabled = true;
            if (breakpoint.supportsCondition()) {
                condition = breakpoint.getCondition();
                conditionEnabled = breakpoint.isConditionEnabled();
            }
        }
        document.set(condition == null ? "" : condition);
        this.fViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(10));
        this.fViewer.getUndoManager().connect((ITextViewer)this.fViewer);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                RubyBreakpointConditionEditor.this.setDirty(4097);
            }
        };
        this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
        this.fConditional.setEnabled(controlsEnabled);
        this.fConditional.setSelection(conditionEnabled);
        this.setEnabled(conditionEnabled && breakpoint != null && breakpoint.supportsCondition(), false);
        this.setDirty(false);
    }

    @Override
    public Control createControl(Composite parent) {
        Composite controls = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)768, (int)0, (int)0);
        this.fConditional = new Button(controls, 32);
        this.fConditional.setText(this.processMnemonics(PropertyPageMessages.RubyBreakpointConditionEditor_0));
        this.fConditional.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fConditional.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = RubyBreakpointConditionEditor.this.fConditional.getSelection();
                RubyBreakpointConditionEditor.this.setEnabled(checked, true);
                RubyBreakpointConditionEditor.this.setDirty(4098);
            }
        });
        this.fViewer = new SourceViewer(parent, null, 0x2000B00);
        this.fViewer.setEditable(false);
        ControlDecoration decoration = new ControlDecoration(this.fViewer.getControl(), 16512);
        decoration.setShowOnlyOnFocus(true);
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(dec.getImage());
        decoration.setDescriptionText(dec.getDescription());
        GridData gd = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)this.fViewer.getTextWidget());
        gc.setFont(this.fViewer.getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)40);
        gc.dispose();
        this.fViewer.getControl().setLayoutData((Object)gd);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RubyBreakpointConditionEditor.this.dispose();
            }
        });
        return parent;
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        }
    }

    @Override
    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    @Override
    public void doSave() throws CoreException {
        if (this.fBreakpoint != null && this.isDirty()) {
            this.fBreakpoint.setCondition(this.fViewer.getDocument().get().trim());
            this.fBreakpoint.setConditionEnabled(this.fConditional.getSelection());
            this.fBreakpoint.setConditionSuspendOnTrue(true);
            this.setDirty(false);
        }
    }

    @Override
    public IStatus getStatus() {
        if (this.fBreakpoint != null && this.fBreakpoint.supportsCondition() && this.fConditional.getSelection() && this.fViewer.getDocument().get().trim().length() == 0) {
            return new Status(4, RubyDebugUIPlugin.getUniqueIdentifier(), PropertyPageMessages.BreakpointConditionEditor_1);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty();
    }

    @Override
    public void setMnemonics(boolean mnemonics) {
        super.setMnemonics(mnemonics);
    }

    private void setEnabled(boolean enabled, boolean focus) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        if (enabled) {
            this.fViewer.getTextWidget().setBackground(null);
            if (focus) {
                this.setFocus();
            }
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
        }
    }

    @Override
    public Object getInput() {
        return this.fBreakpoint;
    }
}

