/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.core.model.IRubyVariable;
import com.aptana.ruby.debug.ui.Messages;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.StorageEditorInput;
import com.aptana.ruby.ui.RubyUIPlugin;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class RubyModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    protected Map<String, Object> fAttributes = new HashMap<String, Object>(3);

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        this.fAttributes.put(attribute, value);
    }

    public Image getImage(Object element) {
        try {
            IBreakpoint breakpoint;
            if (element instanceof IVariable) {
                return this.getVariableImage((IVariable)element);
            }
            if (element instanceof IBreakpoint) {
                return this.getBreakpointImage((IBreakpoint)element);
            }
            if (element instanceof IMarker && (breakpoint = this.getBreakpoint((IMarker)element)) != null) {
                return this.getBreakpointImage(breakpoint);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return super.getImage(element);
    }

    private Image getBreakpointImage(IBreakpoint breakpoint) throws CoreException {
        if (breakpoint.isEnabled()) {
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
        }
        return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
    }

    protected Image getVariableImage(IVariable variable) throws DebugException {
        if (variable instanceof IRubyVariable) {
            IRubyVariable rubyVar = (IRubyVariable)variable;
            if (rubyVar.isConstant()) {
                return RubyUIPlugin.getDefault().getImageRegistry().get("icons/full/obj16/constant_obj.png");
            }
            if (rubyVar.isLocal()) {
                return RubyUIPlugin.getDefault().getImageRegistry().get("icons/full/obj16/local_var_obj.png");
            }
            if (rubyVar.isInstance()) {
                return RubyUIPlugin.getDefault().getImageRegistry().get("icons/full/obj16/instance_var_obj.png");
            }
            if (rubyVar.isStatic()) {
                return RubyUIPlugin.getDefault().getImageRegistry().get("icons/full/obj16/class_var_obj.png");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
        }
        return null;
    }

    public String getText(Object element) {
        try {
            IBreakpoint breakpoint;
            if (element instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element);
            }
            if (element instanceof IVariable) {
                return this.getVariableText((IVariable)element);
            }
            if (element instanceof IValue) {
                return this.getValueText((IValue)element);
            }
            if (element instanceof IMarker && (breakpoint = this.getBreakpoint((IMarker)element)) != null) {
                return this.getBreakpointText(breakpoint);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    private String getBreakpointText(IBreakpoint element) {
        if (element instanceof IRubyLineBreakpoint) {
            try {
                IRubyLineBreakpoint rlbp = (IRubyLineBreakpoint)element;
                return MessageFormat.format("{0} [line: {1}]", rlbp.getFilePath().toPortableString(), rlbp.getLineNumber());
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        IFile file = this.getFile(element);
        if (file != null) {
            return new FileEditorInput(file);
        }
        if (element instanceof IStorage) {
            return new StorageEditorInput((IStorage)element);
        }
        IFileStore store = this.getFileStore(element);
        if (store != null) {
            return new FileStoreEditorInput(store);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IEditorDescriptor desc = null;
        IFile file = this.getFile(element);
        if (file != null && (desc = IDE.getDefaultEditor((IFile)file)) != null) {
            return desc.getId();
        }
        String filename = null;
        if (element instanceof IStorage) {
            IStorage storage = (IStorage)element;
            filename = storage.getName();
        } else {
            IFileStore store = this.getFileStore(element);
            if (store != null) {
                filename = store.getName();
            }
        }
        if (filename == null) {
            return null;
        }
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(filename);
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        desc = editorReg.getDefaultEditor(filename, contentType);
        if (desc != null) {
            return desc.getId();
        }
        return null;
    }

    private IFile getFile(Object element) {
        IResource resource;
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof ILineBreakpoint && (resource = ((ILineBreakpoint)element).getMarker().getResource()) instanceof IFile) {
            return (IFile)resource;
        }
        if (element instanceof LocalFileStorage) {
            File file = ((LocalFileStorage)element).getFile();
            IFile resource2 = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
            if (resource2 != null) {
                return resource2;
            }
        }
        return null;
    }

    private IFileStore getFileStore(Object element) {
        if (element instanceof IRubyLineBreakpoint) {
            try {
                IPath fileName = ((IRubyLineBreakpoint)element).getLocation();
                return EFS.getStore((URI)fileName.toFile().toURI());
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String getVariableText(IVariable variable) {
        StringBuilder sb = new StringBuilder();
        if (this.showVariableTypeNames()) {
            String typeName = Messages.RubyModelPresentation_UnknownType;
            try {
                typeName = variable.getReferenceTypeName();
            }
            catch (DebugException debugException) {}
            sb.append(typeName).append(' ');
        }
        String varLabel = Messages.RubyModelPresentation_UnknownName;
        try {
            varLabel = variable.getName();
        }
        catch (DebugException debugException) {}
        sb.append(varLabel);
        IValue value = null;
        try {
            value = variable.getValue();
        }
        catch (DebugException debugException) {}
        String valueString = Messages.RubyModelPresentation_UnknwonValue;
        if (value != null) {
            try {
                valueString = this.getValueText(value);
            }
            catch (DebugException debugException) {}
        }
        if (valueString.length() != 0) {
            sb.append(" = ");
            sb.append(valueString);
        }
        return sb.toString();
    }

    protected boolean showVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected String getValueText(IValue value) throws DebugException {
        return value.getValueString();
    }
}

