/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.model;

import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.debug.core.model.IRubyThread;
import com.aptana.ruby.internal.debug.core.RubyDebuggerProxy;
import com.aptana.ruby.internal.debug.core.SuspensionPoint;
import com.aptana.ruby.internal.debug.core.model.RubyDebugElement;
import com.aptana.ruby.internal.debug.core.model.RubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyStackFrame;
import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;

public class RubyThread
extends RubyDebugElement
implements IRubyThread {
    private RubyStackFrame[] frames;
    private boolean isSuspended = false;
    private boolean isTerminated = false;
    private boolean isStepping = false;
    private String name;
    private String status;
    private int id;
    private ThreadJob fAsyncJob;

    public RubyThread(IDebugTarget target, int id, String status) {
        super(target);
        this.setId(id);
        this.status = status;
        this.updateName();
    }

    public IStackFrame[] getStackFrames() {
        if (this.frames == null) {
            this.createStackFrames();
        }
        return this.frames;
    }

    private synchronized void createStackFrames() {
        if (this.isSuspended()) {
            this.getRubyDebuggerProxy().readFrames(this);
        } else {
            this.frames = new RubyStackFrame[0];
        }
    }

    public int getStackFramesSize() {
        return this.frames.length;
    }

    public boolean hasStackFrames() {
        return this.isSuspended;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames == null || frames.length == 0) {
            return null;
        }
        return frames[0];
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[]{DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier())[0]};
    }

    public boolean canResume() {
        return this.isSuspended;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    protected void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    protected void resume(boolean isStep) {
        this.isStepping = isStep;
        this.isSuspended = false;
        this.updateName();
        this.frames = new RubyStackFrame[0];
    }

    public void resume() throws DebugException {
        this.resume(false);
        ((RubyDebugTarget)this.getDebugTarget()).getRubyDebuggerProxy().resume(this);
        DebugEvent ev = new DebugEvent((Object)this, 1, 32);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{ev});
    }

    public void doSuspend(SuspensionPoint suspensionPoint) {
        int suspensionReason = 0;
        suspensionReason = suspensionPoint.isStep() ? 8 : 16;
        this.frames = null;
        this.isSuspended = true;
        this.isStepping = false;
        this.createName(suspensionPoint);
        DebugEvent ev = new DebugEvent((Object)this, 2, suspensionReason);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{ev});
    }

    public void suspend() {
        this.frames = null;
        this.isStepping = false;
        this.isSuspended = true;
        this.getRubyDebuggerProxy().sendThreadStop(this);
    }

    public boolean canStepInto() {
        return this.isSuspended && this.hasStackFrames();
    }

    public boolean canStepOver() {
        return this.isSuspended && this.hasStackFrames();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        this.isStepping = true;
        this.updateName();
        if (this.frames != null && this.frames.length > 0) {
            this.frames[0].stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (this.frames != null && this.frames.length > 0) {
            this.frames[0].stepOver();
        }
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
        this.isTerminated = true;
        this.frames = null;
    }

    public RubyDebuggerProxy getRubyDebuggerProxy() {
        return ((RubyDebugTarget)this.getDebugTarget()).getRubyDebuggerProxy();
    }

    public void setStackFrames(RubyStackFrame[] frames) {
        this.frames = frames;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void updateName() {
        this.createName(null);
    }

    protected void createName(SuspensionPoint suspensionPoint) {
        this.name = MessageFormat.format("Ruby Thread - {0} ({1})", this.getId(), suspensionPoint != null ? suspensionPoint : this.status);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void queueRunnable(Runnable evaluation) {
        if (this.fAsyncJob == null) {
            this.fAsyncJob = new ThreadJob(this);
        }
        this.fAsyncJob.addRunnable(evaluation);
    }

    static class ThreadJob
    extends Job {
        private Vector<Runnable> fRunnables;
        private RubyThread fJDIThread;

        public ThreadJob(RubyThread thread) {
            super("RDT thread evaluations");
            this.fJDIThread = thread;
            this.fRunnables = new Vector(5);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRunnable(Runnable runnable) {
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                this.fRunnables.add(runnable);
            }
            this.schedule();
        }

        public boolean isEmpty() {
            return this.fRunnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Object[] runnables;
            Vector<Runnable> vector = this.fRunnables;
            synchronized (vector) {
                runnables = this.fRunnables.toArray();
                this.fRunnables.clear();
            }
            MultiStatus failed = null;
            monitor.beginTask(this.getName(), runnables.length);
            int i = 0;
            while (i < runnables.length && !this.fJDIThread.isTerminated() && !monitor.isCanceled()) {
                try {
                    ((Runnable)runnables[i]).run();
                }
                catch (Exception e) {
                    if (failed == null) {
                        failed = new MultiStatus(RubyDebugCorePlugin.getPluginIdentifier(), -1, "Exception processing async thread queue", null);
                    }
                    failed.add((IStatus)new Status(4, RubyDebugCorePlugin.getPluginIdentifier(), -1, "Exception processing async thread queue", (Throwable)e));
                }
                ++i;
                monitor.worked(1);
            }
            monitor.done();
            if (failed == null) {
                return Status.OK_STATUS;
            }
            return failed;
        }

        public boolean shouldRun() {
            return !this.fJDIThread.isTerminated() && !this.fRunnables.isEmpty();
        }
    }
}

