/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.launching;

import com.aptana.ruby.internal.debug.core.RubyDebuggerProxy;
import com.aptana.ruby.internal.debug.core.launching.Messages;
import com.aptana.ruby.internal.debug.core.model.RubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyProcessingException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public class RemoteRubyDebuggerLaunchDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        try {
            this.connect(configuration, monitor, launch);
            if (monitor.isCanceled()) {
                IDebugTarget[] debugTargets = launch.getDebugTargets();
                int i = 0;
                while (i < debugTargets.length) {
                    IDebugTarget target = debugTargets[i];
                    if (target.canDisconnect()) {
                        target.disconnect();
                    }
                    ++i;
                }
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void connect(ILaunchConfiguration configuration, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(Messages.SocketAttachConnector_Connecting____1, 2);
        subMonitor.subTask(Messages.SocketAttachConnector_Configuring_connection____1);
        String portNumberString = configuration.getAttribute("com.aptana.ruby.debug.ATTR_REMOTE_PORT", null);
        if (portNumberString == null) {
            this.abort(Messages.SocketAttachConnector_Port_unspecified_for_remote_connection__2, null, 111);
        }
        int port = Integer.parseInt(portNumberString);
        String host = configuration.getAttribute("com.aptana.ruby.debug.ATTR_REMOTE_HOST", null);
        if (host == null) {
            this.abort(Messages.SocketAttachConnector_Hostname_unspecified_for_remote_connection__4, null, 109);
        }
        subMonitor.worked(1);
        subMonitor.subTask(Messages.SocketAttachConnector_Establishing_connection____2);
        try {
            RubyDebugTarget debugTarget = new RubyDebugTarget(launch, host, port);
            RubyDebuggerProxy proxy = new RubyDebuggerProxy(debugTarget, true);
            proxy.start();
            launch.addDebugTarget((IDebugTarget)debugTarget);
            subMonitor.worked(1);
            subMonitor.done();
        }
        catch (IOException e) {
            this.abort(Messages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, e, 113);
        }
        catch (RubyProcessingException e) {
            this.abort(Messages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, e, 113);
        }
    }

    private void abort(String message, Throwable e, int errorCode) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "com.aptana.ruby.debug", errorCode, message, e));
    }
}

