/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.commands;

import com.aptana.ruby.internal.debug.core.DebuggerNotFoundException;
import com.aptana.ruby.internal.debug.core.commands.AbstractDebuggerConnection;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReader;
import java.io.IOException;

public abstract class AbstractCommand {
    private String command;
    private boolean isControl;
    private XmlStreamReader resultReader;

    protected AbstractCommand(String command, boolean isControl) {
        this.command = command;
        this.isControl = isControl;
    }

    public void execute(AbstractDebuggerConnection debuggerConnection) throws DebuggerNotFoundException, IOException {
        AbstractReadStrategy readStrategy = debuggerConnection.sendCommand(this);
        this.resultReader = this.createResultReader(readStrategy);
    }

    protected abstract XmlStreamReader createResultReader(AbstractReadStrategy var1);

    public XmlStreamReader getResultReader() {
        if (!this.isExecuted()) {
            throw new IllegalStateException("getResultReader must only be called after the command was executed.");
        }
        return this.resultReader;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isControl() {
        return this.isControl;
    }

    public boolean isExecuted() {
        return this.resultReader != null;
    }
}

