/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.core;

import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.core.IRubyMethodBreakpoint;
import com.aptana.ruby.debug.core.model.IRubyExceptionBreakpoint;
import com.aptana.ruby.internal.debug.core.breakpoints.RubyExceptionBreakpoint;
import com.aptana.ruby.internal.debug.core.breakpoints.RubyLineBreakpoint;
import com.aptana.ruby.internal.debug.core.breakpoints.RubyMethodBreakpoint;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class RubyDebugModel {
    public static IRubyExceptionBreakpoint createExceptionBreakpoint(IResource resource, String exceptionName, boolean register, Map<String, Object> attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap<String, Object>(10);
        }
        return new RubyExceptionBreakpoint(resource, exceptionName, register, attributes);
    }

    public static IRubyLineBreakpoint createLineBreakpoint(IResource resource, IPath fileName, String typeName, int lineNumber, boolean register, Map<String, Object> attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap<String, Object>(10);
        }
        return new RubyLineBreakpoint(resource, fileName, typeName, lineNumber, -1, -1, 0, register, attributes);
    }

    public static IRubyLineBreakpoint lineBreakpointExists(IResource resource, String typeName, int lineNumber) throws CoreException {
        if (resource == null) {
            return null;
        }
        String modelId = RubyDebugModel.getModelIdentifier();
        String markerType = RubyLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            String breakpointTypeName;
            IMarker marker;
            IRubyLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof IRubyLineBreakpoint && (breakpoint = (IRubyLineBreakpoint)breakpoints[i]) != null && (marker = breakpoint.getMarker()) != null && marker.exists() && marker.getType().equals(markerType) && RubyDebugModel.equals(breakpointTypeName = breakpoint.getTypeName(), typeName) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    private static boolean equals(String breakpointTypeName, String typeName) {
        if (breakpointTypeName == null) {
            return typeName == null;
        }
        return breakpointTypeName.equals(typeName);
    }

    public static String getModelIdentifier() {
        return "com.aptana.ruby.debug";
    }

    public static IRubyMethodBreakpoint createMethodBreakpoint(IResource resource, String typePattern, String methodName, boolean entry, boolean exit, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map<String, Object> attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap<String, Object>(10);
        }
        return new RubyMethodBreakpoint(resource, typePattern, methodName, entry, exit, lineNumber, charStart, charEnd, hitCount, register, attributes);
    }
}

