/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class RubyDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.ruby.debug.core";
    protected static RubyDebugCorePlugin plugin;

    public static Plugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static void log(int severity, String message) {
        RubyDebugCorePlugin.log((IStatus)new Status(severity, PLUGIN_ID, 0, message, null));
    }

    public static void log(String message, Throwable e) {
        RubyDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, e));
    }

    private static void log(IStatus status) {
        if (RubyDebugCorePlugin.getDefault() != null) {
            RubyDebugCorePlugin.getDefault().getLog().log(status);
        } else {
            System.out.println("Error: ");
            System.out.println(status.getMessage());
        }
    }

    public static void log(Throwable e) {
        RubyDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getMessage(), e));
    }

    public static void debug(Object message) {
        if (RubyDebugCorePlugin.getDefault() != null && RubyDebugCorePlugin.getDefault().isDebugging()) {
            System.out.println(message.toString());
        } else {
            System.out.println(message.toString());
        }
    }

    public static void debug(String message, Throwable e) {
        if (RubyDebugCorePlugin.getDefault() != null && RubyDebugCorePlugin.getDefault().isDebugging()) {
            System.out.println(String.valueOf(message) + ", Exception: " + e.getMessage());
            RubyDebugCorePlugin.log(e);
        } else {
            System.out.println(message);
            e.printStackTrace();
        }
    }

    public static boolean isRubyDebuggerVerbose() {
        String rubyDebuggerVerboseOption = Platform.getDebugOption((String)"com.aptana.ruby.debug.core/rubyDebuggerVerbose");
        return rubyDebuggerVerboseOption == null ? false : rubyDebuggerVerboseOption.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public static String getPluginIdentifier() {
        return PLUGIN_ID;
    }
}

