/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.validator;

import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.index.core.build.BuildContext;
import com.helger.css.ECSSVersion;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.CSSReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;

public class PhlocCssValidator
extends AbstractRemoteBuildParticipant {
    public static final String ID = "com.aptana.editor.css.validator.PhlocCssValidator";
    protected static String EOL = System.getProperty("line.separator", "\n");

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.css.phloccss_problem", problems);
    }

    public boolean needBuildFile(BuildContext context) {
        return this.needValidatorBuildFile(context);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !this.needBuildFile(context)) {
            return;
        }
        List<IProblem> problems = this.detectErrors(context, monitor);
        context.putProblems("com.aptana.editor.css.phloccss_problem", problems);
    }

    public List<IProblem> detectErrors(BuildContext context, IProgressMonitor monitor) {
        List<IProblem> problems = Collections.emptyList();
        String sourcePath = context.getURI().toString();
        try {
            problems = this.parseWithPhlocCss(context.getContents(), sourcePath, monitor);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} with Phloc-Css", sourcePath), (Throwable)e);
        }
        return problems;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.css.phloccss_problem");
    }

    protected List<IProblem> parseWithPhlocCss(String source, final String path, IProgressMonitor monitor) {
        final ArrayList problems = new ArrayList();
        CSSReader.setDefaultParseExceptionHandler((ICSSParseExceptionCallback)new ICSSParseExceptionCallback(){

            public void onException(ParseException ex) {
                Token token = ex.currentToken.next;
                int length = token.endColumn - token.beginColumn;
                String msg = PhlocCssValidator.initialise(ex);
                problems.add(PhlocCssValidator.this.createError(msg, token.beginLine, token.beginColumn, length > 0 ? length : 1, path));
            }
        });
        long start = System.currentTimeMillis();
        CSSReader.readFromString((String)source, (Charset)Charset.forName("utf-8"), (ECSSVersion)ECSSVersion.CSS30);
        IdeLog.logInfo((Plugin)CSSPlugin.getDefault(), (String)("css\u9a8c\u8bc1\u8017\u65f6: " + (System.currentTimeMillis() - start)));
        final List filters = this.getFilters();
        List result = CollectionsUtil.filter(problems, (IFilter)new IFilter<IProblem>(){

            public boolean include(IProblem item) {
                return !PhlocCssValidator.this.isIgnored(item.getMessage(), filters);
            }
        });
        Document doc = new Document(source);
        for (IProblem problem : problems) {
            try {
                IRegion lineInfo = doc.getLineInformation(problem.getLineNumber() - 1);
                int realOffset = lineInfo.getOffset();
                String rawLine = doc.get(realOffset, lineInfo.getLength());
                int lineLength = rawLine.length();
                int actual = problem.getOffset() - 1;
                int x = 0;
                while (x < actual) {
                    if (lineLength <= x) break;
                    ++realOffset;
                    ++x;
                }
                if (!(problem instanceof Problem)) continue;
                ((Problem)problem).setOffset(realOffset);
            }
            catch (BadLocationException badLocationException) {}
        }
        return result;
    }

    private static String initialise(ParseException ex) {
        Token token = ex.currentToken;
        int[][] ai = ex.expectedTokenSequences;
        String[] as = ex.tokenImage;
        int i = 0;
        int j = 0;
        while (j < ai.length) {
            if (i < ai[j].length) {
                i = ai[j].length;
            }
            ++j;
        }
        String s = "Unexpected \"";
        Token token1 = token.next;
        for (int l = 0; l < i; ++l) {
            if (l != 0) {
                s = s + " ";
            }
            if (token1.kind == 0) {
                s = s + as[0];
                break;
            }
            s = s + PhlocCssValidator.add_escapes(token1.image);
            token1 = token1.next;
        }
        s = s + "\" at line " + token.next.beginLine + ", column " + token.next.beginColumn;
        s = s + ".";
        return s;
    }

    static String add_escapes(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case '\b': {
                    stringbuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringbuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringbuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringbuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringbuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringbuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringbuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringbuffer.append("\\\\");
                    break;
                }
                default: {
                    char c = s.charAt(i);
                    if (c < ' ' || c > '~') {
                        String s1 = "0000" + Integer.toString(c, 16);
                        stringbuffer.append("\\u" + s1.substring(s1.length() - 4, s1.length()));
                        break;
                    }
                    stringbuffer.append(c);
                }
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public boolean isEnabled() {
        return true;
    }
}

