/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.validator;

import com.aptana.core.IMap;
import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseError;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class CSSParserValidator
extends AbstractRemoteBuildParticipant {
    public static final String ID = "com.aptana.editor.css.validator.CSSParserValidator";

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.css.problem", problems);
    }

    public boolean needBuildFile(BuildContext context) {
        return this.needValidatorBuildFile(context);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !this.needBuildFile(context)) {
            return;
        }
        try {
            context.getAST();
        }
        catch (CoreException coreException) {}
        List<IProblem> problems = this.detectErrors(context);
        context.putProblems("com.aptana.editor.css.problem", problems);
    }

    public List<IProblem> detectErrors(BuildContext context) {
        List problems = Collections.emptyList();
        String path = context.getURI().toString();
        try {
            Collection errorList = context.getParseErrors();
            if (!CollectionsUtil.isEmpty((Collection)errorList)) {
                String source = context.getContents();
                Document doc = new Document(source);
                problems = CollectionsUtil.map((Collection)errorList, (IMap)new IMap<IParseError, IProblem>((IDocument)doc, path){
                    private final /* synthetic */ IDocument val$doc;
                    private final /* synthetic */ String val$path;
                    {
                        this.val$doc = iDocument;
                        this.val$path = string;
                    }

                    public IProblem map(IParseError parseError) {
                        int severity = parseError.getSeverity() == IParseError.Severity.ERROR ? 2 : 1;
                        int line = -1;
                        try {
                            if (this.val$doc != null) {
                                line = this.val$doc.getLineOfOffset(parseError.getOffset()) + 1;
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                        return new Problem(severity, parseError.getMessage(), parseError.getOffset(), parseError.getLength(), line, this.val$path);
                    }
                });
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} for CSS Parser Validation", path), (Throwable)e);
        }
        return problems;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.css.problem");
    }

    public boolean isEnabled() {
        return true;
    }
}

