/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.hyperlink.EditorSearchHyperlink;
import com.aptana.editor.common.text.hyperlink.IndexQueryingHyperlinkDetector;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.scope.ScopeSelector;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.RegularUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class HTMLIDHyperlinkDetector
extends IndexQueryingHyperlinkDetector {
    private static final Pattern HTML_ID = Pattern.compile("#[_a-zA-Z0-9-]+");
    public static final String[] HTML_EXTENDTIONS = new String[]{"rhtml", "html.erb", "htm", "shtml", "xhtml", "phtml", "html"};
    IProject project;
    CSSIndexQueryHelper indexQueryHelper;
    List<String> cssRefrencesList = new ArrayList<String>();

    public HTMLIDHyperlinkDetector() {
        this.indexQueryHelper = new CSSIndexQueryHelper();
    }

    private IFile getIFile(AbstractThemeableEditor part) {
        IFile file = null;
        IEditorInput input = part.getEditorInput();
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        return file;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        AbstractThemeableEditor editor = (AbstractThemeableEditor)((IAdaptable)textViewer).getAdapter(AbstractThemeableEditor.class);
        try {
            String scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(textViewer, region.getOffset());
            ScopeSelector selector = new ScopeSelector("source.css");
            if (!selector.matches(scope)) {
                return null;
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        IHyperlink[] hyperlinks = this.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
        return hyperlinks;
    }

    protected Index getIndex() {
        try {
            return this.getIndexManager().getIndex(this.project.getLocationURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, IRegion region, boolean canShowMultipleHyperlinks) {
        List results;
        String htmlId;
        IFile file;
        Matcher m;
        IRegion lineRegion;
        IDocument doc;
        ArrayList<EditorSearchHyperlink> hyperlinks;
        block10: {
            Index index;
            block9: {
                block8: {
                    this.project = this.getProject(editor);
                    hyperlinks = new ArrayList<EditorSearchHyperlink>();
                    doc = this.getDocument(editor);
                    lineRegion = doc.getLineInformationOfOffset(region.getOffset());
                    String line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
                    m = HTML_ID.matcher(line);
                    if (m.find()) break block8;
                    return null;
                }
                index = this.getIndex();
                if (index != null) break block9;
                return null;
            }
            file = this.getIFile(editor);
            this.getCSSRefrences(index, file);
            htmlId = m.group().substring(1);
            results = index.query(new String[]{"css.identifier"}, htmlId, 8);
            if (results != null && !results.isEmpty()) break block10;
            return null;
        }
        try {
            int start = m.start() + lineRegion.getOffset();
            int length = m.end() - m.start();
            Region linkRegion = new Region(start, length);
            htmlId = "id[\\s]*=[\\s]*[\"']" + htmlId + "[\"']";
            String content = doc.get();
            String iFileP = file.getLocationURI().toString();
            for (QueryResult result : results) {
                Set documents = result.getDocuments();
                if (documents == null || documents.isEmpty()) continue;
                for (String filepath : documents) {
                    IRegion[] regs;
                    if (!this.checkFilePath(filepath, file) || iFileP.equals(filepath) && ((regs = RegularUtils.matchs((String)htmlId, (String)content, (int)0)) == null || regs.length < 1)) continue;
                    URI uri = new URI(filepath);
                    hyperlinks.add(new EditorSearchHyperlink(this.project, (IRegion)linkRegion, htmlId, uri));
                    if (canShowMultipleHyperlinks) continue;
                    return new IHyperlink[]{(IHyperlink)hyperlinks.get(0)};
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    private IDocument getDocument(AbstractThemeableEditor editor) {
        return editor.getDocument();
    }

    private IProject getProject(AbstractThemeableEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IProject project = file.getProject();
            return project;
        }
        return null;
    }

    private void getCSSRefrences(Index index, IFile file) {
        Set<String> set;
        Map<String, Set<String>> map = this.indexQueryHelper.getCSSReferences(index);
        if (map != null && (set = map.get(file.getLocationURI().toString())) != null) {
            this.cssRefrencesList.addAll(set);
        }
    }

    private boolean checkFilePath(String filepath, IFile file) {
        if (HMobileProject.isFilterFolder((String)(filepath = filepath.substring(this.project.getLocationURI().toString().length() + 1)))) {
            return false;
        }
        int index = filepath.lastIndexOf(".");
        String extend = filepath.substring(index + 1);
        if (filepath.equals(file.getProjectRelativePath().toString())) {
            return true;
        }
        if (!StringUtil.contains((String[])HTML_EXTENDTIONS, (String)extend)) {
            return false;
        }
        return this.cssRefrencesList.contains(filepath);
    }
}

