/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing.ast;

import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSTextNode;
import com.aptana.editor.css.parsing.ast.CSSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CSSMediaNode
extends CSSNode {
    private static final String MEDIA = "@media";
    private String fText;
    private CSSNode[] fMediaQuerys;

    public CSSMediaNode(CSSNode media, CSSNode mediaBody, CSSNode ... mediaQuery) {
        this.fMediaQuerys = mediaQuery;
        ArrayList<CSSNode> children = new ArrayList<CSSNode>();
        children.add(media);
        children.addAll(Arrays.asList(mediaQuery));
        children.add(mediaBody);
        this.setChildren((IParseNode[])children.toArray(new CSSNode[children.size()]));
    }

    @Override
    public short getNodeType() {
        return 7;
    }

    @Override
    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof CSSMediaNode)) {
            return false;
        }
        CSSMediaNode other = (CSSMediaNode)((Object)obj);
        return this.toString().equals(other.toString());
    }

    public CSSTextNode[] getMedias() {
        return null;
    }

    public CSSNode[] getStatements() {
        List<IParseNode> list = Arrays.asList(this.getChildren());
        return list.toArray(new CSSNode[list.size()]);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(MEDIA);
        if (this.fMediaQuerys != null) {
            text.append(' ');
            CSSNode[] cSSNodeArray = this.fMediaQuerys;
            int n = this.fMediaQuerys.length;
            int n2 = 0;
            while (n2 < n) {
                CSSNode media = cSSNodeArray[n2];
                text.append((Object)media).append(",");
                ++n2;
            }
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.toString().hashCode();
    }

    public String toString() {
        if (this.fText == null) {
            CSSNode[] statements;
            int n;
            StringBuilder text = new StringBuilder();
            text.append(MEDIA);
            if (this.fMediaQuerys != null) {
                text.append(' ');
                CSSNode[] cSSNodeArray = this.fMediaQuerys;
                n = this.fMediaQuerys.length;
                int n2 = 0;
                while (n2 < n) {
                    CSSNode media = cSSNodeArray[n2];
                    text.append((Object)media).append(",");
                    ++n2;
                }
                text.deleteCharAt(text.length() - 1);
            }
            text.append('{');
            CSSNode[] cSSNodeArray = statements = this.getStatements();
            int n3 = statements.length;
            n = 0;
            while (n < n3) {
                CSSNode statement = cSSNodeArray[n];
                text.append((Object)statement);
                ++n;
            }
            text.append('}');
            this.fText = text.toString();
        }
        return this.fText;
    }
}

