/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing.ast;

import beaver.Symbol;
import com.aptana.editor.css.parsing.ast.CSSExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;

public class CSSDeclarationNode
extends CSSNode {
    private final String fIdentifier;
    private final String fStatus;
    private final int fStatusStart;
    private final int fStatusEnd;
    private boolean fHasSemicolon;

    protected CSSDeclarationNode() {
        this.fStatus = null;
        this.fIdentifier = null;
        this.fStatusStart = 0;
        this.fStatusEnd = -1;
    }

    public CSSDeclarationNode(CSSNode identifier, CSSExpressionNode value) {
        this(identifier, value, null);
    }

    public CSSDeclarationNode(CSSNode identifier, CSSExpressionNode value, Symbol status) {
        this.fIdentifier = identifier.getText();
        if (status != null) {
            this.fStatus = status.value.toString();
            this.fStatusStart = status.getStart();
            this.fStatusEnd = status.getEnd();
        } else {
            this.fStatusStart = 0;
            this.fStatusEnd = -1;
            this.fStatus = null;
        }
        this.addChild((IParseNode)identifier);
        if (value != null) {
            this.addChild((IParseNode)value);
        }
    }

    @Override
    public short getNodeType() {
        return 4;
    }

    @Override
    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CSSDeclarationNode) || !super.equals(obj)) {
            return false;
        }
        CSSDeclarationNode otherDecl = (CSSDeclarationNode)((Object)obj);
        if (this.fIdentifier == null) {
            return otherDecl.fIdentifier == null;
        }
        return this.fIdentifier.equals(otherDecl.fIdentifier) && (this.fStatus == null && otherDecl.fStatus == null || this.fStatus != null && this.fStatus.equals(otherDecl.fStatus)) && this.fHasSemicolon == otherDecl.fHasSemicolon;
    }

    public CSSExpressionNode getAssignedValue() {
        return (CSSExpressionNode)this.getChild(1);
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public String getStatus() {
        return this.fStatus;
    }

    public IRange getStatusRange() {
        return this.fStatus != null ? new Range(this.fStatusStart, this.fStatusEnd) : Range.EMPTY;
    }

    public int hashCode() {
        if (this.fIdentifier == null) {
            return super.hashCode();
        }
        int hash = super.hashCode();
        hash = hash * 31 + this.fIdentifier.hashCode();
        hash = hash * 31 + (this.fStatus == null ? 0 : this.fStatus.hashCode());
        hash = hash * 31 + Boolean.valueOf(this.fHasSemicolon).hashCode();
        return hash;
    }

    public void setHasSemicolon(Symbol semicolon) {
        this.fHasSemicolon = true;
        this.setLocation(this.getStart(), semicolon.getEnd());
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        if (this.fIdentifier != null) {
            text.append(this.fIdentifier);
            text.append(": ").append((Object)this.getAssignedValue());
            if (this.fStatus != null) {
                text.append(' ').append(this.fStatus);
            }
        }
        if (this.fHasSemicolon) {
            text.append(';');
        }
        return text.toString();
    }
}

