/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.internal.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class CSSNumberRule
extends ExtendedWordRule {
    private Pattern pattern;

    public CSSNumberRule(IToken token) {
        super((IWordDetector)new CSSNumberWordDetector(), token, false);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile("[-+]?\\s*[0-9]+(\\.[0-9]+)?");
        }
        return this.pattern.matcher(word).matches();
    }

    private static class CSSNumberWordDetector
    implements IWordDetector {
        private CSSNumberWordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '-' || c == '+' || c == '.' || Character.isDigit(c);
        }

        public boolean isWordPart(char c) {
            return c == '.' || Character.isDigit(c);
        }
    }
}

